/* vim:tabstop=4:expandtab:shiftwidth=4
 * 
 * Idesk -- XIdeskImage.cpp
 *
 * Copyright (c) 2002, Chris (nikon) (nikon@sc.rr.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *      Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *      
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *      
 *      Neither the name of the <ORGANIZATION> nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * (See the included file COPYING / BSD )
 */

#include "XIdeskImage.h"

XIdeskImage::XIdeskImage(AbstractContainer * c, AbstractIcon * iParent,
                         AbstractConfig * con, AbstractIconConfig * iConfig)
                            : AbstractImage(c, iParent, con, iConfig),
                              hasAlpha(false), glowing(false)
{   
    XDesktopContainer * xContainer =
        dynamic_cast<XDesktopContainer *>(container);

    imlibData = xContainer->getImlibData();
    spareRoot = xContainer->getSpareRoot();
}

XIdeskImage::~XIdeskImage()
{   
    delete [] rgb;
    if (hasAlpha)
    {
        delete [] alpha;
        delete [] alpha2;
    }
}

void XIdeskImage::configure()
{
    x = iconParent->getX();
    y = iconParent->getY();

    DesktopIconConfig * dIconConfig =
        dynamic_cast<DesktopIconConfig *>(iconConfig);

    transparency = dIconConfig->getTransparency();
}

void XIdeskImage::createPicture()
{
}


Window * XIdeskImage::getWindow()
{
    return &window;
}

void XIdeskImage::createWindow()
{
    createPicture();

    XDesktopContainer * xContainer =
        dynamic_cast<XDesktopContainer *>(container);

    XSetWindowAttributes attr;

    attr.override_redirect = True;
    attr.event_mask = SubstructureRedirectMask |
                      SubstructureNotifyMask   |
                      ButtonPressMask          |
                      ButtonReleaseMask        |
                      PointerMotionMask        |
                      EnterWindowMask          |
                      PropertyChangeMask       |
                      LeaveWindowMask          /*|
                      ExposureMask*/;

    window = XCreateWindow( xContainer->getDisplay(),
                            xContainer->getRootWindow(),
                            0,
                            0,
                            width,
                            height,
                            0,
                            CopyFromParent,
                            CopyFromParent,
                            CopyFromParent,
                            CWOverrideRedirect|CWEventMask,
                            &attr );
}

void XIdeskImage::lowerWindow()
{
    XDesktopContainer * xContainer =
        dynamic_cast<XDesktopContainer *>(container);

    XLowerWindow( xContainer->getDisplay() , window  );
}

void XIdeskImage::moveWindow(int xCord, int yCord)
{
    XDesktopContainer * xContainer =
        dynamic_cast<XDesktopContainer *>(container);

    XMoveWindow( xContainer->getDisplay() , window, xCord, yCord  );
}

void XIdeskImage::draw()
{
    refreshIcon();
}

void XIdeskImage::unmapWindow()
{
    XDesktopContainer * xContainer =
        dynamic_cast<XDesktopContainer *>(container);

    XUnmapWindow( xContainer->getDisplay(), window );
}

void XIdeskImage::mapWindow()
{
    XDesktopContainer * xContainer =
        dynamic_cast<XDesktopContainer *>(container);

    XMapWindow( xContainer->getDisplay(), window );
}
void XIdeskImage::refreshIcon()
{
    x = iconParent->getX();
    y = iconParent->getY();

    repaint();
}

void XIdeskImage::repaint()
{
    ImlibImage *background;
    unsigned char *bgRgb;

    background = Imlib_crop_and_clone_image(imlibData, spareRoot, x, y, width, height );
    bgRgb = background->rgb_data;

    applyMouseOverEffects(background, bgRgb);
    
    ImlibColor IClr={255,0,255,0};
    Imlib_set_image_shape(imlibData, background, &IClr);
    Imlib_apply_image(imlibData, background, window );
    Imlib_kill_image(imlibData, background );
}

void XIdeskImage::applyMouseOverEffects(ImlibImage * &background,
                                        unsigned char * &bgRgb)
{
    unsigned char *alpha_levels;

    if (glowing)
        alpha_levels = alpha2;
    else
        alpha_levels = alpha;

    for( register int i = 0, a = 0; i < (3 * width * height); i += 3, a++)
    {
        int alvl = ( (alpha_levels != 0) ? alpha_levels[a] : 255 );
        
        
        if( alvl == 0 )
        {
            bgRgb[i] = bgRgb[i+2] = 255; bgRgb[i+1] = 0;
        }
        else
        {
            bgRgb[i+0] = (bgRgb[i+0] * (255-alvl))/255 + (rgb[i+0] * alvl)/255;
            bgRgb[i+1] = (bgRgb[i+1] * (255-alvl))/255 + (rgb[i+1] * alvl)/255;
            bgRgb[i+2] = (bgRgb[i+2] * (255-alvl))/255 + (rgb[i+2] * alvl)/255;
        }
    }
}

void XIdeskImage::mouseOverEffect()
{
    glowing = true;
    refreshIcon();
}

void XIdeskImage::mouseOffEffect()
{
    glowing = false;
    refreshIcon();
}
