/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package sun.awt.im.iiimp;

import java.util.Locale;
import java.lang.Character.Subset;
import java.awt.Component;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextHitInfo;
import java.text.AttributedString;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;

import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodContext;

import com.sun.iiim.*;

public class IIIMFAdapter extends sun.awt.im.InputMethodAdapter implements
	IIIMListener, IIIMPreeditListener, IIIMCommittedListener {

    // private variables
    private static Manager manager;
    private Component currentClient;
    private InputMethodContext inputMethodContext;
    private Locale locale;
    private IIIMPreeditListener preeditListener;
    private static IIIMStatusListener statusListener;
    private IIIMLookupListener lookupListener;

    public IIIMFAdapter() {
	manager = Manager.getInstance();
	locale = Locale.getDefault();
    }

    // --------------------------------------------------------
    // java.awt.im.spi.InputMethod implementation
    // --------------------------------------------------------

    /**
     * Called when the input capable component receive a FOCUS_GAINED
     */
    public void activate() {
	currentClient = super.getClientComponent();
	manager.setIIIMFAdapter(this);
	manager.setIIIMCommittedListener(this);
	if (preeditListener == null) {
	    setPreeditListener(this);
	}
	if (statusListener == null) {
	    setStatusListener(new StatusWindow());
	}
	if (lookupListener == null) {
	    setLookupListener(new LookupWindow());
	}
	manager.setIIIMPreeditListener(preeditListener);
	manager.setIIIMStatusListener(statusListener);
	manager.setIIIMLookupListener(lookupListener);
	manager.activate();
    }

    /**
     * Called when the input capable component receive a FOCUS_LOST
     */
    public void deactivate(boolean isTemporary) {
	manager.deactivate(isTemporary);
    }

    /**
     * Receive AWTEvent throught this method.
     */
    public synchronized void dispatchEvent(AWTEvent event) {
	if (event instanceof KeyEvent) {
	    IIIMEvent e = new IIIMEvent(event);
	    manager.dispatchEvent(e);
	}
    }

    /**
     * Dispose the input method.
     */
    public void dispose() {
	manager.dispose();
    }

    /**
     * The behavior depends on im or user's preferrence.
     */
    public void endComposition() {
	manager.endComposition();
    }

    /**
     *
     */
    public Object getControlObject() {
	return manager.getControlObject();
    }

    /**
     * return locale
     */
    public Locale getLocale() {
	return locale;
    }

    /**
     * Closes or hides all windows opened by this input method instance
     * or its class.
     */
    public void hideWindows() {
    }

    /**
     *  
     */
    public void removeNotify() {
	manager.removeNotify();
    }
    
    /**
     * Set character subsets to the current active InputMethod.
     */
    public void setCharacterSubsets(Subset[] subsets) {
	manager.setCharacterSubsets(subsets);
    }

    /**
     *
     */
    public void setInputMethodContext(InputMethodContext context) {
	inputMethodContext = context;
    }

    /**
     * Set the primily InputMethod by locale.
     */	
    public boolean setLocale(Locale locale) {
	boolean b = manager.setLocale(locale);
	if (b) {
	    this.locale = locale;
	}
	return b;
    }

    public void setCompositionEnabled(boolean enable) {
	throw new UnsupportedOperationException();
    }

    public boolean isCompositionEnabled() {
	throw new UnsupportedOperationException();
    }
	

    // -----------------------------------------------------------

    protected Component getClientComponent() {
	return currentClient;
    }

    void setPreeditListener(IIIMPreeditListener l) {
	preeditListener = l;
    }

    void setStatusListener(IIIMStatusListener l) {
	statusListener = l;
    }

    void setLookupListener(IIIMLookupListener l) {
	lookupListener = l;
    }

    // --------------------------------------------------------	
    // sun.awt.im.iiimp.IIIMListener implementation
    // --------------------------------------------------------

    /**
     * Receive the IIIMEvent from Manager through this method.
     * Then convert it to InputMethodEvent and dispatch to inputMethodContext.
     * sun.awt.im.InputMethodContext inputMethodContext variable is
     * inherited from sun.awt.im.InputMethod class.
     */
    public void dispatchEvent(IIIMEvent e) {
    }

    // --------------------------------------------------------	
    // sun.awt.im.iiimp.IIIMPreeditListener implementation
    // --------------------------------------------------------

    /**
     * Receive the IIIMPreeditEvent from Manager through this method.
     * Then convert it to InputMethodEvent and dispatch to inputMethodContext.
     */
    public void preeditStart(IIIMPreeditEvent e) {}
    public void preeditDone(IIIMPreeditEvent e) {}
    public synchronized void preeditDraw(IIIMPreeditEvent e) {
	AttributedCharacterIterator iterator = e.getIterator();
	int pos = iterator.getEndIndex(); 

	inputMethodContext.dispatchInputMethodEvent(InputMethodEvent.
					      INPUT_METHOD_TEXT_CHANGED,
					      iterator,
					      0,
					      TextHitInfo.leading(pos),
					      null);
    }

    // --------------------------------------------------------	
    // sun.awt.im.iiimp.IIIMCommitedListener implementation
    // --------------------------------------------------------

    /**
     * Receive the IIIMCommittedEvent from Manager through this method.
     * Then convert it to InputMethodEvent and dispatch to inputMethodContext.
     */
    public void committedPerformed(IIIMCommittedEvent e) {
	String committed = e.getCommittedString();
	AttributedCharacterIterator iterator =
	    new AttributedString(committed).getIterator();

	inputMethodContext.dispatchInputMethodEvent(InputMethodEvent.
					      INPUT_METHOD_TEXT_CHANGED,
					      iterator,
					      committed.length(),
					      null,
					      null);
    }
}
