#ifndef IM_TLS_HH_
#define IM_TLS_HH_
#include <config.h>
#include <basictype.hh>
#include <stdio.h>

#ifdef HAVE_TLS

class IMSocketTrans;

class IMTLS {

    static bool initialized;
    static IMTLS *ptls;
    
  protected:
    IMTLS() { ptls = NULL; }

    virtual ~IMTLS();
    void register_singleton() {
        ptls = this;
    }

  public:
    static IMTLS* get_instance() {
        ASSERT(ptls);
        return ptls;
    }
    static IMTLS* construct();
    static void cleanup() {
        if(ptls) delete ptls;
    }

    virtual bool set_certificate_file(
        const string& filename
    ) {};
    virtual bool set_certificate_key_file(
        const string &filename
    ) {};
    virtual bool set_cacertificate_file(
        const string &filename
    ) {};
    virtual bool set_cacertificate_path(
        const string &dirname
    ) {};
    virtual bool set_verify_client(
        const string &value
    ) {};

    virtual bool set_verify_depth(
        const string &value
    ) {};

    virtual bool setup() {};

    virtual IMSocketTrans *create_trans(
        int fd,
        int trans_type
    ){};
};

#endif /* !HAVE_TLS */
#endif
