/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "iiimpIM.h"
#include "iiimpICG.h"
#include "XimpIm.h"
#include "guiIM.h"

int
GetAreaNeededWidth(XicCommon ic) {
  unsigned int width = 0;
  if (XIMP_CHK_PREFONTMASK(ic)) { /* we can do something */
    XFontSet fs = ic->core.preedit_attr.fontset;
    XFontSetExtents *fsx = XExtentsOfFontSet(fs);
    if (fsx) {
      width = fsx->max_logical_extent.width * MAX_PREEDIT_CHARNUM;
    }
  }
  if (width == 0) width = 100;
  return width;
}

int
GetAreaNeededHeight(XicCommon ic) {
  unsigned int height = 0;
  if (XIMP_CHK_PREFONTMASK(ic)) { /* we can do something */
    XFontSet fs = ic->core.preedit_attr.fontset;
    XFontSetExtents *fsx = XExtentsOfFontSet(fs);
    if (fsx) {
      height  = fsx->max_logical_extent.height;
    }
  }
  if (height == 0) height = 16;
  return height;
}

static Bool
PreGetAttributes(XicCommon ic, XIMArg *vl,
		 XimpChangeaMask change_mask,
		 char **return_name) {
  XIMArg *p;
  XRectangle *p_rect;
  XPoint *p_point;
  XIMCallback *p_callback;

  for (p = vl; p->name != NULL; p++) {
    if (strcmp(p->name, XNArea)==0) {
      if (XIMP_CHK_PREAREAMASK(ic)) {
	if ((p_rect = (XRectangle *)Xmalloc(sizeof(XRectangle))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_rect->x       = ic->core.preedit_attr.area.x;
	p_rect->y       = ic->core.preedit_attr.area.y;
	p_rect->width   = ic->core.preedit_attr.area.width;
	p_rect->height  = ic->core.preedit_attr.area.height;
      } else {
	*return_name = p->name;
	return(False);
      }
      *((XRectangle **)(p->value)) = p_rect;
    } else if (strcmp(p->name, XNAreaNeeded)==0) {
      if ((p_rect = (XRectangle *)Xmalloc(sizeof(XRectangle))) == NULL) {
	*return_name = p->name;
	return(False);
      }
      memset(p_rect, 0, sizeof(XRectangle));

      p_rect->x  = p_rect->y  = 0;

      if (XIMP_CHK_PREAREANEEDMASK(ic) &&
	  ((p_rect->width = ic->core.preedit_attr.area_needed.width) > 0) &&
	  ((p_rect->height = ic->core.preedit_attr.area_needed.height) > 0)
	  ) {
	goto All_Set;
      }
      if (p_rect->width == 0 || p_rect->height == 0) {
	if (p_rect->width == 0) {
	  p_rect->width = GetAreaNeededWidth(ic);
	}
	if (p_rect->height == 0) {
	  p_rect->height  = GetAreaNeededHeight(ic);
	}
      }
    All_Set:
      /* For next query  */
      ic->core.preedit_attr.area_needed.width = p_rect->width;
      ic->core.preedit_attr.area_needed.height = p_rect->height;
      XIMP_SET_PREAREANEEDMASK(ic, change_mask);

      *((XRectangle **)(p->value)) = p_rect;

    } else if (strcmp(p->name, XNSpotLocation)==0) {
      if (XIMP_CHK_PRESPOTLMASK(ic)) {
	if ((p_point = (XPoint *)Xmalloc(sizeof(XPoint))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_point->x = ic->core.preedit_attr.spot_location.x;
	p_point->y = ic->core.preedit_attr.spot_location.y;
      } else {
	*return_name = p->name;
	return(False);
      }
      *((XPoint **)(p->value)) = p_point;
    } else if (strcmp(p->name, XNColormap)==0) {
      if (XIMP_CHK_PRECOLORMAPMASK(ic)) {
	*((Colormap *)(p->value)) = ic->core.preedit_attr.colormap;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNStdColormap)==0) {
      if (XIMP_CHK_PRESTDCOLORMAPMASK(ic))
	*((Atom *)(p->value)) = ic->core.preedit_attr.std_colormap;
      else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNBackground)==0) {
      if (XIMP_CHK_PREBGMASK(ic)) {
	*((unsigned long *)(p->value)) = ic->core.preedit_attr.background;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNForeground)==0) {
      if (XIMP_CHK_PREFGMASK(ic)) {
	*((unsigned long *)(p->value)) = ic->core.preedit_attr.foreground;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNBackgroundPixmap)==0) {
      if (XIMP_CHK_PREBGPIXMAPMASK(ic)) {
	*((Pixmap *)(p->value)) = ic->core.preedit_attr.background_pixmap;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNFontSet)==0) {
      if (XIMP_CHK_PREFONTMASK(ic)) {
	*((XFontSet *)(p->value)) = ic->core.preedit_attr.fontset;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNLineSpace)==0) {
      if (XIMP_CHK_PRELINESPMASK(ic)) {
	*((int *)(p->value)) = ic->core.preedit_attr.line_spacing;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNCursor)==0) {
      if (XIMP_CHK_PRECURSORMASK(ic)) {
	*((Cursor *)(p->value)) = ic->core.preedit_attr.cursor;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNPreeditStartCallback)==0) {
      if ((int)ic->core.preedit_attr.start_callback.callback) {
	if ((p_callback = (XIMCallback *)Xmalloc(sizeof(XIMCallback))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_callback->client_data =
	  ic->core.preedit_attr.start_callback.client_data;
	p_callback->callback =
	  ic->core.preedit_attr.start_callback.callback;
	*((XIMCallback **)(p->value)) = p_callback;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNPreeditDrawCallback)==0) {
      if ((int)ic->core.preedit_attr.draw_callback.callback) {
	if ((p_callback = (XIMCallback *)Xmalloc(sizeof(XIMCallback))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_callback->client_data =
	  ic->core.preedit_attr.draw_callback.client_data;
	p_callback->callback =
	  ic->core.preedit_attr.draw_callback.callback;
	*((XIMCallback **)(p->value)) = p_callback;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNPreeditDoneCallback)==0) {
      if ((int)ic->core.preedit_attr.done_callback.callback) {
	if ((p_callback = (XIMCallback *)Xmalloc(sizeof(XIMCallback))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_callback->client_data =
	  ic->core.preedit_attr.done_callback.client_data;
	p_callback->callback =
	  ic->core.preedit_attr.done_callback.callback;
	*((XIMCallback **)(p->value)) = p_callback;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNPreeditCaretCallback)==0) {
      if ((int)ic->core.preedit_attr.caret_callback.callback) {
	if ((p_callback = (XIMCallback *)Xmalloc(sizeof(XIMCallback))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_callback->client_data =
	  ic->core.preedit_attr.caret_callback.client_data;
	p_callback->callback =
	  ic->core.preedit_attr.caret_callback.callback;
	*((XIMCallback **)(p->value)) = p_callback;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNPreeditState)==0) {
      *((XIMPreeditState*)(p->value)) = ic->core.preedit_attr.preedit_state;
    } else if (strcmp(p->name, XNPreeditStateNotifyCallback)==0) {
      if ((int)ic->core.preedit_attr.state_notify_callback.callback) {
	if ((p_callback = (XIMCallback *)Xmalloc(sizeof(XIMCallback))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_callback->client_data =
	  ic->core.preedit_attr.state_notify_callback.client_data;
	p_callback->callback =
	  ic->core.preedit_attr.state_notify_callback.callback;
	*((XIMCallback **)(p->value)) = p_callback;
      } else {
	*return_name = p->name;
	return(False);
      }
 /* private XIC extention */
    } else if (strcmp(p->name, XNLookupStartCallback)==0) {
      if (ic->lookup_start_callback.callback) {
	if ((p_callback = (XIMCallback *)Xmalloc(sizeof(XIMCallback))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_callback->client_data =
	  ic->lookup_start_callback.client_data;
	p_callback->callback =
	  ic->lookup_start_callback.callback;
	*((XIMCallback **)(p->value)) = p_callback;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNLookupDrawCallback)==0) {
      if (ic->lookup_draw_callback.callback) {
	if ((p_callback = (XIMCallback *)Xmalloc(sizeof(XIMCallback))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_callback->client_data =
	  ic->lookup_draw_callback.client_data;
	p_callback->callback =
	  ic->lookup_draw_callback.callback;
	*((XIMCallback **)(p->value)) = p_callback;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNLookupDoneCallback)==0) {
      if (ic->lookup_done_callback.callback) {
	if ((p_callback = (XIMCallback *)Xmalloc(sizeof(XIMCallback))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_callback->client_data =
	  ic->lookup_done_callback.client_data;
	p_callback->callback =
	  ic->lookup_done_callback.callback;
	*((XIMCallback **)(p->value)) = p_callback;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNSwitchIMNotifyCallback)==0) {
      if (ic->switchim_notify_callback.callback) {
	if ((p_callback = (XIMCallback *)Xmalloc(sizeof(XIMCallback))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_callback->client_data =
	  ic->switchim_notify_callback.client_data;
	p_callback->callback =
	  ic->switchim_notify_callback.callback;
	*((XIMCallback **)(p->value)) = p_callback;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNCommitStringCallback)==0) {
      if (ic->commit_string_callback.callback) {
	if ((p_callback = (XIMCallback *)Xmalloc(sizeof(XIMCallback))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_callback->client_data =
	  ic->commit_string_callback.client_data;
	p_callback->callback =
	  ic->commit_string_callback.callback;
	*((XIMCallback **)(p->value)) = p_callback;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNForwardEventCallback)==0) {
      if (ic->forward_event_callback.callback) {
	if ((p_callback = (XIMCallback *)Xmalloc(sizeof(XIMCallback))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_callback->client_data =
	  ic->forward_event_callback.client_data;
	p_callback->callback =
	  ic->forward_event_callback.callback;
	*((XIMCallback **)(p->value)) = p_callback;
      } else {
	*return_name = p->name;
	return(False);
      }
    }
  }
  return(True);
}

static Bool
StatusGetAttributes(XicCommon ic, XIMArg *vl,
		    XimpChangeaMask change_mask,
		    char **return_name) {
  XIMArg *p;
  XRectangle *p_rect;
  XIMCallback *p_callback;

  for (p = vl; p->name != NULL; p++) {
    if (strcmp(p->name, XNArea)==0) {
      if (XIMP_CHK_STSAREAMASK(ic)) {
	if ((p_rect = (XRectangle *)Xmalloc(sizeof(XRectangle))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_rect->x       = ic->core.status_attr.area.x;
	p_rect->y       = ic->core.status_attr.area.y;
	p_rect->width   = ic->core.status_attr.area.width;
	p_rect->height  = ic->core.status_attr.area.height;
      } else {
	*return_name = p->name;
	return(False);
      }
      *((XRectangle **)(p->value)) = p_rect;

    } else if (strcmp(p->name, XNAreaNeeded)==0) {
      if ((p_rect = (XRectangle *)Xmalloc(sizeof(XRectangle))) == NULL) {
	*return_name = p->name;
	return(False);
      }
      memset(p_rect, 0, sizeof(XRectangle));

      p_rect->x  = p_rect->y  = 0;

      if (XIMP_CHK_STSAREANEEDMASK(ic) &&
	  ((p_rect->width = ic->core.status_attr.area_needed.width) > 0) &&
	  ((p_rect->height = ic->core.status_attr.area_needed.height) > 0)
	  ) {
	goto All_Set;
      } else {
	if (p_rect->width == 0 || p_rect->height == 0) {
	  if (XIMP_CHK_STSFONTMASK(ic)) { /* we can do something */
	    XFontSet fs = ic->core.status_attr.fontset;
	    XFontSetExtents *fsx = XExtentsOfFontSet(fs);
	    if (!fsx) goto All_Set;

	    if (p_rect->width == 0 ||
		ic->core.input_style & XIMPreeditArea) {
	      p_rect->width = fsx->max_logical_extent.width *
		MAX_STATUS_CHARNUM;
	    }
	    if (p_rect->height == 0) {
	      p_rect->height  = fsx->max_logical_extent.height;
	    }
	  }
	}
      }
    All_Set:
      if (p_rect->width == 0) p_rect->width = 100;
      if (p_rect->height == 0) p_rect->height = 16;

      /* For next query  */
      ic->core.status_attr.area_needed.width = p_rect->width;
      ic->core.status_attr.area_needed.height = p_rect->height;
      XIMP_SET_STSAREANEEDMASK(ic, change_mask);

      *((XRectangle **)(p->value)) = p_rect;

    } else if (strcmp(p->name, XNColormap)==0) {
      if (XIMP_CHK_STSCOLORMAPMASK(ic)) {
	*((Colormap *)(p->value)) = ic->core.status_attr.colormap;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNStdColormap)==0) {
      if (XIMP_CHK_STSSTDCOLORMAPMASK(ic)) {
	*((Atom *)(p->value)) = ic->core.status_attr.std_colormap;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNBackground)==0) {
      if (XIMP_CHK_STSBGMASK(ic)) {
	*((unsigned long *)(p->value)) = ic->core.status_attr.background;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNForeground)==0) {
      if (XIMP_CHK_STSFGMASK(ic)) {
	*((unsigned long *)(p->value)) = ic->core.status_attr.foreground;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNBackgroundPixmap)==0) {
      if (XIMP_CHK_STSBGPIXMAPMASK(ic)) {
	*((Pixmap *)(p->value)) = ic->core.status_attr.background_pixmap;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNFontSet)==0) {
      if (XIMP_CHK_STSFONTMASK(ic)) {
	*((XFontSet *)(p->value)) = ic->core.status_attr.fontset;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNLineSpace)==0) {
      if (XIMP_CHK_STSLINESPMASK(ic)) {
	*((int *)(p->value)) = ic->core.status_attr.line_spacing;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNCursor)==0) {
      if (XIMP_CHK_STSCURSORMASK(ic)) {
	*((Cursor *)(p->value)) = ic->core.status_attr.cursor;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNStatusStartCallback)==0) {
      if ((int)ic->core.status_attr.start_callback.callback) {
	if ((p_callback = (XIMCallback *)Xmalloc(sizeof(XIMCallback))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_callback->client_data =
	  ic->core.status_attr.start_callback.client_data;
	p_callback->callback =
	  ic->core.status_attr.start_callback.callback;
	*((XIMCallback **)(p->value)) = p_callback;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNStatusDrawCallback)==0) {
      if ((int)ic->core.status_attr.draw_callback.callback) {
	if ((p_callback = (XIMCallback *)Xmalloc(sizeof(XIMCallback))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_callback->client_data =
	  ic->core.status_attr.draw_callback.client_data;
	p_callback->callback =
	  ic->core.status_attr.draw_callback.callback;
	*((XIMCallback **)(p->value)) = p_callback;
      } else {
	*return_name = p->name;
	return(False);
      }
    } else if (strcmp(p->name, XNStatusDoneCallback)==0) {
      if ((int)ic->core.status_attr.done_callback.callback) {
	if ((p_callback = (XIMCallback *)Xmalloc(sizeof(XIMCallback))) == NULL) {
	  *return_name = p->name;
	  return(False);
	}
	p_callback->client_data =
	  ic->core.status_attr.done_callback.client_data;
	p_callback->callback =
	  ic->core.status_attr.done_callback.callback;
	*((XIMCallback **)(p->value)) = p_callback;
      } else {
	*return_name = p->name;
	return(False);
      }
    }
  }
  return(True);
}

char *
GetICValueData(XicCommon ic, XIMArg *values, XimpChangeaMask change_mask) {
  XIMArg *p;
  char *p_char;
  char *return_name = NULL;
  int len;

  for (p = values; p->name != NULL; p++) {
    if (strcmp(p->name, XNInputStyle) == 0) {
      if (ic->ximp_icpart->value_mask & XIMP_INPUT_STYLE) {
	*((XIMStyle *)(p->value)) = ic->core.input_style;
      } else {
	return_name = p->name;
	break;
      }
    } else if (strcmp(p->name, XNClientWindow)==0) {
      if (ic->ximp_icpart->value_mask & XIMP_CLIENT_WIN) {
	*((Window *)(p->value)) = ic->core.client_window;
      } else {
	return_name = p->name;
	break;
      }
    } else if (strcmp(p->name, XNFocusWindow)==0) {
      if (XIMP_CHK_FOCUSWINMASK(ic)) {
	*((Window *)(p->value)) = ic->core.focus_window;
      } else {
	return_name = p->name;
	break;
      }
    } else if (strcmp(p->name, XNResourceName)==0) {
      if (ic->core.im->core.res_name != (char *)NULL) {
	len = strlen(ic->core.im->core.res_name);
	if ((p_char = (char*)Xmalloc(len+1)) == NULL) {
	  return_name = p->name;
	  break;
	}
	strcpy(p_char, ic->core.im->core.res_name);
	*((char **)(p->value)) = p_char;
      } else {
	return_name = p->name;
	break;
      }
    } else if (strcmp(p->name, XNResourceClass)==0) {
      if (ic->core.im->core.res_class != (char *)NULL) {
	len = strlen(ic->core.im->core.res_class);
	if ((p_char = (char*)Xmalloc(len+1)) == NULL) {
	  return_name = p->name;
	  break;
	}
	strcpy(p_char, ic->core.im->core.res_class);
	*((char **)(p->value)) = p_char;
      } else {
	return_name = p->name;
	break;
      }
    } else if (strcmp(p->name, XNGeometryCallback)==0) {
      if (ic->ximp_icpart->value_mask & XIMP_GEOMETRY_CB) {
	*((XICCallback *)(p->value)) = ic->core.geometry_callback;
      } else {
	return_name = p->name;
	break;
      }
    } else if (strcmp(p->name, XNFilterEvents)==0) {
      *((unsigned long *)(p->value)) = ic->core.filter_events;
    } else if (strcmp(p->name, XNUnicodeCharacterSubset)==0) {
      XIMUnicodeCharacterSubset **value;
      XIMUnicodeCharacterSubset *subset;
      XimCommon xim = (XimCommon)ic->core.im;

      if (xim->unicode_char_subsets == NULL)
	return p->name;

      subset = &(xim->unicode_char_subsets->supported_subsets[ic->subset_id]);
      value = (XIMUnicodeCharacterSubset**)p->value;
      *value = subset;
    } else if (strcmp(p->name, XNPreeditAttributes)==0) {
      if (PreGetAttributes(ic, (XIMArg*)p->value,
			   change_mask,
			   &return_name) == False)
	break;
    } else if (strcmp(p->name, XNStatusAttributes)==0) {
      if (StatusGetAttributes(ic, (XIMArg*)p->value,
			      change_mask,
			      &return_name) == False)
	break;
    } else {
      return_name = p->name;
      break;
    }
  }
  return(return_name);
}
