/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "PYIM.h"

/* Jword.c */
JINT    GbkHz2244ToYjSM(JINT nHzcode);
JINT    GbkHz2244ToYj(JINT nHzcode);
UCHAR*  RecovDyz2244(UCHAR *szDyz2244);
VOID    Jword2Uchar(JWORD* pwJword, UCHAR* szUch, JINT nMaxLen);
VOID    JwordNCpy(JWORD* pwDst, JWORD* pwSrc, JINT nLen);
JINT    JwordValidLen(JWORD* pwJwordArray, JINT nMaxLen);
JINT    JwordHanziLen(JWORD* pwJwordArray, JINT nMaxLen);
JINT    JwordNCmp(JWORD* pwSrc1, JWORD* pwSrc2, JINT nNum);
JINT    IsGbkkkHz(JWORD wHz);

JINT    GetCikuData(CHAR* szSysCikuName);
JINT    WriteCikuData(CHAR* szSysCikuName, JINT nTimeStamp);
JINT    EnumCandi(JINT* pnOrgYj, JINT nLenYj, SysCandi* psc, UdcCandi* puc, JINT* pnSize, JINT nMatchMode, JINT nMode);
VOID    InitStructSc(SysCandi* psc);
VOID    InitStructUc(UdcCandi* puc);
JINT    LookupCiku(JINT* pnOrgYj, JINT nLenYj, JINT nMatchMode, SysCandi* psc, UdcCandi* puc);
VOID    SortCandi(SysCandi* psc, UdcCandi* puc);
VOID    AdjustFreq(JWORD* pwHz2244, JINT nLenThis);
JINT    IsCizuExist(JWORD* pwHz2244, JINT nLenThis);
JINT    IsGbkkkHz(JWORD wHz);

VOID    WarpByte(VOID* pv, JINT n);
VOID    WarpIndex(ShIndex* pInt419);
VOID    WarpCikuHeader(CikuHeader* pCh);

BYTE   *pCkAll = NULL;
extern  UdcMemAll  udcAll;

CHAR      szLocale[10] = "zh.GBK";

/*
**  Warp 4 Bytes or Warp 2 Bytes.
**  Because SPARC and Intel x86 have different byte order.
*/
VOID WarpByte(VOID* pv, JINT n)
{
	JINT    nInt;
	JWORD   wWord;
	
	nInt = wWord = 0;
	if (n == 4)
	{
		nInt = *((JINT*)pv);
		*((JINT*)pv) = ((nInt & 0x000000FF) << 24) + ((nInt & 0x0000FF00) << 8) +
		               ((nInt & 0xFF000000) >> 24) + ((nInt & 0x00FF0000) >> 8);
	}
	else if (n == 2)
	{
		wWord = *((JWORD*)pv);
		*((JWORD*)pv) = (JWORD)( ((wWord & 0x00FF) << 8) + ((wWord & 0xFF00) >> 8) );
	}
	else
		return;
}

/*
**  Both CikuHeader and UdCikuHeader have same structure.
*/
VOID WarpCikuHeader(CikuHeader* pCh)
{
	JINT    i;
	
	for (i = 0; i < 4; i++)
	{
		WarpByte( (VOID*)((JINT*)pCh + i), 4);
	}
	
	for (i = 24; i < 32; i++)
	{
		WarpByte( (VOID*)((JINT*)pCh + i), 4);
	}
}

/*
**  All ShIndex, DhIndex, MhIndex, GbkIndex and UdcIndex have same structure.
*/
VOID WarpIndex(ShIndex* pInt419)
{
	JINT    i;
	
	for (i = 0; i < 419; i++)
	{
		WarpByte( (VOID*)((JINT*)pInt419 + i), 4);
	}
}


/*
**  Read out all those data in System Ciku file to pCkAll.
*/
JINT GetCikuData(CHAR* szSysCikuName)
{
	FILE*   pfCiku;
	JINT    i, k;
	JINT    nFileSize;
	JINT    nWarpFlag;     /* Flag to indicate whether it is necessary to */
	
	CikuHeader  *pCkh;
	ShIndex     *pShi;
	DhIndex     *pDhi;
	MhIndex     *pMhi;
	GbkIndex    *pGbki;
	BYTE        *pShArea;
	BYTE        *pDhArea;
	BYTE        *pMhArea;
	BYTE        *pGbkArea;
	
	nWarpFlag = FALSE;
	
	pfCiku = fopen(szSysCikuName, "rb");
	if (pfCiku == NULL)
	{
		return FALSE;
	}
	
	pCkh = (CikuHeader*)malloc(sizeof(CikuHeader));
	if (pCkh == NULL)
	{
		return FALSE;
	}
	
	fseek(pfCiku, 0, SEEK_SET);
	if (fread (pCkh, 1, sizeof(CikuHeader), pfCiku) != sizeof(CikuHeader) )
	{
		return FALSE;
	}
	
	/* Check Magic Word in Header */
	if ((pCkh->nMagicDescHi != 0x35303539) || (pCkh->nMagicDescLow != 0x34333442))
	{
		/* Is SPARC or x86 File? */
		if ((pCkh->nMagicDescHi == 0x39353035) && (pCkh->nMagicDescLow == 0x42343334))
		{
			nWarpFlag = TRUE;
		}
		else
			return FALSE;
	}
	
	if (nWarpFlag == TRUE)
		WarpCikuHeader(pCkh);
	
	nFileSize = pCkh->nFileSize;
	
	fseek(pfCiku, 0, SEEK_END);
	if (nFileSize != ftell(pfCiku))
	{
		return FALSE;
	}
	
	free(pCkh);
	pCkh = NULL;
	
	pCkAll = (BYTE*)malloc(nFileSize);
	if (pCkAll == NULL)
	{
		fprintf(stderr, "Failed to malloc() for pCkAll in GetCikuInfo.\n");
		return FALSE;
	}
	
	fseek(pfCiku, 0, SEEK_SET);
	if ((JINT)fread (pCkAll, 1, nFileSize, pfCiku) != nFileSize )
	{
		fprintf(stderr, "Failed to fread() System Ciku File.\n");
		return FALSE;
	}
	fclose(pfCiku);
	
	pCkh     = (CikuHeader *)pCkAll;
	if (nWarpFlag == TRUE)
		WarpCikuHeader(pCkh);

	pShi     = (ShIndex  *)(pCkAll + pCkh->nIdxShPos);
	pDhi     = (DhIndex  *)(pCkAll + pCkh->nIdxDhPos);
	pMhi     = (MhIndex  *)(pCkAll + pCkh->nIdxMhPos);
	pGbki    = (GbkIndex *)(pCkAll + pCkh->nIdxGbkPos);
	
	if (nWarpFlag == TRUE)
	{
		WarpIndex((ShIndex *)pShi);
		WarpIndex((ShIndex *)pDhi);
		WarpIndex((ShIndex *)pMhi);
		WarpIndex((ShIndex *)pGbki);
	}
	
	pShArea  = (BYTE *)(pCkAll + pShi->nStartPos);
	pDhArea  = (BYTE *)(pCkAll + pDhi->nStartPos);
	pMhArea  = (BYTE *)(pCkAll + pMhi->nStartPos);
	pGbkArea = (BYTE *)(pCkAll + pGbki->nStartPos);
	
	for(i = 0; i < NUM_YINJIE; i++)
		for(k = (pShi->nYjOff[i] & 0x00FFFFFF); k < (pShi->nYjOff[i + 1] & 0x00FFFFFF); k++)
			*(pShArea + k) ^= (BYTE)((i + 56) / 2);

	for(i = 0; i < NUM_YINJIE; i++)
		for(k = pDhi->nYjOff[i]; k < pDhi->nYjOff[i + 1]; k++)
			*(pDhArea + k) ^= (BYTE)((i + 56) / 2);

	for(i = 0; i < NUM_YINJIE; i++)
		for(k = pMhi->nYjOff[i]; k < pMhi->nYjOff[i + 1]; k++)
			*(pMhArea + k) ^= (BYTE)((i + 56) / 2);

	for(i = 0; i < NUM_YINJIE; i++)
		for(k = pGbki->nYjOff[i]; k < pGbki->nYjOff[i + 1]; k++)
			*(pGbkArea + k) ^= (BYTE)((i + 56) / 2);

	return TRUE;
}


JINT WriteCikuData(CHAR* szSysCikuName, JINT nTimeStamp)
{
	FILE*   pfCiku;
	JINT    i, k;
	JINT    nFileSize, nTmp;
	
	CikuHeader  *pCkh;
	ShIndex     *pShi;
	DhIndex     *pDhi;
	MhIndex     *pMhi;
	GbkIndex    *pGbki;
	BYTE        *pShArea;
	BYTE        *pDhArea;
	BYTE        *pMhArea;
	BYTE        *pGbkArea;

	pCkh     = (CikuHeader *)pCkAll;
	pShi     = (ShIndex  *)(pCkAll + pCkh->nIdxShPos);
	pDhi     = (DhIndex  *)(pCkAll + pCkh->nIdxDhPos);
	pMhi     = (MhIndex  *)(pCkAll + pCkh->nIdxMhPos);
	pGbki    = (GbkIndex *)(pCkAll + pCkh->nIdxGbkPos);
	
	pShArea  = (BYTE *)(pCkAll + pShi->nStartPos);
	pDhArea  = (BYTE *)(pCkAll + pDhi->nStartPos);
	pMhArea  = (BYTE *)(pCkAll + pMhi->nStartPos);
	pGbkArea = (BYTE *)(pCkAll + pGbki->nStartPos);
	
	pCkh->nLatestTime = nTimeStamp;
	
	/* Write These data back to file */
	pfCiku = fopen(szSysCikuName, "wb");
	if (pfCiku == NULL)
	{
		fprintf(stderr, "Failed to Create System Ciku File: %s\n", szSysCikuName);
		return FALSE;
	}
	
	for(i = 0; i < NUM_YINJIE; i++)
		for(k = (pShi->nYjOff[i] & 0x00FFFFFF); k < (pShi->nYjOff[i + 1] & 0x00FFFFFF); k++)
			*(pShArea + k) ^= (BYTE)((i + 56) / 2);

	for(i = 0; i < NUM_YINJIE; i++)
		for(k = pDhi->nYjOff[i]; k < pDhi->nYjOff[i + 1]; k++)
			*(pDhArea + k) ^= (BYTE)((i + 56) / 2);

	for(i = 0; i < NUM_YINJIE; i++)
		for(k = pMhi->nYjOff[i]; k < pMhi->nYjOff[i + 1]; k++)
			*(pMhArea + k) ^= (BYTE)((i + 56) / 2);
	
	for(i = 0; i < NUM_YINJIE; i++)
		for(k = pGbki->nYjOff[i]; k < pGbki->nYjOff[i + 1]; k++)
			*(pGbkArea + k) ^= (BYTE)((i + 56) / 2);

	nFileSize = pCkh->nFileSize;

	fseek(pfCiku, 0, SEEK_SET);
	nTmp = (JINT)fwrite (pCkAll, nFileSize, 1, pfCiku);
	
	for(i = 0; i < NUM_YINJIE; i++)
		for(k = (pShi->nYjOff[i] & 0x00FFFFFF); k < (pShi->nYjOff[i + 1] & 0x00FFFFFF); k++)
			*(pShArea + k) ^= (BYTE)((i + 56) / 2);

	for(i = 0; i < NUM_YINJIE; i++)
		for(k = pDhi->nYjOff[i]; k < pDhi->nYjOff[i + 1]; k++)
			*(pDhArea + k) ^= (BYTE)((i + 56) / 2);

	for(i = 0; i < NUM_YINJIE; i++)
		for(k = pMhi->nYjOff[i]; k < pMhi->nYjOff[i + 1]; k++)
			*(pMhArea + k) ^= (BYTE)((i + 56) / 2);
	
	for(i = 0; i < NUM_YINJIE; i++)
		for(k = pGbki->nYjOff[i]; k < pGbki->nYjOff[i + 1]; k++)
			*(pGbkArea + k) ^= (BYTE)((i + 56) / 2);

	if (nTmp != 1)
	{
		fprintf(stderr, "Failed to fwrite() System Ciku File.\n");
		return FALSE;
	}
	
	fclose (pfCiku);
	return TRUE;
}


/*
**  Free the memory alloc to pCkAll
*/
VOID FreePckAll()
{
	free(pCkAll);
	pCkAll = NULL;
}


/*  
**  pnSize:     If nMode is LU_CANDI_CALC, Calculate the size need totally to contain all those SysCandis,
**              and set nNumShCandi, nNumDhCandi, nNumMhCandi, nSizShCandi, nSizDhCandi, nSizMhCandi of struct psc.
**              [pnSize is in JWORD]
**
**  nMatchMode: LU_MATCH_STRICT   ==> Match Strictly. Used by nLenYj >= 5. Condition: nCzLen == nLenYj  
**              LU_MATCH_WIDELY   ==> Match Widely.   Used by nLenYj >= 5. Condition: nCzLen >= nLenYj
**              Condition for LU_MATCH_WIDLY:
**                        zhong hua ren min gong // zhong hua ren min gong h  // zhong hua ren min gong he
**              Condition for LU_MATCH_STRICT:  => Last YjString is unmatched and meanless.
**                        zhong hua ren min gong [go gon cho chon cua]
**
**  nMode:      LU_CANDI_WRITE ==> Write all those SysCandis to allocated memory for Sh, Dh, Mh Candidates.
**              LU_CANDI_CALC  ==> Calculate the space size which needed to contain all those SysCandis.
**
**  NOTES:      Structure psc was filled after two calling of this function: First in Mode LU_CANDI_CALC,
**              second in Mode LU_CANDI_WRITE.
**
**  CONTENTS OF pwMhCandi + pwDhCandi + pwShCandi + pwGbkCandi + pwSpecCandi + pwUdc28Candi
**             Mh:    fhhhhhh0fhhh0fhhhh0
**             Dh:    fhh0fhh0fhh0fhh0fhh0fhh0fhh0fhh0fhh0fhh0fhh0fhh0
**             Sh:    XX0XX0h0h0h0h0h0h0h0h0h0h0h0 + 0     OR
**                    Q0Q0Q0Q0Q0Q0Q0h0h0h0h0h0h0h0h0 + 0
**             Gbk:   h0h0h0h0h0h0h0h0
**             Spec:  In ucUdcCandi->pwSpecCandi[6]
**             Udc28: fhhhh0fhhhhhh0fhh0
**             Notes:  f  ==> JWORD of Frequence and Length
**                     h  ==> JWORD of a Single Hanzi
**                     XX ==> JWORDs of Xian Form Candi
**                     Q  ==> JWORD of High frequence Hanzi of a Specified Yinjie ShengMu, Ex, Q->7
**                            "ɿտڿƿ˿"
**
*/
JINT EnumCandi(JINT* pnOrgYj, JINT nLenYj, SysCandi* psc, UdcCandi* puc, JINT* pnSize, JINT nMatchMode, JINT nMode)
{
	JINT    nFromOff, nToOff;
	JINT    nFromYj, nToYj, nXianNum;         /* For Single Hanzi Area Searching */
	UCHAR   chHi, chLow;                      /* For Single Hanzi Area Searching */
	JINT    nCzLen, i, m, k, nTmp;
	JWORD   wCzHz[10], wMhLenFreq, wDhFreq;
	JINT    nEqualFlag;
	CHAR    *pszYj1, *pszYj2;                 /* For DhCandi, compare string directly */
	CHAR    szYj3[14], szYj4[14];
	JINT    nfGbkCizu;

	/* Definition for puc */
	JINT    nCurSize;
	JINT    nUdc28FreqLen, nUdc28Len;

	CikuHeader  *pCkh;
	ShIndex     *pShi;
	DhIndex     *pDhi;
	MhIndex     *pMhi;
	GbkIndex    *pGbki;
	BYTE        *pShArea;
	BYTE        *pDhArea;
	BYTE        *pMhArea;
	BYTE        *pGbkArea;

	pCkh     = (CikuHeader *)pCkAll;
	pShi     = (ShIndex  *)(pCkAll + pCkh->nIdxShPos);
	pDhi     = (DhIndex  *)(pCkAll + pCkh->nIdxDhPos);
	pMhi     = (MhIndex  *)(pCkAll + pCkh->nIdxMhPos);
	pGbki    = (GbkIndex *)(pCkAll + pCkh->nIdxGbkPos);
	
	pShArea  = (BYTE *)(pCkAll + pShi->nStartPos);
	pDhArea  = (BYTE *)(pCkAll + pDhi->nStartPos);
	pMhArea  = (BYTE *)(pCkAll + pMhi->nStartPos);
	pGbkArea = (BYTE *)(pCkAll + pGbki->nStartPos);

	*pnSize  = 0;
	if (nMode == LU_CANDI_WRITE)
	{
		psc->nSizMhCandi  = 0;
		psc->nSizDhCandi  = 0;
		psc->nSizShCandi  = 0;
		psc->nSizGbkCandi = 0;
			
		psc->nNumMhCandi  = 0;
		psc->nNumDhCandi  = 0;
		psc->nNumShCandi  = 0;
		psc->nNumGbkCandi = 0;

		puc->nNumSpecCandi  = 0;
		puc->nNumUdc28Candi = 0;
		puc->nSizUdc28Candi = 0;
	}

	if (nLenYj >= 3)
	{
		/*
		**  Determine the FromOff and ToOff which to used for searching by the pnOrgYj[0].
		*/
		if ((pnOrgYj[0] >= 0) && (pnOrgYj[0] < NUM_YINJIE))
		{
			nFromOff = pMhi->nYjOff[ pnOrgYj[0] ];
			nToOff   = pMhi->nYjOff[ pnOrgYj[0] + 1];
		}
		else   /* ((pnOrgYj[0] >= 450) && (pnOrgYj[0] <= 475)) */
		{
			nFromOff = pMhi->nYjOff[ INDEXSMTOYINJIE[pnOrgYj[0] - 450] ];
			nToOff   = pMhi->nYjOff[ INDEXSMTOYINJIE[pnOrgYj[0] - 450 + 1] ];
		}
		
		/* !! DON'T add k++ in this FOR sentence !! */
		for (k = nFromOff; k < nToOff; )
		{
			wMhLenFreq = (JWORD)*(pMhArea + k);
			nCzLen     = 2 + ((UCHAR)*(pMhArea + k) & 0x07);
			k++;
			
			for (m = 0; m < 10; m++)
				wCzHz[m]   = 0x0000;
			for (m = 0; m < nCzLen; m++)
			{
				wCzHz[m]   = (JWORD)(*(pMhArea + k + 1) + ((*(pMhArea + k)) << 8));
				k += 2;
			}
			
			/*
			** DON'T CONVERT wCzItem into YJSTRING and CALL ParsePreedit() HERE, BECAUSE THAT
			** IS TOO COMPLEX AND UN_LOGICALLY.
			** For Example, zai xian shi qu ==> zai xi'an shi qu [Four ~ Five !!!!]
			*/

			nEqualFlag = FALSE;
			if (( (nLenYj <= 4) && (nCzLen <= nLenYj) ) || 
			    ( (nLenYj >= 5) && (nMatchMode == LU_MATCH_WIDELY) ) || 
			    ( (nLenYj >= 5) && (nMatchMode == LU_MATCH_STRICT) && (nCzLen <= nLenYj) )  )
			{
				nEqualFlag = TRUE;
				
				for(m = 0; m < _MIN(nLenYj, nCzLen); m++)
					if ( ( pnOrgYj[m] != GbkHz2244ToYjSM((JINT)wCzHz[m]) ) && 			\
					     ( pnOrgYj[m] != GbkHz2244ToYj((JINT)wCzHz[m])   ) )
					{
						nEqualFlag = FALSE;
						break;
					}
			}
			
			if ((nEqualFlag == TRUE) && (nMode == LU_CANDI_CALC))
			{
				psc->nSizMhCandi += (nCzLen + 2);	/* Add two JWORD Here to contain Freq&Len Word and a ZERO */
				psc->nNumMhCandi += 1;
				*pnSize += (nCzLen + 2);
			}
			else if ((nEqualFlag == TRUE) && (nMode == LU_CANDI_WRITE))
			{
				psc->pwMhCandi[psc->nSizMhCandi] = wMhLenFreq;
				for (m = 0; m < nCzLen; m++)
					psc->pwMhCandi[psc->nSizMhCandi + m + 1] = wCzHz[m];
				
				psc->nSizMhCandi += (nCzLen + 2);
				psc->nNumMhCandi += 1;
				*pnSize += (nCzLen + 2);
			}
		}
	}
	

	if (nLenYj >= 2)
	{
		/*
		**  Determine the FromOff and ToOff which to used for searching by the pnOrgYj[0].
		*/
		if ((pnOrgYj[0] >= 0) && (pnOrgYj[0] < NUM_YINJIE))
		{
			nFromOff = pDhi->nYjOff[ pnOrgYj[0] ];
			nToOff   = pDhi->nYjOff[ pnOrgYj[0] + 1];
		}
		else /* ((pnOrgYj[0] >= 450) && (pnOrgYj[0] <= 475)) */
		{
			nFromOff = pDhi->nYjOff[ INDEXSMTOYINJIE[pnOrgYj[0] - 450] ];
			nToOff   = pDhi->nYjOff[ INDEXSMTOYINJIE[pnOrgYj[0] - 450 + 1] ];
		}
	
		/* !! DON'T add k++ in this FOR sentence !! */
		for (k = nFromOff; k < nToOff; )
		{
			wDhFreq  = (JWORD)*(pDhArea + k);
			nCzLen   = 2;
			k ++;

			for (m = 0; m < 10; m++)
				wCzHz[m]   = 0x0000;
			for (m = 0; m < nCzLen; m++)
			{
				wCzHz[m]   = (JWORD)(*(pDhArea + k + 1) + ((*(pDhArea + k)) << 8));
				k += 2;
			}

			for (m = 0; m < 14; m++)
			{
				szYj3[m]   = '\0';
				szYj4[m]   = '\0';
			}
			
			if ((pnOrgYj[0] >= 450) && (pnOrgYj[0] <= 475))
				pszYj1 = SHENGMUSTR[ pnOrgYj[0] - 450 ];
			else
				/* Rewrite this line to proc [fangan] ==> [fan gan] and [fang an]. Scott Ma 98-05-12 */
				/* pszYj1 = YINJIESTR_CSZ[ pnOrgYj[0] ];  */
				pszYj1 = YINJIESTR_CSZ[ GbkHz2244ToYj((JINT)wCzHz[0]) ];

			if ((pnOrgYj[1] >= 450) && (pnOrgYj[1] <= 475))
				pszYj2 = SHENGMUSTR[ GbkHz2244ToYjSM((JINT)wCzHz[1]) - 450 ];
			else
				pszYj2 = YINJIESTR_CSZ[ GbkHz2244ToYj((JINT)wCzHz[1]) ];
			strcat(strcat(szYj3, pszYj1), pszYj2);

			/* Add the following 4 lines to proc [fangan] ==> [fan gan] and [fang an]. Scott Ma 98-05-12 */
			if ((pnOrgYj[0] >= 450) && (pnOrgYj[0] <= 475))
				pszYj1 = SHENGMUSTR[ pnOrgYj[0] - 450 ];
			else
				pszYj1 = YINJIESTR_CSZ[ pnOrgYj[0] ];

			if ((pnOrgYj[1] >= 450) && (pnOrgYj[1] <= 475))
				pszYj2 = SHENGMUSTR[ pnOrgYj[1] - 450 ];
			else
				pszYj2 = YINJIESTR_CSZ[ pnOrgYj[1] ];
			strcat(strcat(szYj4, pszYj1), pszYj2);

			nEqualFlag = TRUE;
			if ( strcmp (szYj3, szYj4) != 0)
				nEqualFlag = FALSE;
			
			if ((nEqualFlag == TRUE) && (nMode == LU_CANDI_CALC))
			{
				psc->nSizDhCandi += (nCzLen + 2);	/* Add two JWORD Here to contain Freq Word and a ZERO */
				psc->nNumDhCandi += 1;
				*pnSize += (nCzLen + 2);
			}
			else if ((nEqualFlag == TRUE) && (nMode == LU_CANDI_WRITE))
			{
				psc->pwDhCandi[psc->nSizDhCandi] = wDhFreq;
				for (m = 0; m < nCzLen; m++)
					psc->pwDhCandi[psc->nSizDhCandi + m + 1] = wCzHz[m];
				
				psc->nSizDhCandi += (nCzLen + 2);
				psc->nNumDhCandi += 1;
				*pnSize += (nCzLen + 2);
			}
		}
	}

	/* GB Single Hanzi */
	if (nLenYj >= 1)
	{
		/*
		**  Order of Single Hanzi Candidates:
		**  IF pnOrgYj[0] is a SM, place HIFREQHANZI[?][14] at the head of ShCandi Area
		**                         Place Single Hanzi by Frequence and Yinjie Sequence
		**  IF pnOrgYj[0] is Normal Yinjie [0 ~ 414], place XianForm candis at the head.
		**                         place Single Hanzi by Frequence and Yinjie Sequence
		**
		**  Determine the Fromyj and ToYj which to used for searching by the pnOrgYj[0].
		**  NOTICE: This is different from DhCandi and MhCandi.  
		*/
		if ((pnOrgYj[0] >= 0) && (pnOrgYj[0] < NUM_YINJIE))
		{
			nFromYj  = pnOrgYj[0];
			nToYj    = pnOrgYj[0] + 1;

			nXianNum = (pShi->nYjOff[nToYj] & 0x0F000000) >> 24;
			for (k = 0; k < nXianNum; k++)
			{
				if (nMode == LU_CANDI_CALC)
				{
					psc->nSizShCandi += 3;	  /* Add one ZERO After this Xian Candi */
					psc->nNumShCandi += 1;
					*pnSize += 3;
				}
				else if (nMode == LU_CANDI_WRITE)
				{
					nTmp  = pShi->nYjOff[nToYj] & 0x00FFFFFF;
					chHi  = (UCHAR)*(pShArea + nTmp - (nXianNum * 4) + (k * 4));
					chLow = (UCHAR)*(pShArea + nTmp - (nXianNum * 4) + (k * 4) + 1);
					psc->pwShCandi[psc->nSizShCandi]     = (JWORD)((chHi << 8) + chLow);
					
					chHi  = (UCHAR)*(pShArea + nTmp - (nXianNum * 4) + (k * 4) + 2);
					chLow = (UCHAR)*(pShArea + nTmp - (nXianNum * 4) + (k * 4) + 3);
					psc->pwShCandi[psc->nSizShCandi + 1] = (JWORD)((chHi << 8) + chLow);
					
					psc->pwShCandi[psc->nSizShCandi + 2] = 0x0000;

					psc->nSizShCandi += 3;
					psc->nNumShCandi += 1;
					*pnSize += 3;
				}
			}
		}
		else   /* ((pnOrgYj[0] >= 450) && (pnOrgYj[0] <= 475)) */
		{
			nFromYj  = INDEXSMTOYINJIE[ pnOrgYj[0] - 450 ];
			nToYj    = INDEXSMTOYINJIE[ pnOrgYj[0] - 450 + 1 ];

			for (m = 0; m < 7; m++)         /* There are 7 HIFREQHANZI in each SM Yinjie. See PyBasic.h */
			{
				if (nMode == LU_CANDI_CALC)
				{
					psc->nSizShCandi += 2;	  /* Add one ZERO After this HIFREQHANZI */
					psc->nNumShCandi += 1;
					*pnSize += 2;
				}
				else if (nMode == LU_CANDI_WRITE)
				{
					chHi  = HIFREQHANZI[pnOrgYj[0] - 450][2 * m];
					chLow = HIFREQHANZI[pnOrgYj[0] - 450][2 * m + 1];
					psc->pwShCandi[psc->nSizShCandi]     = (JWORD)((chHi << 8) + chLow);
					
					psc->nSizShCandi += 2;
					psc->nNumShCandi += 1;
					*pnSize += 2;
				}
			}
		}
		
		/*
		**  Because 'Xian' Form is already included in above processing (0 ~ 414), and no necessary
		**  for (450 ~ 475), So, not to include then in the following reclycle.
		*/
		for(k = nFromYj; k < nToYj; k++)
		{
			nXianNum = (pShi->nYjOff[k + 1] & 0x0F000000) >> 24;
			nFromOff = pShi->nYjOff[ k ] & 0x00FFFFFF;
			nToOff   = (pShi->nYjOff[ k + 1] & 0x00FFFFFF) - (4 * nXianNum);
			
			/* !!Don't add m++ in this FOR sentence!! */
			for(m = nFromOff; m < nToOff;  )
			{
				if (nMode == LU_CANDI_CALC)
				{
					psc->nSizShCandi += 2;	  /* Add one ZERO After each Single Hanzi Candidate */
					psc->nNumShCandi += 1;
					*pnSize += 2;
					m += 2;
				}
				else if (nMode == LU_CANDI_WRITE)
				{
					chHi  = (UCHAR)*(pShArea + m);
					chLow = (UCHAR)*(pShArea + m + 1);
					psc->pwShCandi[psc->nSizShCandi]   = (JWORD)((chHi << 8) + chLow);
					
					psc->nSizShCandi += 2;
					psc->nNumShCandi += 1;
					*pnSize += 2;
					m += 2;
				}
			}
		}
	}
	
	/* GBKKKK!!! Single Hanzi */
#ifdef _DRAW_IM_WIN_H
	if (nLenYj >= 1)
#else	
	if ((nLenYj >= 1) && (strcmp(szLocale, "zh.GBK") == 0))
#endif
	{
		nTmp = pnOrgYj[0];

		/* Process "a", "e", "o", "m", "n" */
		if (nTmp == 450)
			nTmp = 0;
		else if (nTmp == 455)
			nTmp = 80;
		else if (nTmp == 462)
			nTmp = 191;
		else if (nTmp == 463)
			nTmp = 211;
		else if (nTmp == 464)
			nTmp = 237;

		if ((nTmp >= 0) && (nTmp < NUM_YINJIE))
		{
			nFromOff = pGbki->nYjOff[ nTmp ];
			nToOff   = pGbki->nYjOff[ nTmp + 1];
		
			/* !!Don't add m++ in this FOR sentence!! */
			for(m = nFromOff; m < nToOff;  )
			{
				if (nMode == LU_CANDI_CALC)
				{
					psc->nSizGbkCandi += 2;	  /* Add one ZERO After each GBK Single Hanzi Candidate */
					psc->nNumGbkCandi += 1;
					*pnSize += 2;
					m += 2;
				}
				else if (nMode == LU_CANDI_WRITE)
				{
					chHi  = (UCHAR)*(pGbkArea + m);
					chLow = (UCHAR)*(pGbkArea + m + 1);
					psc->pwGbkCandi[psc->nSizGbkCandi]   = (JWORD)((chHi << 8) + chLow);
				
					psc->nSizGbkCandi += 2;
					psc->nNumGbkCandi += 1;
					*pnSize += 2;
					m += 2;
				}
			}
		}
	}
	

	/****************************************************************************************
	**************************    Enum Candi in udcAll     **********************************
	****************************************************************************************/
	/*
	** Get puc->pwSpecCandi[6]. pwSepcCandi only be given if pnOrgYj[0] is among [0 ~ 414]
	*/
	if ((nLenYj >= 1) && (pnOrgYj[0] >= 0) && (pnOrgYj[0] < NUM_YINJIE))
	{
		nTmp = 0;
		for (i = 0; i < (udcAll.udcfh.nSizeSpecHz / 2); i++)
		{
			if (udcAll.pwUdcSh[i] == 0x0000)
				nTmp++;
			
			if (nTmp == (pnOrgYj[0] + 1))
			{
				i++;
				for (m = i; udcAll.pwUdcSh[m] != 0x0000; m++)
				{
					/* MAX: 6 Special Hanzi for each Yinjie in < UdCiku.dat >!! */
					if ((m - i) > 5)
						break;       /* Break out FOR_m */
					
					if (nMode == LU_CANDI_WRITE)
						puc->pwSpecCandi[m - i] = udcAll.pwUdcSh[m];
					puc->nNumSpecCandi ++;
				}
				break;           /* Break out FOR_i */
			}
		}
	}
	else
		puc->nNumSpecCandi = 0;

	/*
	**  Get puc->nNumUdc28Candi and puc->nSizUdc28Candi, AND
	**  fill puc->pwUdc28Candi[] if nMode == LU_CANDI_WRITE
	*/
	if (nLenYj >= 2)
	{
		/*
		**  Determine the nFromYj and nToYj which to used for searching by the pnOrgYj[0].
		*/
		if ((pnOrgYj[0] >= 0) && (pnOrgYj[0] < NUM_YINJIE))
		{
			nFromYj  = pnOrgYj[0];
			nToYj    = pnOrgYj[0] + 1;
		}
		else   /* ((pnOrgYj[0] >= 450) && (pnOrgYj[0] <= 475)) */
		{
			nFromYj  = INDEXSMTOYINJIE[ pnOrgYj[0] - 450 ];
			nToYj    = INDEXSMTOYINJIE[ pnOrgYj[0] - 450 + 1 ];
		}

		for(k = nFromYj; k < nToYj; k++)
		{
			nCurSize   = udcAll.udci.nYjOff[k + 1] - udcAll.udci.nYjOff[k];      /* In BYTE */

			/* NO i++ in this FOR sentence */
			for (i = 0; i < nCurSize / 2; )
			{
				nUdc28FreqLen =  udcAll.pwUdc28[k][i] & 0x00FF;
				nUdc28Len     = (udcAll.pwUdc28[k][i] & 0x0007) + 2;
				i++;

				for (m = 0; m < 10; m++)
					wCzHz[m]  = 0x0000;
				for (m = 0; m < nUdc28Len; m++)
				{
					wCzHz[m]  = udcAll.pwUdc28[k][i];
					i++;
				}
			
				nEqualFlag = FALSE;
				if (( (nLenYj <= 4) && (nUdc28Len  <= nLenYj) ) || 
				    ( (nLenYj >= 5) && (nMatchMode == LU_MATCH_WIDELY) ) || 
				    ( (nLenYj >= 5) && (nMatchMode == LU_MATCH_STRICT) && (nUdc28Len <= nLenYj) )  )
				{
					nEqualFlag = TRUE;
				
					for(m = 0; m < _MIN(nLenYj, nUdc28Len); m++)
						if ( ( pnOrgYj[m] != GbkHz2244ToYjSM((JINT)wCzHz[m]) ) && 			\
						     ( pnOrgYj[m] != GbkHz2244ToYj  ((JINT)wCzHz[m]) ) )
						{
							nEqualFlag = FALSE;
							break;
						}
				}

				/* Is there any GBK UdcCizu that to be omitted? */
				if (nEqualFlag == TRUE)
				{
					nfGbkCizu = FALSE;
					for (m = 0; m < nUdc28Len; m++)
					{
						if (IsGbkkkHz(wCzHz[m]) == TRUE)
						{
							nfGbkCizu = TRUE;
							break;
						}
					}
					
					if ((nfGbkCizu == TRUE) && (strcmp(szLocale, "zh") == 0))
						nEqualFlag = FALSE;
#ifdef _DRAW_IM_WIN_H
					nEqualFlag = TRUE;
#endif					
				}
				
				if ((nEqualFlag == TRUE) && (nMode == LU_CANDI_CALC))
				{
					puc->nSizUdc28Candi += (nUdc28Len + 2);	/* Add two JWORD Here to contain Freq&Len Word and a ZERO */
					puc->nNumUdc28Candi += 1;
					*pnSize += (nUdc28Len + 2);
				}
				else if ((nEqualFlag == TRUE) && (nMode == LU_CANDI_WRITE))
				{
					puc->pwUdc28Candi[puc->nSizUdc28Candi] = (JWORD)nUdc28FreqLen;
					for (m = 0; m < nUdc28Len; m++)
						puc->pwUdc28Candi[puc->nSizUdc28Candi + m + 1] = wCzHz[m];
				
					puc->nSizUdc28Candi += (nUdc28Len + 2);
					puc->nNumUdc28Candi += 1;
					*pnSize += (nUdc28Len + 2);
				}
			}
		}
	}
	
	*pnSize += 1;
	return TRUE;
}


/*
**  Initialize Structure SysCandi
*/
VOID InitStructSc(SysCandi* psc)
{
	JINT    i;
	
	for(i = 0; i < 9; i++)
		psc->nOrgYj[i]     = 0x00000000;

	psc->nLenYj       = 0;
	psc->nNumShCandi  = 0;
	psc->nNumDhCandi  = 0;
	psc->nNumMhCandi  = 0;
	psc->nNumGbkCandi = 0;
	
	psc->nSizShCandi  = 0;
	psc->nSizDhCandi  = 0;
	psc->nSizMhCandi  = 0;
	psc->nSizGbkCandi = 0;
	
	free (psc->pwShCandi);
	free (psc->pwDhCandi);
	free (psc->pwMhCandi);
	free (psc->pwGbkCandi);
	psc->pwShCandi   = NULL;
	psc->pwDhCandi   = NULL;
	psc->pwMhCandi   = NULL;
	psc->pwGbkCandi  = NULL;
}


/*
**  nLenYj indicates the length of pnOrgYj. 
**  Max Length of nLenYj is 9, even Max Hanzi Length in
**  current PyCiku.dat is 7.
**
**  Notice here: pnOrgYj[i] may be 0x00010000 + [0 ~ 475] to indicates there is 
**               ['] before corressponding yinjie string.
**  return TRUE or FALSE
*/
JINT LookupCiku(JINT* pnOrgYj, JINT nLenYj, JINT nMatchMode, SysCandi* psc, UdcCandi* puc)
{
	JINT    nSize, i;

	nSize = 0;

	InitStructSc(psc);
	InitStructUc(puc);
	
	/* 
	** Set the content of psc->nOrgYj and pscYj->nLenYj    AND 
	** Filter those Yjcode which start with a [']. 
	*/
	for(i = 0; i < nLenYj; i++)
	{
		psc->nOrgYj[i]  = pnOrgYj[i];
		pnOrgYj[i]     &= 0x0000FFFF;
	}
	psc->nLenYj  = nLenYj;
	
	EnumCandi(pnOrgYj, nLenYj, psc, puc, &nSize, nMatchMode, LU_CANDI_CALC);
	
	psc->pwMhCandi    = (JWORD*)malloc((psc->nSizMhCandi  + MALIGN) * sizeof(JWORD));
	psc->pwDhCandi    = (JWORD*)malloc((psc->nSizDhCandi  + MALIGN) * sizeof(JWORD));
	psc->pwShCandi    = (JWORD*)malloc((psc->nSizShCandi  + MALIGN) * sizeof(JWORD));
	psc->pwGbkCandi   = (JWORD*)malloc((psc->nSizGbkCandi + MALIGN) * sizeof(JWORD));
	puc->pwUdc28Candi = (JWORD*)malloc((puc->nSizUdc28Candi + MALIGN) * sizeof(JWORD));

	if ((psc->pwMhCandi == NULL)  || (psc->pwDhCandi == NULL) || (psc->pwShCandi == NULL) || 
		(psc->pwGbkCandi == NULL) || (puc->pwUdc28Candi == NULL) )
	{
		fprintf(stderr, "Error!! Failed to Malloc() in Function LookupCiku().\n");
		return FALSE;
	}

	memset(psc->pwMhCandi,  '\0', (psc->nSizMhCandi  + MALIGN) * sizeof(JWORD));
	memset(psc->pwDhCandi,  '\0', (psc->nSizDhCandi  + MALIGN) * sizeof(JWORD));
	memset(psc->pwShCandi,  '\0', (psc->nSizShCandi  + MALIGN) * sizeof(JWORD));
	memset(psc->pwGbkCandi, '\0', (psc->nSizGbkCandi + MALIGN) * sizeof(JWORD));
	memset(puc->pwUdc28Candi, '\0', (puc->nSizUdc28Candi + MALIGN) * sizeof(JWORD));
	
	EnumCandi(pnOrgYj, nLenYj, psc, puc, &nSize, nMatchMode, LU_CANDI_WRITE);
	
	/* Additional Process for Spec Hanzi Candi, MXL 98.01.12 */
	if (0 == (psc->nNumMhCandi + psc->nNumDhCandi + puc->nNumUdc28Candi))
		puc->nNumSpecCandi = 0;
	
	/* Sort Candidates in structure SysCandi and UdcCandi by Frequence */
	SortCandi(psc, puc);
	
	return TRUE;
}


/*
**  Sort Candidates in Structure SysCandi by Length and Frequence
**  
**  NOT IMPROVED:
**  [** TO IMPROVE: In SortSysCandi(), Rearrange XIAN candies to proper position **] 97.11.28.
**  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
*/
VOID SortCandi(SysCandi* psc, UdcCandi* puc)
{
	JINT    nNumM, nSizM, nNumD, nSizD, nNumUdc28, nSizUdc28;
	JINT    nBuf, nTmp, i, k, m, n, p, nLenM, nFreqM, nLenUdc28, nFreqUdc28;
	JWORD   *pwBuf = NULL;
	
	nNumM   = psc->nNumMhCandi;
	nSizM   = psc->nSizMhCandi;
	nNumD   = psc->nNumDhCandi;
	nSizD   = psc->nSizDhCandi;
	nNumUdc28 = puc->nNumUdc28Candi;
	nSizUdc28 = puc->nSizUdc28Candi;

	if ((nNumM <= 1) && (nNumD <= 1) && (nNumUdc28 <= 1))
		return;
	
	nBuf = _MAX(nSizM, nSizD);
	nBuf = _MAX(nBuf, nSizUdc28);
	
	pwBuf = (JWORD *)malloc((nBuf + MALIGN) * sizeof(JWORD));
	if (pwBuf == NULL)
	{
		fprintf(stderr, "Failed to alloc Memory in function SortSysCandi().\n");
		return;
	}
	
	/*
	**  For MultipleHanzi Candidates, by Length First, by Frequence Second.
	*/
	nLenM = nFreqM = 0;
	if(nNumM > 1)
	{
		memset(pwBuf, '\0', (nBuf + MALIGN) * sizeof(JWORD));
		
		p = m = n = 0;
		for(i = 0xFF; (i >= 0x00) && (p < nNumM); i--)
		{
			for(k = 0; k < nSizM; )
			{
				/*
				**  Exchange [Freq + Len] to [Len + Freq] (nTmp), because by Length first.
				**  Notice: (nLen + 2) is the really length of this Mh Cizu,
				**          another 2 is (Len+Freq) WORD in front and Zero WORD in End.
				*/
				nLenM  = psc->pwMhCandi[k] & 0x07;
				nFreqM = psc->pwMhCandi[k] & 0xF8;
				nTmp   = (nLenM << 5) + (nFreqM >> 3);
				if(nTmp == i)
				{
					for(m = 0; m < (nLenM + 2 + 2); m++)
						pwBuf[n++] = psc->pwMhCandi[k + m];
					p++;
				}
				k += (nLenM + 2 + 2);
			}
		}
		
		for(i = 0; i < nSizM; i++)
			psc->pwMhCandi[i] = pwBuf[i];
	}
	
	/*
	**  For DoubleHanzi Candidates, by Frequence only.
	*/
	if(nNumD > 1)
	{
		memset(pwBuf, '\0', (nBuf + MALIGN) * sizeof(JWORD));
		
		p = m = n = 0;
		for(i = 0xFF; (i >= 0x00) && (p < nNumD); i--)
		{
			for(k = 0; k < nSizD; k++)
			{
				nTmp   = psc->pwDhCandi[k];
				if(nTmp == i)
				{
					for(m = 0; m < (2 + 2); m++)
						pwBuf[n++] = psc->pwDhCandi[k + m];
					p++;
				}
			}
		}
		
		for(i = 0; i < nSizD; i++)
			psc->pwDhCandi[i] = pwBuf[i];
	}


	/*
	**  For Udc come from <UdCiku.dat>, by Length First, by Frequence Second.
	*/
	nLenUdc28 = nFreqUdc28 = 0;
	if(nNumUdc28 > 1)
	{
		memset(pwBuf, '\0', (nBuf + MALIGN) * sizeof(JWORD));
		
		p = m = n = 0;
		for(i = 0xFF; (i >= 0x00) && (p < nNumUdc28); i--)
		{
			for(k = 0; k < nSizUdc28; )
			{
				/*
				**  Exchange [Freq + Len] to [Len + Freq] (nTmp), because by Length first.
				**  Notice: (nLen + 2) is the really length of this Mh Cizu,
				**          another 2 is (Len+Freq) WORD in front and Zero WORD in End.
				*/
				nLenUdc28  = puc->pwUdc28Candi[k] & 0x07;
				nFreqUdc28 = puc->pwUdc28Candi[k] & 0xF8;
				nTmp   = (nLenUdc28 << 5) + (nFreqUdc28 >> 3);
				if(nTmp == i)
				{
					for(m = 0; m < (nLenUdc28 + 2 + 2); m++)
						pwBuf[n++] = puc->pwUdc28Candi[k + m];
					p++;
				}
				k += (nLenUdc28 + 2 + 2);
			}
		}
		
		for(i = 0; i < nSizUdc28; i++)
			puc->pwUdc28Candi[i] = pwBuf[i];
	}

	free(pwBuf);
}


/*
**  Adjust the freqence of a specified Ciku. Length of this cizu is 
**  specified in nLen.
**
**  Increase the frequence of this Dh or Mh, decrease the frequence
**  of other Dh or Mh which have same Yjcode.
**
**  For Sh, move the Hanzi forward to a certain place, move other
**  Hanzies backward.
*/
VOID AdjustFreq(JWORD* pwHz2244, JINT nLenThis)
{
	JINT    nYjFirst;
	JINT    nCzLen, i, k, m, t;
	JINT    nFromOff, nToOff;
	JWORD   wCzHz, wMhLenFreq, wFreq;
	JINT    nEqualFlag;
	CHAR    szDhYj1[14], szDhYj2[14];
	UCHAR   pchHz2244[20];     /* Max is 9 Hanzi!! */
	JINT    nFindFlag;
	JINT    nUdc28FreqLen, nUdc28Len;
	JINT    nCurSize;
	JINT    nXianNum, nPos;
	BYTE    *pbAreaBase;

	CikuHeader  *pCkh;
	ShIndex     *pShi;
	DhIndex     *pDhi;
	MhIndex     *pMhi;
	GbkIndex    *pGbki;
	BYTE        *pShArea;
	BYTE        *pDhArea;
	BYTE        *pMhArea;
	BYTE        *pGbkArea;

	pCkh     = (CikuHeader *)pCkAll;
	pShi     = (ShIndex  *)(pCkAll + pCkh->nIdxShPos);
	pDhi     = (DhIndex  *)(pCkAll + pCkh->nIdxDhPos);
	pMhi     = (MhIndex  *)(pCkAll + pCkh->nIdxMhPos);
	pGbki    = (GbkIndex *)(pCkAll + pCkh->nIdxGbkPos);
	
	pShArea  = (BYTE *)(pCkAll + pShi->nStartPos);
	pDhArea  = (BYTE *)(pCkAll + pDhi->nStartPos);
	pMhArea  = (BYTE *)(pCkAll + pMhi->nStartPos);
	pGbkArea = (BYTE *)(pCkAll + pGbki->nStartPos);

	memset(pchHz2244, '\0', 20);
	Jword2Uchar(pwHz2244, pchHz2244, nLenThis);
	
	nFindFlag = FALSE;
	/* nYjFirst must be in range 0~414 */
	nYjFirst = GbkHz2244ToYj((JINT)pwHz2244[0]);

	if (nLenThis >= 3)
	{
		/*
		**  Determine the FromOff and ToOff which to used for searching by the pnOrgYj[0].
		*/
		nFromOff = pMhi->nYjOff[ nYjFirst ];
		nToOff   = pMhi->nYjOff[ nYjFirst + 1];
		
		/* !! DON'T add k++ in this FOR sentence !! */
		for (k = nFromOff; k < nToOff; )
		{
			wMhLenFreq = (JWORD)*(pMhArea + k);
			nCzLen     = 2 + ((UCHAR)*(pMhArea + k) & 0x07);
			k++;

			/*  It is just this Cizu, Increase its frequence here. */
			if ((nCzLen == nLenThis) &&
				(strncmp((CHAR*)(&pMhArea[k]), (CHAR*)pchHz2244, 2 * nCzLen) == 0) )
			{
				/* Just set Frequence to highest. */
				*(pMhArea + k - 1) = (BYTE)(0xF8 + (nCzLen - 2));
				k += (2 * nCzLen);
				nFindFlag = TRUE;
			}
			/*
			**  Have the same length. Is it also have same Yjcode? If yes, 
			**  reduce the frequence.
			*/
			else if ((nCzLen == nLenThis) &&
			        (strncmp((CHAR*)(&pMhArea[k]), (CHAR*)pchHz2244, 2 * nCzLen) != 0) )
			{
				nEqualFlag = TRUE;

				/*
				** Compare from the second Hanzi, because the first Hanzi must
				** same Yjcode. So, skip the first by adding t += 2.
				*/
				t = k;
				t += 2;
				for (m = 1; m < nCzLen; m++)
				{
					wCzHz   = (JWORD)(*(pMhArea + t + 1) + ((*(pMhArea + t)) << 8));
					t += 2;

					if ( GbkHz2244ToYj((JINT)pwHz2244[1]) != GbkHz2244ToYj((JINT)wCzHz) )
					{
						nEqualFlag = FALSE;
						break;
					}
				}

				/* Have same Yjcodes in every Hanzi, reduce its Frequence Here. */
				if (nEqualFlag == TRUE)
				{
					wMhLenFreq = (JWORD)*(pMhArea + k - 1);
					/*
					** Length bits have the lowest 3 bits.  -8 means reduce the Frequence
					** by ONE level. if its Freq Level is 1, no reduce needed.
					*/
					if (wMhLenFreq >= 16)
						*(pMhArea + k - 1) -= 8;
				}

				k += (2 * nCzLen);
			}
			/* If it doesn't have the same length, just skip this cizu. */
			else
				k += (2 * nCzLen);
		}
	}
	
	else if (nLenThis == 2)
	{
		/*
		**  Determine the FromOff and ToOff which to used for searching by the pnOrgYj[0].
		*/
		nFromOff = pDhi->nYjOff[ nYjFirst ];
		nToOff   = pDhi->nYjOff[ nYjFirst + 1];
		
		/* !! DON'T add k++ in this FOR sentence !! */
		for (k = nFromOff; k < nToOff; )
		{
			wFreq   = (JWORD)*(pDhArea + k);
			nCzLen  = 2;
			k++;

			/*  It is just this Cizu, Increase its frequence here. */
			if (strncmp((CHAR*)(&pDhArea[k]), (CHAR*)pchHz2244, 4) == 0)
			{
				*(pDhArea + k - 1) = 0xFF;
				k += 4;
				nFindFlag = TRUE;
			}
			/*
			**  Have the same length. Is it also have same Yjcode? If yes, 
			**  reduce the frequence.
			*/
			else
			{
				for(i = 0; i < 14; i++)
					szDhYj1[i] = szDhYj2[i] = '\0';

				/* Cat total YinjieString into szDhYj1 */
				strcat( strcat(szDhYj1, YINJIESTR_CSZ[nYjFirst]),	
				                        YINJIESTR_CSZ[GbkHz2244ToYj((JINT)pwHz2244[1])] );

				t = k;
				wCzHz   = (JWORD)(*(pDhArea + t + 1) + ((*(pDhArea + t)) << 8));
				strcat(szDhYj2, YINJIESTR_CSZ[GbkHz2244ToYj((JINT)wCzHz)]);

				t += 2;
				wCzHz   = (JWORD)(*(pDhArea + t + 1) + ((*(pDhArea + t)) << 8));
				strcat(szDhYj2, YINJIESTR_CSZ[GbkHz2244ToYj((JINT)wCzHz)]);

				nEqualFlag = TRUE;
				if (strcmp(szDhYj1, szDhYj2) != 0)
					nEqualFlag = FALSE;

				/* Have same Yjcodes in every Hanzi, reduce its Frequence Here. */
				if (nEqualFlag == TRUE)
				{
					wFreq = (JWORD)*(pDhArea + k - 1);
					/*
					** Decrease by ONE Level.
					*/
					if (wFreq >= 2)
						*(pDhArea + k - 1) -= 1;
				}
				k += 4;

			}
		}
	}

	/* nLenThis == 1, GB and GBK */
	else if (nLenThis == 1)
	{
		if (IsGbkkkHz(pwHz2244[0]) == TRUE)   /* GbKkk */
		{
			nFromOff   = pGbki->nYjOff[ nYjFirst ];
			nToOff     = pGbki->nYjOff[ nYjFirst + 1 ];
			pbAreaBase = pGbkArea;
		}
		else    /* Normal GB */
		{
			nXianNum   = (pShi->nYjOff[nYjFirst + 1] & 0x0F000000) >> 24;
			nFromOff   = pShi->nYjOff[nYjFirst] & 0x00FFFFFF;
			nToOff     = (pShi->nYjOff[nYjFirst + 1] & 0x00FFFFFF) - (4 * nXianNum);
			pbAreaBase = pShArea;
		}
		
		nPos = 0;
		for (k = nFromOff; k < nToOff; k += 2)
		{
			if (strncmp((CHAR*)(&pbAreaBase[k]), (CHAR*)pchHz2244, 2) == 0)
			{
				nPos = (k - nFromOff) / 2;
				break;
			}
		}
		
		/*
		**  If NOT the first Hanzi in ShArea[nYj] or GbkArea[nYj], move this Hanzi
		**  forward by (nPos / 4  + 1)
		*/
		if (nPos > 0)
		{
			m = 0;
			for (k = nFromOff + (2 * nPos); m < (nPos / 4  + 1); )
			{
				pbAreaBase[k + 1] = pbAreaBase[k - 1];
				pbAreaBase[k]     = pbAreaBase[k - 2];
				k -= 2;
				m++;
			}
			pbAreaBase[k + 1] = pchHz2244[1];
			pbAreaBase[k]     = pchHz2244[0];
		}
	}

	/*
	**  Otherwise, this must be an UserDefinedCizu.
	*/
	if ((nLenThis >= 2) && (nFindFlag == FALSE))
	{
		nCurSize   = udcAll.udci.nYjOff[nYjFirst + 1] - udcAll.udci.nYjOff[nYjFirst];      /* In BYTE */

		/* NO i++ in this FOR sentence */
		for (i = 0; i < nCurSize / 2; )
		{
			nUdc28FreqLen =  udcAll.pwUdc28[nYjFirst][i] & 0x00FF;
			nUdc28Len     = (udcAll.pwUdc28[nYjFirst][i] & 0x0007) + 2;
			i++;

			/*  It is just this Cizu, Increase its frequence here. */
			if ((nUdc28Len == nLenThis) &&
				(strncmp((CHAR*)&(udcAll.pwUdc28[nYjFirst][i]), (CHAR*)pchHz2244, 2 * nUdc28Len) == 0) )
			{
				/* Just set Frequence to highest. */
				udcAll.pwUdc28[nYjFirst][i - 1] = (BYTE)(0xF8 + (nUdc28Len - 2));
				i += nUdc28Len;
				nFindFlag = TRUE;
			}
			else
			{
				if (nUdc28FreqLen >= 0x0010)
					udcAll.pwUdc28[nYjFirst][i - 1] -= 8;
				i += nUdc28Len;
			}
		}
	}

}


/*
**  Lookup the System Ciku and User Defined Ciku to find out whether pwHz2244 Exist or not.
**  Length of this Cizu is given in nLenThis.  Constant is defined file <CikuOper.h>
**  If NO,                           RETURN 0;  ==>  NON_EXIST_CIZU 
**  If YES && in System Ciku,        RETURN 1;  ==>  SYS_EXIST_CIZU 
**  If YES && in User Defined Ciku,  RETURN 2;  ==>  UDC_EXIST_CIZU 
*/
JINT IsCizuExist(JWORD* pwHz2244, JINT nLenThis)
{
	JINT    nFindFlag;
	
	JINT    nYjFirst;
	JINT    nCzLen, i, k;
	JINT    nFromOff, nToOff;
	JWORD   wMhLenFreq, wFreq;
	UCHAR   pchHz2244[20];     /* Max is 9 Hanzi!! */
	JINT    nCurSize, nUdc28FreqLen, nUdc28Len;

	CikuHeader  *pCkh;
	ShIndex     *pShi;
	DhIndex     *pDhi;
	MhIndex     *pMhi;
	GbkIndex    *pGbki;
	BYTE        *pShArea;
	BYTE        *pDhArea;
	BYTE        *pMhArea;
	BYTE        *pGbkArea;

	pCkh     = (CikuHeader *)pCkAll;
	pShi     = (ShIndex  *)(pCkAll + pCkh->nIdxShPos);
	pDhi     = (DhIndex  *)(pCkAll + pCkh->nIdxDhPos);
	pMhi     = (MhIndex  *)(pCkAll + pCkh->nIdxMhPos);
	pGbki    = (GbkIndex *)(pCkAll + pCkh->nIdxGbkPos);
	
	pShArea  = (BYTE *)(pCkAll + pShi->nStartPos);
	pDhArea  = (BYTE *)(pCkAll + pDhi->nStartPos);
	pMhArea  = (BYTE *)(pCkAll + pMhi->nStartPos);
	pGbkArea = (BYTE *)(pCkAll + pGbki->nStartPos);

	nFindFlag = NON_EXIST_CIZU;
	memset(pchHz2244, '\0', 20);
	Jword2Uchar(pwHz2244, pchHz2244, nLenThis);
	
	/* nYjFirst must be in range 0~414 */
	nYjFirst = GbkHz2244ToYj((JINT)pwHz2244[0]);

	if (nLenThis >= 3)
	{
		/*
		**  Determine the FromOff and ToOff which to used for searching by the pnOrgYj[0].
		*/
		nFromOff = pMhi->nYjOff[ nYjFirst ];
		nToOff   = pMhi->nYjOff[ nYjFirst + 1];
		
		/* !! DON'T add k++ in this FOR sentence !! */
		for (k = nFromOff; k < nToOff; )
		{
			wMhLenFreq = (JWORD)*(pMhArea + k);
			nCzLen     = 2 + ((UCHAR)*(pMhArea + k) & 0x07);
			k++;

			/*  It is just this Cizu, Set nFindFlag and return */
			if ((nCzLen == nLenThis) &&
				(strncmp((CHAR*)(&pMhArea[k]), (CHAR*)pchHz2244, 2 * nCzLen) == 0) )
			{
				nFindFlag  = SYS_EXIST_CIZU;
				return nFindFlag;
			}
			/* Just Skip this Mh Word */
			else
				k += (2 * nCzLen);
		}
	}
	
	else if (nLenThis == 2)
	{
		/*
		**  Determine the FromOff and ToOff which to used for searching by the pnOrgYj[0].
		*/
		nFromOff = pDhi->nYjOff[ nYjFirst ];
		nToOff   = pDhi->nYjOff[ nYjFirst + 1];
		
		/* !! DON'T add k++ in this FOR sentence !! */
		for (k = nFromOff; k < nToOff; )
		{
			wFreq   = (JWORD)*(pDhArea + k);
			nCzLen  = 2;
			k++;

			/* It is just this Cizu, Increase its frequence here. */
			if (strncmp((CHAR*)(&pDhArea[k]), (CHAR*)pchHz2244, 4) == 0)
			{
				nFindFlag  = SYS_EXIST_CIZU;
				return nFindFlag;
			}
			/* Just Skip this Dh Cizu */
			else
				k += 2 * nCzLen;
		}
	}
	
	else if (nLenThis == 1)
	{
		nFindFlag = SYS_EXIST_CIZU;
		return nFindFlag;
	}
	
	if (nFindFlag == NON_EXIST_CIZU)
	{
		nCurSize   = udcAll.udci.nYjOff[nYjFirst + 1] - udcAll.udci.nYjOff[nYjFirst];      /* In BYTE */

		/* NO i++ in this FOR sentence */
		for (i = 0; i < nCurSize / 2; )
		{
			nUdc28FreqLen =  udcAll.pwUdc28[nYjFirst][i] & 0x00FF;
			nUdc28Len     = (udcAll.pwUdc28[nYjFirst][i] & 0x0007) + 2;
			i++;

			/*  It is just this Cizu, Increase its frequence here. 
			**
			**  A Small & Big BUG was Arrested!! aHa!! 97-12-28!!
			**  This bug appear in INTEL x86 CPU!!
			if ((nUdc28Len == nLenThis) &&
				(strncmp((CHAR*)&(udcAll.pwUdc28[nYjFirst][i]), (CHAR*)pchHz2244, 2 * nUdc28Len) == 0) )
			*/
			if ((nUdc28Len == nLenThis) &&
				(JwordNCmp(&(udcAll.pwUdc28[nYjFirst][i]), pwHz2244, nUdc28Len) == 0) )
			{
				nFindFlag  = UDC_EXIST_CIZU;
				return nFindFlag;
			}
			else
				i += nUdc28Len;
		}
	}
	
	return nFindFlag;      /* Must be NON_EXIST_CIZU HERE. */
}


/*
**  Enumlate all those Mh, Dh and Sh selections in pSge->pwSlctHz
**  AND call AdjustFreq().
**  JWORD     pwSlctHz[512];     Selected Hanzi of Every Step, each seperated by 0009
**  JWORD     pwSlctRawPy[512];  Crossponding Pinyin (include <'> <~>) of above Hz2244, septed by 0009
**  JINT      nSlctSteps;        Step Number of Selection
**
**  This function may only be called after FULL COMMITTED!!!
*/
VOID ProcFreq(SesGuiElement* pSge)
{
	JINT    i, k, m;
	JWORD   wThisSel[9];        /* Contain Hz2244 Cizu Item */
	JINT    nLenThis;

	k = 0;
	nLenThis = 0;
	for(m = 0; m < 9; m++)
		wThisSel[m] = 0x0000;

	/* Don't add i++ and k++ in this FOR sentence */
	for (i = 0; (i < pSge->nSlctSteps) && (k < UTWO); )
	{
		if (pSge->pwSlctHz[k] == 0x0009)
		{
			k++;
			i++;
			AdjustFreq(wThisSel, nLenThis);
			for(m = 0; m < 9; m++)
				wThisSel[m] = 0x0000;
			nLenThis = 0;
		}
		else
		{
			wThisSel[nLenThis] = pSge->pwSlctHz[k];
			nLenThis++;
			k++;
		}
	}
}

