/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include <locale.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "OptionConfig.h"

#define USER_PROFILE_PATH                 ".Xlocale"
#define USER_OPTION_FILE_NAME             "options.cfg"

#define THAIOPTION_ISC_MODE_STRING        "input_check_mode"
#define THAIOPTION_KEYBOARD_TYPE_STRING   "keyboard_type"

#define MAX_LINE_LEN	256

char *skip_space(char *s)
{
        while (*s && (*s == ' ' || *s == '\t')) s++;
        return s;
}

char *to_space(char *s)
{
	while (*s && !(*s == ' ' || *s == '\t')) s++;
        return s;
}

char *trim_string(char *s)
{
	char *head_ptr, *tail_ptr;

	if (!s || !*s) return(s);

	head_ptr = s;

	/* trim left space */
	while(*head_ptr && (*head_ptr == ' ' || *head_ptr == '\t' || *head_ptr == '\n'))
		head_ptr ++;

	if (!*head_ptr) return(head_ptr);

	/* trim right space */
	tail_ptr = head_ptr + strlen(head_ptr) - 1;
	
	while(*tail_ptr && (*tail_ptr == ' ' || *tail_ptr == '\t' || *tail_ptr == '\n')) {
		*tail_ptr = '\0';
		tail_ptr --;
	}

	return(head_ptr);
}

int parse_line_for_pair(char *line_buf, char **key_ptr, char **value_ptr)
{
	char *ptr;

	*key_ptr = ptr = skip_space(line_buf);

	while(*ptr && !(*ptr==' ' || *ptr=='\t' || *ptr=='\n' || *ptr=='=' || *ptr==':')) ptr++;

	if (*ptr=='=' || *ptr==':') {
		*ptr = '\0';
		ptr = skip_space(ptr+1);
	} else if (*ptr==' ' || *ptr=='\t') {
		*ptr = '\0';
		ptr = skip_space(ptr+1);
		if (*ptr=='=' || *ptr==':') {
			ptr = skip_space(ptr+1);
		}
	} else if (*ptr=='\n') {
		*ptr = '\0';
	}

	/* skip " */
	if (*ptr == '\"') ptr++;
	*value_ptr = ptr;
	
	ptr = to_space(ptr);
	if (*(ptr-1) == '\"') ptr--;
	*ptr = '\0';

	return(0);
}

char *get_locale_name()
{
	char *locale_name;
#if 0
	locale_name = setlocale(LC_CTYPE, NULL);
	if (locale_name == NULL) locale_name = "th_TH";
#endif
	locale_name = "th_TH";

	return(locale_name);
}

int thai_create_path(char *path_name)
{
	struct stat path_stat;
	int ret;

	ret = stat(path_name, &path_stat);
	if (ret == -1) {
		DEBUG_printf("%s not exist\n", path_name);
		ret = mkdir(path_name, 0777);
		if (ret == -1) {
			return(-1);
		}
	}

	return(0);
}

void Get_ThaiOptions_From_Profile(TThaiOptions *pThaiOptions)
{
	FILE *ifile;
    	char file_name[256], line_buf[MAX_LINE_LEN]; 
	char *line_ptr, *key_ptr, *value_ptr;

	char *locale_name;

	pThaiOptions->isc_mode_id = 0xff;
	pThaiOptions->keyboard_id = 0xff;

	locale_name = get_locale_name();

	/* read profile from file to memory buffer  */ 
	sprintf(file_name, "%s/%s/%s/%s", getenv("HOME"), 
		USER_PROFILE_PATH, locale_name, USER_OPTION_FILE_NAME);
	DEBUG_printf("file name :%s\n",file_name);

	ifile = fopen(file_name, "r");
	if (! ifile) {
		fprintf(stderr, "Error: open file %s\n", file_name);
		return;
	}

	while(fgets(line_buf, MAX_LINE_LEN, ifile) != NULL) {
		line_ptr = trim_string(line_buf);

		/* If space line or comment line */
		if (*line_ptr == '\0' || *line_ptr == '#') continue;

		parse_line_for_pair(line_ptr, &key_ptr, &value_ptr);

		if (strcasecmp(key_ptr, THAIOPTION_ISC_MODE_STRING)) {
			pThaiOptions->isc_mode_id = atol(value_ptr);
		} else if (strcasecmp(key_ptr, THAIOPTION_KEYBOARD_TYPE_STRING)) {
			pThaiOptions->keyboard_id = atol(value_ptr);
		}
	}

	fclose(ifile);

	return;
}

void Save_ThaiOptions_To_Profile(TThaiOptions *pThaiOptions)
{
	FILE *ofile;
	char path_name[256], file_name[256];

	int  ret;
	char *locale_name;

	locale_name = get_locale_name();

	/* read profile from file to memory buffer  */ 

	/* Create Path $(HOME)/.Xlocale */
	sprintf(path_name, "%s/%s", getenv("HOME"), USER_PROFILE_PATH);
	DEBUG_printf("path_name: %s\n", path_name);
	ret = thai_create_path(path_name);
	if (ret == -1) {
		DEBUG_printf("can not create path %s\n", path_name);
		return;
	}

	/* Create Path $(HOME)/.Xlocale/<locale> */
	sprintf(path_name, "%s/%s/%s", getenv("HOME"), USER_PROFILE_PATH, locale_name);
	DEBUG_printf("path_name: %s\n", path_name);
	ret = thai_create_path(path_name);
	if (ret == -1) {
		DEBUG_printf("can not create path %s\n", path_name);
		return;
	}

	/* Create File $(HOME)/.Xlocale/<locale>/option.cfg */
	sprintf(file_name, "%s/%s", path_name, USER_OPTION_FILE_NAME);
	DEBUG_printf("file_name: %s\n", file_name);
	ofile = fopen(file_name, "wb");
	if (! ofile) {
		DEBUG_printf("unable open the file: %s\n", file_name);
		return;
	}

	fprintf(ofile, "%s:\t%d\n", THAIOPTION_ISC_MODE_STRING, pThaiOptions->isc_mode_id);
	fprintf(ofile, "%s:\t\t%d\n", THAIOPTION_KEYBOARD_TYPE_STRING, pThaiOptions->keyboard_id);

	fclose(ofile);
}
