/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

/* 
 * Copyright 1998 by Sun Microsystems, Inc., 901 San Antonio Road,
 * Palo Alto, California, 94303, U.S.A. All rights reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered
 * into with Sun.
 */
#include <stdio.h>

#include "hzinput.h"
#include "encode.h"

int  ime_SetOptions(IMECore, char *);
int  ime_SetValues(IMECore, IMEArgList, int);
int  ime_Init(IMECore);
int  ime_Open(IMECore, IMEBuffer);
int  ime_Filter(IMECore, IMEKey, IMEArgList, IMEBuffer);
void ime_Close(IMECore);

/* IF Method */
IMEMethodsRec ime_methods = {
	ime_SetOptions,
	ime_SetValues,
	ime_Init,
	ime_Open,
	ime_Filter,
	ime_Close,
	NULL,
	NULL,
	NULL
};

#define MAX_SESSION 512
int opened_session[MAX_SESSION];

/* Set options for codetable input method. */
int ime_SetOptions(IMECore core, char *options)
{
}

int ime_SetValues(IMECore core, IMEArgList arglist, int option_value)
{
	DEBUG_printf("ime_SetValues, option_value:%d\n", option_value);

	if (arglist == NULL) return(-1);

	arglist->args_num = 0;
	return(0);
}

/* return the Chinese name and encode status and status of codetable IME */
int ime_Init(IMECore core)
{
	int ret;

	DEBUG_printf("ime_Init ====\n");

	ret = newzy_open(0);
	if (ret == -1) return(-1);

	/* Return Information that needed by Input Method Manager */
	/* Such as Encode, Cname, Status */
	core->baseinfo.status = ENGINE_INITIATED;
	core->baseinfo.cname  = (char *)strdup("新注音");
	core->baseinfo.encode_id = ENCODE_UTF8;

	return(0);
}


/* Load the codetable file int memory */
int ime_Open(IMECore core, IMEBuffer ime_buffer)
{
	int             ret;

	DEBUG_printf("ime_Open ==== \n");

	ime_buffer->encode = core->baseinfo.encode_id;
	ime_buffer->return_status = 0;
	ime_buffer->preedit_len = 0;
	ime_buffer->commit_len  = 0;
	ime_buffer->lookup_num  = 0;
	ime_buffer->inputkey_len  = 0;
	ime_buffer->cur_lookup_pos = 0;

	if (ime_buffer->session_id > MAX_SESSION) 
		ime_buffer->session_id = 0;

	opened_session[ime_buffer->session_id] = 1;
	ret = newzy_open(ime_buffer->session_id);

	DEBUG_printf("newzy_open return :%d\n", ret);

	/* ret :  -1 or 0  */
	return(ret);
}

/* close IME, and free codetable pointers */
void ime_Close(IMECore core)
{
	int i;
	DEBUG_printf("ime_Close ==== \n");

	if (core->baseinfo.cname)
		free((char *)core->baseinfo.cname);

	for (i = 0; i < MAX_SESSION; i ++) 
		if(opened_session[i] == 1) newzy_close(i);
}

/* process key input event */
/* return value:  IME_NOT_USED_KEY:  if IME not use this key, return this key to systerm directly */
/*                IME_USED_KEY:      if IME has used this key */
int  ime_Filter(core, key_event, ime_args, ime_buffer)
IMECore core;
IMEKey key_event;
IMEArgList ime_args;
IMEBuffer ime_buffer;
{
	int 	ret;
	long    kcode, kstate;
	unsigned short kchar;

	DEBUG_printf("ime_Filter ==== \n");

	kcode = key_event->keyCode;
	kchar = key_event->keyChar;
	kstate = key_event->modifier;

	DEBUG_printf("Before Modify:keycode:0x%x, keychar:0x%x, keystatus:0x%x\n", kcode, kchar, kstate);
	modifyEvent(&kcode, &kchar, &kstate);
	DEBUG_printf("After Modify: keycode:0x%x, keychar:0x%x, keystatus:0x%x\n", kcode, kchar, kstate);
	ret = newzy_filter(kcode, kchar, kstate, ime_buffer);
	DEBUG_printf("ime_im_filter : return: %d\n", ret);
	return(ret);
}

