#ifndef HHENTRY_H
#define HHENTRY_H
#include <iconv.h>
#include "utfchar.h"

#define HASH_TABLE_NUMBER 256
#define IIIM_KO_LE_DIC "IIIM-KO-LE-DIC"

typedef struct _HH {
  unsigned char *utf_hangul;
  unsigned char *utf_hanja;
} HH;



typedef struct _HHItem {
  unsigned char *hangul;
  int n_hanja;
  unsigned char **hanja_list;
} HHItem;
#if 0
} HHItem, *HHEntry;
#endif

typedef struct _HHList {
  int n_count;
  HHItem **list;
} HHList;

  

void
hh_free (HH *);
HH *
hh_new ();



HHItem *hhitem_new ();
HHItem *hhitem_new_with_data (HH *);
void hhitem_init (HHItem * hhentry);
HHItem *hhitem_add_hanja (HHItem * hhentry, unsigned char *utf_hanja);
void hhlist_init (HHList *hhlist);
HHItem *hhlist_add_hhitem (HHList *hhlist, HHItem * hhitem);
HHItem *hhlist_add_hh (HHList *hhlist, HH *item);
HHItem *hhlist_search_hhitem (HHList *hhlist, HH *hh);
void hhlist_dump_content (HHList *hhlist, FILE *fp);
void hhitem_read_from_file (FILE *fp, HHItem * entry_return);
int hash (UTFCHAR *string);
HH *process_hangul_hanja_pair (iconv_t cd, char *str_hangul, char *str_hanja);

#endif /* HHENTRY_H */
