/*
 * Copyright (c) 1999 Sun Microsystems, Inc.
 * Copyright (c) 1999 Nihon Sun Microsystems K.K.
 * All rights reserved.
 */

/*
 * "$Id: conf_info.c,v 1.1.1.1 2000/10/29 16:50:58 himi Exp $"
 */

#pragma ident	"@(#)conf_info.c 1.1	99/04/23 SMI"


#include "config.h"

#include <stddef.h>
#include <stdio.h>

#include "csconv.h"
#include "csc_conf_info.h"

#include "trace_message.h"

main(int argc, char ** argv)
{
	csc_conf_file_t *	conf_info;
	csc_conf_str_t		conf_str[10];
	int			num;
	int			i;
	int			logical_line_number;

	TRACE_MESSAGE_INIT("CSC_TRACE");

	if (argc <= 1) {
		fprintf(stderr, "Usage: %s conf_file\n", *(argv + 0));
		exit(1);
	}

	conf_info = csc_conf_open(*(argv + 1), 0, NULL, 0);
	if (NULL == conf_info) {
		perror("csc_conf_open");
		exit(1);
	}

	logical_line_number = 0;
	while (0 < (num = csc_conf_read(conf_info, conf_str, 10))) {
		printf("%2d ", logical_line_number);
		for (i = 0; i < num; i++) {
			if (0 != i) {
				putchar(' ');
			}

			printf("%d:%.*s", i, conf_str[i].len, conf_str[i].ptr);
		}
		putchar('\n');
		logical_line_number += 1;
	}

	csc_conf_close(conf_info);

	exit(0);
}
