/* $Id: im-lookup-choice-draw.c,v 1.1.1.1 2002/08/31 04:18:06 himi Exp $ */


#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


IIIMP_message *
iiimp_lookup_choice_draw_new(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    int			first,
    int			last,
    int			current,
    IIIMP_text *	choice,
    IIIMP_text *	index_label,
    IIIMP_text *	title)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_LOOKUP_CHOICE_DRAW;
    m->im_id = im_id;
    m->ic_id = ic_id;
    m->v.lookup_choice_draw.first = first;
    m->v.lookup_choice_draw.last = last;
    m->v.lookup_choice_draw.current = current;
    m->v.lookup_choice_draw.choice = choice;
    m->v.lookup_choice_draw.index_label = index_label;
    m->v.lookup_choice_draw.title = title;
    return m;
}


void
iiimp_lookup_choice_draw_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    if (NULL == m) return;
    iiimp_text_list_delete(data_s, m->v.lookup_choice_draw.choice);
    iiimp_text_list_delete(data_s, m->v.lookup_choice_draw.index_label);
    iiimp_text_delete(data_s, m->v.lookup_choice_draw.title);
    free(m);
    return;
}


uchar_t *
iiimp_lookup_choice_draw_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    int			first,
    int			last,
    int			current,
    IIIMP_text *	choice,
    IIIMP_text *	index_label,
    IIIMP_text *	title,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;
    size_t		choice_list_nbyte;
    size_t		index_label_list_nbyte;
    IIIMP_text *	text;

    nbyte = 0;
    nbyte += 2;				/* input method id */
    nbyte += 2;				/* input context id */
    nbyte += 4;				/* index of first candidate */
    nbyte += 4;				/* index of last candidate */
    nbyte += 4;				/* index of current candidate */
    nbyte += 4;				/* byte length of choice list */
    choice_list_nbyte = 0;
    for (text = choice; NULL != text; text = text->next) {
	choice_list_nbyte += text->nbyte;
    }
    nbyte += choice_list_nbyte;		/* choice list */
    nbyte += 4;	/* byte length of index label list */
    index_label_list_nbyte = 0;
    for (text = index_label; NULL != text; text = text->next) {
	index_label_list_nbyte += text->nbyte;
    }
    nbyte += index_label_list_nbyte;	/* index label list */
    if (NULL == title) {
	nbyte += (4 + 4);
    } else {
	nbyte += title->nbyte;
    }

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_LOOKUP_CHOICE_DRAW, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(ic_id, rest, p, data_s->byte_swap);
    PUTU32(first, rest, p, data_s->byte_swap);
    PUTU32(last, rest, p, data_s->byte_swap);
    PUTU32(current, rest, p, data_s->byte_swap);
    PUTU32(choice_list_nbyte, rest, p, data_s->byte_swap);
    iiimp_text_list_pack(data_s, choice, &rest, &p);
    PUTU32(index_label_list_nbyte, rest, p, data_s->byte_swap);
    iiimp_text_list_pack(data_s, index_label, &rest, &p);
    iiimp_text_pack(data_s, title, &rest, &p);

    return buf;
}


IIIMP_message *
iiimp_lookup_choice_draw_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *			m;
    IIIMP_lookup_choice_draw_v *	v;
    size_t				rest;
    const uchar_t *			p;
    int					len;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 4 + 4 + 4 + 4)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.lookup_choice_draw);

    m->opcode = opcode;
    v->choice = NULL;
    v->index_label = NULL;
    v->title = NULL;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    GETU16(m->ic_id, rest, p, data_s->byte_swap);

    GET32(v->first, rest, p, data_s->byte_swap);
    GET32(v->last, rest, p, data_s->byte_swap);
    GET32(v->current, rest, p, data_s->byte_swap);

    GET32(len, rest, p, data_s->byte_swap);
    if ((len < 0) || (rest < len)) {
	free(m);
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    if (0 < len) {
	v->choice = iiimp_text_list_unpack(data_s, &rest, &p, len);
	if ((NULL == v->choice) || (rest < 4)) {
	    iiimp_lookup_choice_draw_delete(data_s, m);
	    return NULL;
	}
    }

    GET32(len, rest, p, data_s->byte_swap);
    if ((len < 0) || (rest < len)) {
	iiimp_lookup_choice_draw_delete(data_s, m);
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    if (0 < len) {
	v->index_label = iiimp_text_list_unpack(data_s, &rest, &p, len);
	if ((NULL == v->index_label) || (rest < 4)) {
	    iiimp_lookup_choice_draw_delete(data_s, m);
	    return NULL;
	}
    }

    if (0 < len) {
	v->title = iiimp_text_unpack(data_s, &rest, &p, rest);
	if (NULL == v->title) {
	    iiimp_lookup_choice_draw_delete(data_s, m);
	    return NULL;
	}
    }

    *nbyte = rest;
    *ptr = p;

    return m;
}


void
iiimp_lookup_choice_draw_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, m->ic_id);

    (void)fputc('\t', data_s->print_fp);
    (void)fprintf(data_s->print_fp, "first=%d ", m->v.lookup_choice_draw.first);
    (void)fprintf(data_s->print_fp, "last=%d ", m->v.lookup_choice_draw.last);
    (void)fprintf(data_s->print_fp, "current=%d ",
		  m->v.lookup_choice_draw.current);
    (void)fprintf(data_s->print_fp, "\n\tchoice=\n");
    iiimp_text_list_print(data_s, m->v.lookup_choice_draw.choice);
    (void)fprintf(data_s->print_fp, "\tlabel=\n");
    iiimp_text_list_print(data_s, m->v.lookup_choice_draw.index_label);
    (void)fprintf(data_s->print_fp, "\ttitle=\n");
    iiimp_text_print(data_s, m->v.lookup_choice_draw.title);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
