/* 
 * ImageWindow.m created by phr on 2000-10-17 17:08:03 +0000
 *
 * Project ImageViewer
 *
 * Created with ProjectCenter - http://www.gnustep.org
 *
 * $Id: ImageWindow.m,v 1.11 2003/06/29 17:28:34 probert Exp $
 */

#include "ImageWindow.h"
#include "ImageCache.h"
#include "Inspector.h"

@implementation ImageWindow

- (id)initWithContentsOfFile:(NSString *)path
{
  NSAssert(path,@"No path specified!");

  if ((self = [super init])) {
    NSRect frame = {{0,0}, {300, 300}};
    int m = (NSTitledWindowMask |  NSClosableWindowMask | 
	     NSMiniaturizableWindowMask | NSResizableWindowMask);
    NSScrollView *scrollView = nil;
    NSImageView *view = nil; 
    NSImage *image;
    NSArray *array;

    attr = [[NSFileManager defaultManager] fileAttributesAtPath:path 
                                                   traverseLink:NO];
    RETAIN(attr);

    window = [[NSWindow alloc] initWithContentRect:frame 
			       styleMask:m			       
			       backing: NSBackingStoreRetained 
			       defer:YES];
    [window setReleasedWhenClosed:YES];
    [window setDelegate:self];

    imagePath = [path copy];

    if (!(image = [[NSImage alloc] initWithContentsOfFile:path])) {
      RELEASE(window);
      return nil;
    }

    [image setBackgroundColor: [NSColor darkGrayColor]];
    //    array = [NSImageRep imageRepsWithContentsOfFile:path];
    array = [image representations];
    reps  = [array count];
    rep   = [array objectAtIndex:0];

    if( rep == nil ) {
      RELEASE(window);
      return nil;
    }
    [rep retain];

    imageSize  = [image size];
    frame.size = [image size];

    view  = [[NSImageView alloc] initWithFrame:frame];
    [view setImage:image];
    RELEASE(image);

    scrollView = [[NSScrollView alloc] initWithFrame:frame];
    [scrollView setHasVerticalScroller:YES];
    [scrollView setHasHorizontalScroller:YES];
    [scrollView setDocumentView:view];
    RELEASE(view);
    
    frame.size.width += 25;
    frame.size.height += 55;
    
    [window setFrame:frame display:YES];
    [window setMaxSize:frame.size];
    [window setContentView:scrollView];
    [window setTitleWithRepresentedFilename:path]; 
    [window setReleasedWhenClosed:YES];

    [window center];
    [window orderFrontRegardless];
    [window makeKeyWindow];
    [window display];

    RELEASE(scrollView);
  }
  return self;
}

- (void)dealloc
{
  RELEASE(window);
  RELEASE(imagePath);
  RELEASE(attr);
  RELEASE(rep);

  [super dealloc];
}

- (id)delegate
{
  return delegate;
}

- (void)setDelegate:(id)aDelegate
{
  delegate = aDelegate;
}

- (void)windowWillClose:(NSNotification *)notif
{
  if ([[notif object] isEqual:window]) {
    if (delegate && 
	[delegate respondsToSelector:@selector(imageWindowWillClose:)]) {
      [delegate imageWindowWillClose:self];
      [window setDelegate: nil];
      window = nil;
    }
  }
}

- (void)windowDidBecomeKey:(NSNotification *)aNotification
{
    if( [[aNotification object] isEqual:window] ) {
        [[Inspector sharedInspector] imageWindowDidBecomeActive:self];
    }
}

- (NSString *)path
{
    return imagePath;
}

- (NSString *)imagePath
{
    return [imagePath stringByDeletingLastPathComponent];
}

- (NSString *)imageName
{
    return [imagePath lastPathComponent];
}

- (NSString *)imageType
{
    return [imagePath pathExtension];
}

- (NSString *)imageSize
{
    int bytes = [[attr objectForKey:@"NSFileSize"] intValue];

    return [NSString stringWithFormat:@"%d Bytes",bytes];
}

- (NSString *)imageFileModificationDate
{
    NSDate *date = [attr objectForKey:@"NSFileModificationDate"];

    return [date descriptionWithCalendarFormat:@"%Y-%m-%d %H:%M:%S" 
                                      timeZone:nil 
                                        locale:nil];
}

- (NSString *)imageFilePermissions
{
    NSNumber *permissions = [attr objectForKey:@"NSFilePosixPermissions"];

    return [permissions description];
}

- (NSString *)imageFileOwner
{
    NSString *owner = [attr objectForKey:@"NSFileOwnerAccountName"];

    return owner;
}

- (NSString *)imageResolution
{
    return [NSString stringWithFormat:@"%.1f x %.1f",imageSize.width,imageSize.height];
}

- (NSString *)bitsPerSample
{
    return [NSString stringWithFormat:@"%d",[rep bitsPerSample]];
}

- (NSString *)colorSpaceName
{
    return [rep colorSpaceName];
}

- (NSString *)hasAlpha
{
    return [NSString stringWithFormat:@"%@",[rep hasAlpha]?@"Yes":@"No"];
}

- (NSString *)imageReps
{
    return [NSString stringWithFormat:@"%d",reps];
}

@end

