<?php
/*
 * $Horde: imp/lib/api.php,v 1.12.2.14 2004/04/24 13:33:58 jan Exp $
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/*
 * IMP external API interface.
 *
 * This file defines IMP's external API interface. Other applications
 * can interact with IMP through this API.
 */

// Find the base file paths for IMP
@define('IMP_BASE', dirname(__FILE__) . '/..');

// Include the necessary libraries.
require_once IMP_BASE . '/lib/base.php';

function impComposePopup($options)
{
    $GLOBALS['registry']->includeFiles('imp', 'mail/composePopup');
    $args = 'popup=1';
    foreach ($options as $arg => $value) {
        $args .= !empty($value) ? '&' . $arg . '=' . urlencode($value) : '';
    }
    return "<script language='JavaScript' type='text/javascript'>open_compose_win('" . addslashes($args) . "');</script>";
}

function impSummary()
{
    global $prefs, $registry;

    ob_start();
    $registry->includeFiles('imp', 'mail/compose');
    $html = ob_get_contents();
    ob_end_clean();

    $html .= '<table border="0" cellpadding="2" cellspacing="0" width="100%"><tr><td class="header">';
    $html .= Horde::link(Horde::url($registry->getInitialPage()), $registry->getParam('name'), 'header') . $registry->getParam('name') . '</a> - ';
    $html .= Horde::link($registry->link('mail/compose'), _("Compose"), 'smallheader') . Horde::img('compose.gif', 'alt="' . _("Compose") . '"') . _("Compose") . '</a>';
    $html .= '</td></tr><tr><td class="text"><table border="0" cellpadding="0" cellspacing="0">';

    if (IMP::authenticate(OP_HALFOPEN, true) === true) {
        $folders = @unserialize($prefs->getValue('nav_poll'));
        if (!isset($folders) || !is_array($folders)) {
            $folders = array('INBOX' => 1);
        }
        ksort($folders);

        $serverstring = IMP::serverString();
        $newmsgs = array();
        foreach ($folders as $folder => $true) {
            if ($folder == 'INBOX' || !strstr($GLOBALS['imp']['protocol'], 'pop3')) {
                /* Filter on refresh, if requested. */
                if ($prefs->getValue('filter_on_refresh')) {
                    IMP::filterMailbox();
                }

                $sts = imap_status($GLOBALS['imp']['stream'], $serverstring . $folder, SA_UNSEEN | SA_RECENT);
                if ($sts) {
                    if (!empty($sts->recent)) {
                        $newmsgs[$folder] = $sts->recent;
                    }
                    $html .= '<tr><td class="text">';
                    if (!empty($sts->unseen)) {
                        $html .= '<b>';
                    }
                    $html .= Horde::link(Horde::applicationUrl('mailbox.php?newmail_popup=no&mailbox=' . urlencode($folder)), IMP::displayFolder($folder)) . IMP::displayFolder($folder) . '</a>';
                    if (!empty($sts->unseen)) {
                        $html .= '</b>';
                    }
                    $html .= '</td><td class="text">&nbsp;&nbsp;&nbsp;</td><td class="text">';
                    $html .= !empty($sts->unseen) ? '<b>' . $sts->unseen . '</b>' : '0';
                    $html .= '</td></tr>';
                }
            }
        }
    } else {
        $html .= '<tr><td class="text">' . Horde::link(Horde::applicationUrl('index.php'), sprintf(_("Log in to %s"), $registry->applications['imp']['name'])) . sprintf(_("Log in to %s"), $registry->applications['imp']['name']) . '</a></td></tr>';
    }

    $html .= '</table></td></tr></table>';

    /* Check to see if user wants new mail notification */
    if ($prefs->getValue('nav_popup')) {
        $alert = '';
        $count = 0;
        foreach ($newmsgs as $mb => $nm) {
            $count++;
            $mailbox_message = $mb;
            $alert .= IMP::displayFolder($mailbox_message) . ($nm > 1 ? sprintf(_(" - %s new messages"), $nm) : _(" - 1 new message")) . '\n';
        }
        if (!empty($alert)) {
            ob_start();
            if ($count == 1) {
                include IMP_TEMPLATES . '/folders/confirm.inc';
            } else {
                include IMP_TEMPLATES . '/folders/alert.inc';
            }
            $html .= ob_get_contents();
            ob_end_clean();
        }
    }

    // catch error messages from c-client
    imap_errors();

    return $html;
}

?>
