/****************************************************************************
 *                         LogDestination.h
 *
 * Author: Matthew Ballance
 * Desc:   Describes the destination for log output. This is just a base 
 *         class - other classes actually implement the _real_ destinations
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_LOG_DESTINATION_H
#define INCLUDED_LOG_DESTINATION_H
#include "vector.h"
#include "LogMgr.h"
#include "ivi_String.h"

class LogInstance;
class LogDestination {
    public:
        LogDestination();

        inline LogMgr::DebugLevel getDebugLevel() { return debugLevel; }
        virtual void write(char *msg);

        void setLogLevel(LogMgr::DebugLevel lev);
        void addInstance(LogInstance *inst);

        void enter();
        void leave();

    private:
        Vector<LogInstance>    *instList;
        LogMgr::DebugLevel      debugLevel;
        String                  d_indent;
};

#endif /* INCLUDED_LOG_DESTINATION_H */


