/****************************************************************************
 *                           PsTextLayout.cc
 *
 * Author: Matthew Ballance
 * Desc:   Implements a quick-and-dirty text layout for the Postscript
 *         pixmap
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "PsTextLayout.h"
#include "FileAccObj.h"
#include <string.h>

/********************************************************************
 * PsTextLayout()
 ********************************************************************/
PsTextLayout::PsTextLayout(
        Tk_Font font, const char *str, Int32 len, Int32 wraplen,
        Tk_Justify justify, Int32 flags, Int32 *width, Int32 *height)
{
    Uint32 str_len = (len>0)?len:strlen(str);

    /**** We actually still call the Tk text layout to get size info ****/
    d_tkLayout = Tk_ComputeTextLayout(font, str, len, wraplen,
            justify, flags, width, height);
    d_width  = *width;
    d_height = *height;

    d_string = new char[str_len+1];
    strcpy(d_string, str);
}

/********************************************************************
 * PsTextLayout()
 ********************************************************************/
PsTextLayout::~PsTextLayout()
{
    delete [] d_string;
    Tk_FreeTextLayout(d_tkLayout);
}

/********************************************************************
 * DrawLayout()
 ********************************************************************/
void PsTextLayout::DrawLayout(FileAccObj *f, 
        Uint32 x, Uint32 y, Int32 start, Int32 end)
{
    f->print("(%s) show\n", d_string);
}


