/****************************************************************************
 *                       RemoteAppSrvConnection.cc
 *
 * Author: Matthew Ballance
 * Desc:   
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "RemoteAppSrvConnection.h"
#include "RemoteAppConnectionListener.h"
#include "IviRemoteAppIdx.h"
#include "IviRemoteProc.h"
#include <tcl.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>

class IntChListener : public RemoteAppConnectionListener {
    public:
        IntChListener(RemoteAppSrvConnection *srvc) :
            RemoteAppConnectionListener(IVI_CMD_CH_IDX_INTERNAL)
        {
            d_srvc = srvc;
        }

        virtual void Receive(Uint32 idx, Uint32 len, Uchar *data)
        {
            Uint32 cmd, pid, bidx=0;

            cmd = RemoteAppConnection::ReadUint32(data, bidx);
            pid = RemoteAppConnection::ReadUint32(data, bidx);

            d_srvc->HandleConnect(pid);
        }

    private:
        RemoteAppSrvConnection *d_srvc;
};

/********************************************************************
 * RemoteAppSrvConnection()
 ********************************************************************/
RemoteAppSrvConnection::RemoteAppSrvConnection(
        Tcl_Interp      *interp, 
        Tcl_Channel      channel)
{
    d_channel = channel;

    Tcl_CreateChannelHandler(d_channel, TCL_READABLE|TCL_EXCEPTION,
            &RemoteAppConnection::EventProc, this);

    d_listener = new IntChListener(this);
    AddListener(d_listener);

    /**** Now, wait for a message... ****/
    do {
        Poll(REMOTE_POLL_FOREVER);
    } while (!d_connected);
}

/********************************************************************
 * ~RemoteAppSrvConnection()
 ********************************************************************/
RemoteAppSrvConnection::~RemoteAppSrvConnection()
{
    Tcl_DeleteChannelHandler(d_channel, 
            &RemoteAppConnection::EventProc, this);
}

/********************************************************************
 * HandleDisconnect()
 ********************************************************************/
void RemoteAppSrvConnection::HandleDisconnect()
{
    Tcl_DeleteChannelHandler(d_channel, &RemoteAppConnection::EventProc, this);
}

/********************************************************************
 * HandleConnect()
 ********************************************************************/
void RemoteAppSrvConnection::HandleConnect(Uint32 pid)
{
    IviRemoteProc *proc;

    proc = IviRemoteProc::findProc(pid);

    if (proc) {
        proc->setCommConnect(this);
    } else {
        fprintf(stderr, "ERROR: received connection from non-IVI process\n");
    }

    d_connected = true;
}

/********************************************************************
 * Connect()
 *
 * Complete connection to remote proc. 
 ********************************************************************/
int RemoteAppSrvConnection::Connect()
{
    Uchar   buf[4];
    Uint32  idx = 0;

    WriteUint32(IVI_INT_CMD_CONNECT_ACK, buf, idx);

    Send(IVI_CMD_CH_IDX_INTERNAL, 4, buf);

    return 0;
}


