/****************************************************************************
 *                           ivi_common_init.c
 *
 * Author: Matthew Ballance
 * Desc:   Common point from which the modules in the common library are
 *         initialized
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include <tcl.h>


#ifdef __cplusplus 
extern "C" {
#endif
extern int LogMgr_Init(Tcl_Interp *interp);
extern int WidgetMgr_Init(Tcl_Interp *interp);
extern int TclBitVector_Init(Tcl_Interp *interp);
extern int SdbReader_Init(Tcl_Interp *interp);
extern int SDBMgr_Init(Tcl_Interp *interp);
extern int CallbackMgr_Init(Tcl_Interp *);
extern int DesignDB_Init(Tcl_Interp *interp);
extern int DFIOMgr_Init(Tcl_Interp *interp);
extern int SimMgr_Init(Tcl_Interp *interp);
extern int ConfigDB_Init(Tcl_Interp *interp);
extern int TclVpi_Init(Tcl_Interp *interp);
extern int DialogMgr_Init(Tcl_Interp *interp);
extern int MenuMgr_Init(Tcl_Interp *interp);
extern int StimulusMgr_Init(Tcl_Interp *interp);
extern int VExpr_Init(Tcl_Interp *interp);
extern int XObjWidgetBase_Init(Tcl_Interp *interp);
extern int PsPixmapObj_Init(Tcl_Interp *interp);
extern int RemoteAppServer_Init(Tcl_Interp *interp);
extern int RemoteAppClientConnection_Init(Tcl_Interp *interp);
extern int TclChannelObj_Init(Tcl_Interp *interp);
extern int IviRemoteProc_Init(Tcl_Interp *interp);


int IviCommon_Init(Tcl_Interp *interp)
{
    int ret;
    char buf[1024];

#if 0
    if (!Tcl_InitStubs(interp, "8.1", 0)) {
        Tcl_AppendResult(interp, "stubs init failed...", 0);
        return TCL_ERROR;
    }

    if (!Tk_InitStubs(interp, "8.1", 0)) {
        Tcl_AppendResult(interp, "stubs init failed...", 0);
        return TCL_ERROR;
    }
#endif

    IviRemoteProc_Init(interp);
    TclChannelObj_Init(interp);
    LogMgr_Init(interp);
    WidgetMgr_Init(interp);
    CallbackMgr_Init(interp);
    DialogMgr_Init(interp);
    MenuMgr_Init(interp);
    ConfigDB_Init(interp);
    DFIOMgr_Init(interp);
    SimMgr_Init(interp);
    TclBitVector_Init(interp);
    SdbReader_Init(interp);
    SDBMgr_Init(interp);
    DesignDB_Init(interp);
    TclVpi_Init(interp);
    StimulusMgr_Init(interp);
    VExpr_Init(interp);
    XObjWidgetBase_Init(interp);
    PsPixmapObj_Init(interp);
    RemoteAppServer_Init(interp);
    /*
    RemoteAppClientConnection_Init(interp); 
     */

    /*
    strcpy(buf, 
            "lappend auto_path [file join $env(IVI_HOME) modules ivi_common]");
     */
    strcpy(buf, "set dir [file join $env(IVI_HOME) modules ivi_common]");
    ret = Tcl_EvalEx(interp, buf, -1, TCL_EVAL_GLOBAL);

    strcpy(buf,
          "source [file join $env(IVI_HOME) modules ivi_common pkgIndex.tcl]");
    ret = Tcl_EvalEx(interp, buf, -1, TCL_EVAL_GLOBAL);
    if (ret != TCL_OK) {
        fprintf(stderr, "Initializing IviCommon failed (1)!!\n");
        fprintf(stderr, "\tCommand was: %s\n", buf);
        fprintf(stderr, "\tResult was: %s\n", Tcl_GetStringResult(interp));
        return ret;
    }

#if 0
    strcpy(buf, "package require ivi_common");
    ret = Tcl_EvalEx(interp, buf, -1, TCL_EVAL_GLOBAL);
    if (ret != TCL_OK) {
        fprintf(stderr, "Initializing IviCommon failed (2)!!\n");
        fprintf(stderr, "\tCommand was: %s\n", buf);
        fprintf(stderr, "\tResult was: %s\n", Tcl_GetStringResult(interp));
        return ret;
    }
#endif

    strcpy(buf, "ivi_common_Init");
    ret = Tcl_EvalEx(interp, buf, -1, TCL_EVAL_GLOBAL);
    if (ret != TCL_OK) {
        fprintf(stderr, "Initializing IviCommon failed (3)!!\n");
        fprintf(stderr, "\tCommand was: %s\n", buf);
        fprintf(stderr, "\tResult was: %s\n", Tcl_GetStringResult(interp));
        return ret;
    }

    return TCL_OK;
}

int IviCommon_RemoteInit(Tcl_Interp *interp)
{
    LogMgr_Init(interp);
    WidgetMgr_Init(interp);
    CallbackMgr_Init(interp);
    ConfigDB_Init(interp);
    DFIOMgr_Init(interp);
    SimMgr_Init(interp);
    SdbReader_Init(interp);
    SDBMgr_Init(interp);
    DesignDB_Init(interp);
    StimulusMgr_Init(interp);

    return TCL_OK;
}

#ifdef __cplusplus
};
#endif



