#****************************************************************************
#*                             IviConfig.tcl
#*
#*
#* Author: Matthew Ballance
#* Desc:   Implements the ivi commands for configuration...
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#****************************************************************************

package provide ivi_common "1.0"

namespace eval IviConfig {
    namespace export IviConfig FinishInit current load
    variable         cdb
}


#***************************************************************
#* IviConfig()
#***************************************************************
proc IviConfig::IviConfig args {
    variable cdb
    global   IVI_HOME
    global   env

    set IVI_HOME $env(IVI_HOME)

    set cdb [config_db -global ivi_config_db]

    #**** Now, try to load up the config files
    set system [file join $IVI_HOME etc system.conf]
    if {[file exists $system]} {
        if {[catch {$cdb load $system -level system} res]} {
            puts "WARNING :: error when loading \"$system\""
            puts "    $res"
        } else {
            puts "NOTE :: Loaded config  \"system.conf\""
        }
    }
}

#***************************************************************
#*                         FinishInit
#*
#* Complete the initialization of the config_db. This is done
#* after modules have loaded, so that the user's config
#* overrides will be recognized...
#***************************************************************
proc IviConfig::FinishInit args {
    variable  cdb
    global    IVI_HOME

    #**** Try to load the site config...
    set site [file join $IVI_HOME etc site.conf]
    if {[file exists $site]} {
        if {[catch {$cdb load $site -level system} res]} {
            puts "WARNING :: error when loading \"$site\""
            puts "    $res"
        } else {
            puts "NOTE :: Loaded config  \"site.conf\""
        }
    }

    #**** Try to load the site config...
    set home [file join ~ .ivi ivi.conf]
    if {[file exists $home]} {
        if {[catch {$cdb load $home -level user} res]} {
            puts "WARNING :: error when loading \"$home\""
            puts "    $res"
        } else {
            puts "NOTE :: Loaded config  \"$home\""
        }
    }
}

#***************************************************************
#* current
#***************************************************************
proc IviConfig::current args {
    variable cdb

    eval $cdb current $args
}

#***************************************************************
#* current
#***************************************************************
proc IviConfig::get args {
    variable cdb

    eval $cdb current $args
}

#***************************************************************
#* section_names
#***************************************************************
proc IviConfig::section_names args {
    variable cdb

    eval $cdb section_names $args
}

#***************************************************************
#* load
#***************************************************************
proc IviConfig::load args {
    variable cdb

    eval $cdb load $args
}

#***************************************************************
#* write
#***************************************************************
proc IviConfig::write args {
    variable cdb
    eval $cdb write $args
}

