#****************************************************************************
#*                          scroll_container.tcl
#*
#* Author: Matthew Ballance
#* Desc:   Implements a simple scrollbar container...
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#****************************************************************************

namespace eval ScrollContainer {

    proc ::ScrollContainer { path args } { 
        return [eval ScrollContainer::ScrollContainer $path $args] 
    }
}


#********************************************************************
#* ScrollContainer
#*
#*  --------------------
#*  |------------------|
#*  ||                ||
#*  ||                ||
#*  ||                ||
#*  ||                ||
#*  |------------------|
#*  |                  |
#*  --------------------
#********************************************************************
proc ScrollContainer::ScrollContainer {path args} {

    set path [frame $path]

    rename $path ::$path:cmd
    proc ::$path { cmd args } \
        "return \[eval ScrollContainer::cmd $path \$cmd \$args\]"
    array set $path {_dummy _dummy}
    upvar #0 $path data

    set data(w:top_frame) [frame $path.top_frame]
    set data(w:bottom_frame) [frame $path.bottom_frame]

    set data(w:frame)     [frame $data(w:top_frame).frame]
    set data(w:vsb)       [scrollbar $data(w:top_frame).vsb \
         -orient vertical]

    set data(w:hsb)       [scrollbar $data(w:bottom_frame).hsb \
        -orient horizontal]
    set data(w:pad)       [frame $data(w:bottom_frame).pad]

    pack $data(w:bottom_frame) -side bottom -fill x
    pack $data(w:pad) -side right -fill x
    pack $data(w:hsb) -side left -fill x -expand yes

    pack $data(w:top_frame) -side top -expand yes -fill both
    pack $data(w:vsb) -side right -fill y
    pack $data(w:frame) -side right -expand yes -fill both

    bind $data(w:vsb) <Configure> "ScrollContainer::ConfigCB $path"

    return $path
}

#********************************************************************
#* cmd
#********************************************************************
proc ScrollContainer::cmd {path args} {
    upvar #0 $path data

    switch [lindex $args 0] {

        subwidget {
            return [BaseClass::subwidget $path [lindex $args 1]]
        }

        default {
            error "unknown cmd [lindex $args 0]"
        }
    }
}

#********************************************************************
#* ConfigCB
#********************************************************************
proc ScrollContainer::ConfigCB {path} {
    upvar #0 $path data

    set width [winfo width $data(w:vsb)]
    $data(w:pad) configure -width $width
}


