##############################################################################
#*                              ivi_cmds.tcl
#*  Author: Matthew Ballance
#*  Desc:   Implements the cmd-line ivi commands. These commands are also
#*          Available in the GUI (of course)
#*
#*
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#*
##############################################################################

#********************************************************************
#* put
#********************************************************************
proc put args {
    set smgr ::StimMgr.sim

    set cmd [lindex $args 0]
    switch [lindex $args 0] {
        value {
            eval $smgr put_value [lrange $args 1 end]
        }

        trace {
            eval $smgr put_trace [lrange $args 1 end]
        }

        default {
            error "unknown put sub-cmd $cmd"
        }
    }
}

#********************************************************************
#* put_trace
#*
#* put_trace <sdb_name> <sdb_trace> <sim_sig>
#********************************************************************
proc put_trace args {
    set smgr ::StimMgr.sim

    eval $smgr put_trace $args
}

#********************************************************************
#* get_value
#********************************************************************
proc get_value args {
    eval get value $args
}

#********************************************************************
#* get
#********************************************************************
proc get args {
    set smgr ::StimMgr.sim

    switch [lindex $args 0] {
        value {
            eval $smgr get [lrange $args 1 end]
        }

        default {
            error "no \"get\" sub-command \"[lindex $args 0]\""
        }
    }
}

#********************************************************************
#* create_seq
#********************************************************************
proc create_seq args {
    set smgr ::StimMgr.sim

    eval $smgr create_seq $args
}

#####################################################################
#* ivi_puts2
#####################################################################
proc ivi_puts2 args {
    global ivi_global

    set msg ""
    set options ""
    if {[llength $args] > 0} {

    }

    if {[IviConfig::current App.CmdLine] == 1} {
        puts $args
    } else {
        gui_puts [lindex $args 0]
    }

#    if {$ivi_global(logfile_fp) != ""} {
#        puts $ivi_global(logfile_fp) [lindex $args 0]
#        flush $ivi_global(logfile_fp)
#    }
}


#####################################################################
#* ivi_do
#####################################################################
proc ivi_do args {
    ivi_puts "do $args"
    foreach arg $args {
        if {[file exists $arg]} {
            ivi_puts "Sourcing $arg"
            if {[catch {uplevel #0 eval do $arg} err] != 0} {
                error $err
            }
        } else {
            uplevel #0 eval $arg
        }
    }
}

#####################################################################
#* do
#####################################################################
proc do2 args {
    eval ivi_do $args
}

#####################################################################
#* unknown
#####################################################################
proc unknown2 args {
   set cmd [auto_execok [lindex $args 0]]

   if {$cmd != 0} {
       if {[llength $args] > 1} {
           eval exec -- $cmd [lrange $args 1 end]
       } else {
           exec $cmd 
       }
   } else {
       error "Unknown command [lindex $args 0]"
   }
}

#####################################################################
# mk_bitmap
#####################################################################
proc make_bitmap {name, w, h, data} {
    set res "#define ${name}_width $w\n"
    set res "${res}#define ${name}_height $h\n"
    set res "${res}static unsigned char ${name}_bits\[\] = \{"

    for {set i 0} {$i < [expr [llength $data] - 1]} {incr i} {
        set res "$res $byte,"
    }
    set res "$res [lindex $data end]\};"

    return $res
}

#####################################################################
# init_base_widgets()
# This procedure is invoked by the IVI core to 
# setup the minimal widgets.
#####################################################################
proc init_base_widgets args {
    global WidgetTypes

    uplevel #0 {
                set ivi_global(sim_run_increment) 1000
                set signal_windows(base) 0
                set ivi_global(button_pady) 2
                set ivi_global(button_padx) 4
                set IVI_BREAK_REQUEST 0
                set ivi_global(logfile_fp)  ""

                stimulus_mgr ::StimMgr.sim
                set ivi_global(StimMgr) ::StimMgr.sim

                if {[IviConfig::current App.LogFile] != ""} {
                    puts \
                      "Opening logfile - \"[IviConfig::current App.LogFile]\""
                    set ivi_global(logfile_fp) \
                        [open [IviConfig::current App.LogFile] "w"]
                }
            }

    init_wave_cmds
}




