/****************************************************************************
 *                              ShmDFIOFile.h
 *
 * Author: Matthew Ballance
 * Desc:   R/W interface to the shared-mem file.
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_SHM_DFIO_FILE_H
#define INCLUDED_SHM_DFIO_FILE_H
#include "types.h"
#ifdef __MINGW32__
#include <windows.h>
#endif
#include "ShmDFIOHeader.h"

class ShmDFIOFile {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * ShmDFIOFile()
         ************************************************************/
        ShmDFIOFile(const char *filename, bool read);

        /************************************************************
         * ~ShmDFIOFile()
         ************************************************************/
        ~ShmDFIOFile();

        /************************************************************
         * map()
         ************************************************************/
        int map(Uint32 maplen);

        /************************************************************
         * unmap()
         ************************************************************/
        int unmap();

        /************************************************************
         * getMapBase()
         ************************************************************/
        char *getMapBase() { return d_base; }

        /************************************************************
         * getMapLen()
         ************************************************************/
        Uint32 getMapLen() { return d_maplen; }

        /************************************************************
         * dump()
         ************************************************************/
        void dump(const char *dumper, int bytes);

        /************************************************************
         * ok
         ************************************************************/
        bool       ok;

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
        char        *d_base;
        Uint32       d_maplen;
        bool         d_read;

#ifndef __MINGW32__
        int          d_fd;
#else
        HANDLE       d_fd;

        /*** Handle created by CreateFileMapping ***/
        HANDLE       d_mapHandle;
        bool         d_useNamedShm;
#endif
};

#endif /* INCLUDED_SHM_DFIO_FILE_H */
