/***************************************************************************
 *                             VcdFilter.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements  the info function for a VCD-file to DFIO filter
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef VCD_FILTER_INFO_H
#define VCD_FILTER_INFO_H
#include "DFIOFilter.h"

#ifdef G_HAVE_GINT64
typedef gint64          TimeType; 
typedef guint64         UTimeType;

#ifndef _MSC_VER
#define LLDescriptor(x) x##LL
#define ULLDescriptor(x) x##ULL
#define TTFormat "%lld"
#else
#define LLDescriptor(x) x##i64
#define ULLDescriptor(x) x##i64
#define TTFormat "%I64d"
#endif

#else
typedef long            TimeType; 
typedef unsigned long   UTimeType;

#define TTFormat "%d"
#define LLDescriptor(x) x
#define ULLDescriptor(x) x
#endif

class FileAccObj;
class VcdFilter : public DFIOFilter {

    public:
        VcdFilter(Tcl_Interp *interp);

        virtual Int32       isValidFile(FILE *fp);
        virtual Int32       Import(DFIO **dfio, FileAccObj &file);
        virtual Int32       Export(DFIO **dfio, FileAccObj &file);

    private:
        void Init();

        FileAccObj    file;
        DFIO         *data;

        enum Tokens {
            T_VAR, T_END, T_SCOPE, T_UPSCOPE,
            T_COMMENT, T_DATE, T_DUMPALL, T_DUMPOFF, T_DUMPON,
            T_DUMPVARS, T_ENDDEFINITIONS, 
            T_DUMPPORTS, T_DUMPPORTSOFF, T_DUMPPORTSON, T_DUMPPORTSALL,
            T_TIMESCALE, T_VERSION,
            T_EOF, T_STRING, T_UNKNOWN_KEY
        };

        enum VarTypes {
            V_EVENT, V_PARAMETER,
            V_INTEGER, V_REAL, V_REG, V_SUPPLY0,
            V_SUPPLY1, V_TIME, V_TRI, V_TRIAND, V_TRIOR,
            V_TRIREG, V_TRI0, V_TRI1, V_WAND, V_WIRE, V_WOR, V_PORT,
            V_END, V_LB, V_COLON, V_RB, V_STRING
        };

        /**** Module-local variables ****/
        int numfacs;
        int deadcnt;
        struct symbol **sym;
        struct symbol **facs;
        struct symbol *firstnode;
        struct symbol *curnode;
        TimeType min_time;
        TimeType max_time;
        char hier_delimeter;
        char deadchar;
        int vcd_explicit_zero_subscripts;
        char atomic_vectors;

        int  vcdlineno;
        int  header_over;
        int  dumping_off;
        TimeType    start_time;
        TimeType    end_time;
        TimeType    current_time;
        TimeType    time_scale;
        char vcd_hier_delimeter[2];   /* fill in after rc reading code */

        struct slist *slistroot;
        struct slist *slistcurr;
        char         *slisthier;
        int           slisthier_len;

        int T_MAX_STR;     	/* was originally a const..now it reallocs */
        char *yytext;     
        int   yylen;
        int   yylen_cache;
        struct vcdsymbol   *vcdsymroot;
        struct vcdsymbol   *vcdsymcurr;
        struct vcdsymbol  **sorted;
        int                 numsyms;
        struct queuedevent *queuedevents;

        void add_histent(TimeType time, struct Node *n, 
                char ch, int regadd, char *vector);
        void add_tail_histents();
        void vcd_build_symbols();
        void evcd_strcpy(char *dst, char *src);
        struct vcdsymbol *bsearch_vcd(char *key);
        void   create_sorted_table();
        int    getch_patched();
        int    get_token();
        int    getch();
        int    get_vartoken_patched();
        int    get_vartoken();
        int    get_strtoken();
        char  *build_slisthier();
        void   sync_end(char *hdr);
        void   append_vcd_slisthier(char *str);
        void   parse_valuechange();
        void   vcd_parse();
        void   vcd_sortfacs();
        struct symbol *symadd(char *name, int hv);
        struct symbol *symfind(char *s);
        Uint32 d_keywords;
};

#endif /* VCD_FILTER_INFO_H */
