#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>

#include <kdebug.h>

#include "pref.h"

#include "configdlg.h"

configDlg::configDlg(QWidget *parent, const char *name, bool modal, WFlags fl)
          : configDlgUI(parent, name, modal, fl)
{
    QDict<QString> fishSelNum;
    bool ok;
    
    numOfFishSpinBox -> setValue(kfishPref::prefs() ->getFishNumber());
    numOfBubblesSpinBox -> setValue(kfishPref::prefs() ->getBubblesNumber());
    widthSizeSpinBox -> setValue(kfishPref::prefs() ->getWidth());
    scaleSpinBox -> setValue(kfishPref::prefs() ->getFishScale());
    
    //fishChooseCheckBox -> setChecked ( kfishPref::prefs() -> getFishSel() );
    selectedfishRadButt -> setChecked( kfishPref::prefs() -> getFishSel() );
    randomfishRadButt -> setChecked( kfishPref::prefs() -> getFishRan() );
    if (! kfishPref::prefs() -> getFishSel() )
        fishGroupBox -> setEnabled(false);
    else
        numOfFishSpinBox -> setEnabled(false);
    
    fishSelNum = kfishPref::prefs() -> getFishSelected();
    swordFishSpinBox -> setValue( fishSelNum.find("swordfish")->toInt(&ok, 10) );
    ernestSpinBox -> setValue( fishSelNum.find("ernest")->toInt(&ok, 10) );
    hunterSpinBox -> setValue( fishSelNum.find("hunter")->toInt(&ok, 10) );
    tourtleSpinBox -> setValue( fishSelNum.find("tourtle")->toInt(&ok, 10) );
    greenySpinBox -> setValue( fishSelNum.find("greeny")->toInt(&ok, 10) );
    rayitasSpinBox -> setValue( fishSelNum.find("rayitas")->toInt(&ok, 10) );
    orangySpinBox -> setValue( fishSelNum.find("orangy")->toInt(&ok, 10) );
    loriSpinBox -> setValue( fishSelNum.find("lori")->toInt(&ok, 10) );
    squidSpinBox -> setValue( fishSelNum.find("squid")->toInt(&ok, 10) );
    
    connect(okButton, SIGNAL(clicked()), this, SLOT(slotOk()));
    connect(applyButton, SIGNAL( clicked() ), SLOT ( slotApply() ));
    connect(cancelButton, SIGNAL( clicked() ), SLOT ( slotCancel() ));
//    connect(animationCheckBox, SIGNAL( toggled(bool) ), SLOT( slotAnimCheckBox() ));
}

configDlg::~configDlg()
{
}

void configDlg::slotOk()
{
    slotApply();
    kfishPref::prefs() -> write();
	done(1);
}

void configDlg::slotApply()
{
    kfishPref::prefs() -> setFishNumber(numOfFishSpinBox -> value());
    kfishPref::prefs() -> setBubbleNumber(numOfBubblesSpinBox -> value());
    kfishPref::prefs() -> setWidth(widthSizeSpinBox -> value());
    kfishPref::prefs() -> setFishScale(scaleSpinBox -> value());
    
    kfishPref::prefs() -> setFishSel(selectedfishRadButt -> isChecked());
    kfishPref::prefs() -> setFishRan(randomfishRadButt -> isChecked());
    
    
    QDict<QString> fishSelNum;
    fishSelNum = kfishPref::prefs() -> getFishSelected();    
    //new QString(QString("%1").arg(config->readNumEntry(duh[i]. name, 0)))
    fishSelNum.replace( "swordfish", new QString(QString("%1").arg(swordFishSpinBox -> value())) );
    fishSelNum.replace( "ernest", new QString(QString("%1").arg(ernestSpinBox -> value())) );
    fishSelNum.replace( "hunter", new QString(QString("%1").arg(hunterSpinBox -> value())) );
    fishSelNum.replace( "tourtle", new QString(QString("%1").arg(tourtleSpinBox -> value())) );
    fishSelNum.replace( "greeny", new QString(QString("%1").arg(greenySpinBox -> value())) );
    fishSelNum.replace( "rayitas", new QString(QString("%1").arg(rayitasSpinBox -> value())) );
    fishSelNum.replace( "orangy", new QString(QString("%1").arg(orangySpinBox -> value())) );
    fishSelNum.replace( "lori", new QString(QString("%1").arg(loriSpinBox -> value())) );
    fishSelNum.replace( "squid", new QString(QString("%1").arg(squidSpinBox -> value())) );
    
    QDictIterator<QString> it( fishSelNum );
    bool ok;
    for( ; it.current(); ++it ) {
        kdDebug(1210) << it.currentKey() << ": " << *(it.current()) << " Num:" << it.current()->toInt(&ok, 10) << endl;
    }   
    
    kfishPref::prefs() -> setFishSelected( fishSelNum );
    
    kfishPref::prefs() -> emitChangePref();
}

void configDlg::slotCancel()
{
    kfishPref::prefs() -> load();
	done(0);
}

void configDlg::slotAnimCheckBox()
{
/*    kdDebug(1210) << "void configDlg::slotAnimCheckBox():" << AnimationButtonGroup -> selected() << endl;
    if (AnimationButtonGroup -> selected() == 0)
    {
        kfishPref::prefs() -> setTypeOfAnimation(kfishPref::Mouse);
        AnimationButtonGroup -> setButton( 1 );
		animationTimerSpinBox -> setEnabled( false );
    }*/
//    animationCheckBox -> setChecked ( 0 );
//    kfishPref::prefs() -> setTypeOfAnimation(kfishPref::Mouse);
}
