/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Don Apr 18 12:34:56 CEST 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kimageio.h>
#include <klocale.h>
#include <kstandarddirs.h>

#include "kbarcode.h"
#include "labeleditor.h"
#include "labelprinter.h"
#include "barcodedialog.h"

#ifndef VERSION
    #define VERSION "Unknown Version"
#endif

static KCmdLineOptions options[] =
{
    { "+[file]", I18N_NOOP("load label"), 0},
    { "b +[file]", I18N_NOOP("import data for batchprinting"), 0 },
    { "l +[file]", I18N_NOOP("label for batchprinting"), 0 },
    { "c ", I18N_NOOP("customer id for batchprinting"), 0 },
    { "d <printer>", I18N_NOOP("Printer/destination to print on"), 0},
    { "single", I18N_NOOP("start as xbarcode replacement"), 0 },
    { "batch", I18N_NOOP("start in batchprinting mode"), 0 },
    { "label", I18N_NOOP("start label editor"), 0 },
    { "print", I18N_NOOP("print immediately in batch mode"), 0 },
    KCmdLineLastOption
};

void setupDirs()
{
    if( locate("data", "kbarcode/logo.png").isEmpty() ) {
        // Maybe KBarcode was not installed into $KDEDIR
        KStandardDirs* dirs = KGlobal::dirs();
        QString kdedir = dirs->kfsstnd_prefixes();

        if( !kdedir.contains( "/usr/local/" ) )
            dirs->addPrefix( "/usr/local/" );

        if( !kdedir.contains( "/usr/local/kde/" ) )
            dirs->addPrefix( "/usr/local/kde/" );

        if( !kdedir.contains( "/usr/" ) )
            dirs->addPrefix( "/usr/" );

        qDebug("WARNING: Prefix changed:" + dirs->kfsstnd_prefixes() );
    }
}

int main(int argc, char *argv[])
{
    KAboutData aboutData( "kbarcode", I18N_NOOP("Kbarcode"), VERSION, I18N_NOOP(
        "KBarcode is a barcode and label printing application for KDE 3."
        ), KAboutData::License_GPL, "KBarcode Build:\n" __DATE__ " " __TIME__
        , "(c) 2001-2004, Dominik Seichter\n\n",
        "http://www.kbarcode.net", "kbarcode-users@lists.sourceforge.net" );

    aboutData.addAuthor("Dominik Seichter", I18N_NOOP("Programmer"), "domseichter@web.de");
    aboutData.addAuthor("Stefan \"Stonki\" Onken",
        I18N_NOOP("Project Manager"),
        "support@stonki.de", "http://www.stonki.de" );

    aboutData.addCredit("Alessandro Rubini", I18N_NOOP("Wrote GNU Barcode on which kbarcode is based."),
        "rubini@prosa.it", "http://arcana.linux.it/" );
    aboutData.addCredit("Daniele Medri", I18N_NOOP("Italian translation"), "madrid@linuxmeeting.net" );
    aboutData.addCredit("Anton Vaaranmaa",
         I18N_NOOP("Finnish and Swedish translation, created the KBarcode icon"), "antonv@postikaista.net" );
    aboutData.addCredit("Miguel Revilla Rodr�uez", I18N_NOOP("Spanish translation"), "yo@miguelrevilla.com" );
    aboutData.addCredit("Sandor Jager", I18N_NOOP("Hungarian translation"), "jager@puskas.hu" );
    aboutData.addCredit("Daniel Etzold",
        I18N_NOOP("Tab icon code stolen from his excellent app qtella."), "detzold@qtella.net" );
    aboutData.addCredit("Richard J. Moore", I18N_NOOP("Wrote the RichText KPart"), "rich@kde.org", "http://xmelegance.org/" );
    aboutData.addCredit("Yann Bouan", I18N_NOOP("French Translation"), "yann@bouan.net" );
    aboutData.addCredit("Erich Kitzmüller", I18N_NOOP("Help with ZPL and IPL code"), "kitzmueller@metasyst.at" );
    aboutData.addCredit("Dag Nygren", I18N_NOOP("Wrote many patches to improve KBarcode"), "dag@newtech.fi" );
    aboutData.addCredit("Frank Schoolmeesters", I18N_NOOP("Made the Netherlands translation"), "frank_schoolmeesters@fastmail.fm" );
    aboutData.addCredit("John Volpe", I18N_NOOP("Added lot's of useful data fields to kbarcode"), "jtvolpe@cape.com" );

    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options );

    KApplication a;
    init(); // file barcode structures

    // setup standard dirs
    setupDirs();

    KImageIO::registerFormats();
    a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()));

    new KBarcode( 0, "KBarcodeMainWindow" );

    return a.exec();
}
