/***************************************************************************
                          kbeartransferviewpage.cpp  -  description
                             -------------------
    begin                : Mn Maj 06 2002
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qtextcodec.h>
/////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kglobal.h>
#include <kiconloader.h>
#include <kcharsets.h>
#include <kdebug.h>
/////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeartransferviewpage.h"
#include "kbeartransferviewitem.h"
#include "transfer.h"

QPixmap* KBearTransferViewPage::p_folderClosed = 0;
QPixmap* KBearTransferViewPage::p_folderOpen = 0;
//-----------------------------------------------
KBearTransferViewPage::KBearTransferViewPage(QWidget* parent, const QString& name )
	:	KListView(parent,name.latin1()), m_name( name )
{
	setRootIsDecorated ( true );
	setSorting( -1 ); // no sorting
	addColumn( i18n("Info type") );
	addColumn( i18n("Info") );
	setAllColumnsShowFocus( true );
	QWhatsThis::add( this, i18n("This window displays the progress and status of all current transfers for this site."));
	connect( this, SIGNAL( contextMenuRequested( QListViewItem*, const QPoint&, int ) ),
					this, SLOT( slotItemRightPressed( QListViewItem*, const QPoint&, int ) ) );
}
//-----------------------------------------------
KBearTransferViewPage::~KBearTransferViewPage(){
}
//-----------------------------------------------
QPixmap* KBearTransferViewPage::folderClosed() {
	if( ! p_folderClosed)
		p_folderClosed = new QPixmap( KGlobal::iconLoader()->loadIcon("folder",KIcon::Small, KIcon::SizeSmall ) );
	return p_folderClosed;
}
//-----------------------------------------------
QPixmap* KBearTransferViewPage::folderOpen() {
	if( ! p_folderOpen)
		p_folderOpen = new QPixmap( KGlobal::iconLoader()->loadIcon("folder_open",KIcon::Small, KIcon::SizeSmall ) );
	return p_folderOpen;
}
//-----------------------------------------------
void KBearTransferViewPage::slotTransferFinished( KBearTransferViewItem* item ) {
	QApplication::sendPostedEvents();
	if( childCount() == 0 ) {
		disconnect( this, SIGNAL( contextMenuRequested( QListViewItem*, const QPoint&, int ) ), 0, 0 );
		emit remove( m_name );
	}
	else if( item )
		delete item;
}
//-----------------------------------------------
void KBearTransferViewPage::addTransfer( Transfer* transfer ){
	KBearTransferViewItem* item = new KBearTransferViewItem( this, transfer );
	connect( item, SIGNAL( start( Transfer* ) ), SIGNAL( start( Transfer* ) ) );
	connect( item, SIGNAL( finished( KBearTransferViewItem* ) ),
				this, SLOT( slotTransferFinished( KBearTransferViewItem* ) ) );
}
//-----------------------------------------------
void KBearTransferViewPage::slotItemRightPressed( QListViewItem* item, const QPoint&, int ){
	if( item )
		emit showMenu( item );
}
//-----------------------------------------------
int KBearTransferViewPage::numOfTransfers() const {
	int count = 0;
	QListViewItem* item = firstChild();
	while( item ) {
		if( item->isExpandable() ) {
			QListViewItem* it = item->firstChild();
			while( it ) {
				if( it->text( 0 ) == i18n("Transfer Type") && it->text( 1 ) != i18n("Queued") ) {
					++count;
					break;	
				}
				it = it->nextSibling();
			}
		}
		item = item->nextSibling();		
	}
	return count;		
}
//-----------------------------------------------
int KBearTransferViewPage::checkNameIntegrity( const QString& name ) const{
	int count = 0;
	QListViewItem* item = firstChild();
	while( item ) {
		if( item->isExpandable() ) {
			if( item->text( 0 ).left( name.length() ) == name )
				++count;
		}
		item = item->nextSibling();		
	}
	return count;		
}
//-----------------------------------------------
int KBearTransferViewPage::checkActiveTransfer( const QString& name ) const{
	int count = 0;
	QListViewItem* item = firstChild();
	while( item ) {
		if( item->isExpandable() ) {
			if( item->text( 0 ).left( name.length() ) == name ) {
				QListViewItem* it = item->firstChild();
				while( it ) {
					if( it->text( 0 ) == i18n("Transfer Type") && it->text( 1 ) != i18n("Queued")  ) {
						++count;
						break;	
					}
					it = it->nextSibling();
				}
			}
		}
		item = item->nextSibling();		
	}
	return count;		
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbeartransferviewpage.moc"
#endif
