/***************************************************************************
                          kbearmdichildview.h  -  description
                             -------------------
    begin                : tis jan 15 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARMDICHILDVIEW_H
#define KBEARMDICHILDVIEW_H

//////////////////////////////////////////////////////
// Qt specific includes
#include <qwidget.h>
#include <qlabel.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kparts/part.h>
#include <kio/jobclasses.h>
#include <kfileitem.h>
#include <kurldrag.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "base/kbearchildviewiface.h"
#include "base/kbearchildviewpart.h"
#include "qextmdi/qextmdichildview.h"
#include "base/connection.h"

class Transfer;
class QPopupMenu;
/**
	* This class is an abstract class for all child views in @ref KBear.
	* It offers a DCOP interface, a toolbar and some useful information in the statusbar
	* reimplement the pure virtual functions to get the look and functionality you desire.
	* It also offers a directory tree view, @ref KBearDirVIew and a @ref KFileView
	* @see KBearDirView
	* @see KFileView
	* @see KBearDirOperator
	* @see KBearDetailView
	* @see KBearIconView
	* @see KBearDirOperator
	* @see KBear
	* @short This class is the base class for all child views in @ref KBear.
	* @author Bjrn Sahlstrm
*/

class KBearMdiChildView : public QextMdiChildView, public KBearChildViewDCOPIface  {
   Q_OBJECT
public: 
	/** */
	KBearMdiChildView( QWidget *parent, const Connection& c );
	virtual ~KBearMdiChildView();
	/** */
	virtual void setPath( QString path );
	/** */
	virtual void reload();
	/** */
	virtual void home();
	/** */
	virtual void cdUp();
	/** */
	virtual void back();
	/** */
	virtual void forward();
	/** */
	virtual void stop();
	/** */
	virtual QString currentURL() const;
	/** */
	KURL currentDir() const;
	/** */
	virtual Connection connection() const;
	/** */
	KURL::List selectedURLs();
	/** */
	bool isLocal() const;
	/** */
	void showToolBarUpper( bool );
	/** */
	void showToolBarLower( bool );
	/** */
	void showStatusBarUpper( bool );
	/** */
	void showStatusBarLower( bool );
	/** */
	void readProperties( KConfig* config, const QString& group );
	/** */
	void saveProperties( KConfig* config, const QString& group );
	/** */
	QPopupMenu* popupMenu();
	KParts::Part* part() { return m_part; }
signals:
	/**  */
	void logMessage( const QString&, const QString& );
	/** */
	void transfer( Transfer* );
protected:
	/**
	* Ignores the event and calls @ref QextMdiMainFrm::childWindowCloseRequest instead. This is because the
	* mainframe has control over the views. Therefore the MDI view has to request the mainframe for a close.
	*/
	virtual void closeEvent(QCloseEvent *e);
	/**
	* If attached, the childframe will be activated and the MDI taskbar button will be pressed. Additionally, the
	* memorized old focused child widget of this is focused again.
	* Sends the focusInEventOccurs signal befor changing the focus and the
	* gotFocus signal after changing the focus.
	*/
	virtual void focusInEvent(QFocusEvent *e);
private slots: // Private slots
	void slotNewTransfer( KURLDrag* );
	void slotLogMessage( const QString& );
	void slotDropped( QMimeSource*, const QPoint& );
	void slotSetCaption( const QString& );
	void emitCloseRequest();
private: // Private methods
	void setupConnections();
	void resolveConnection( const Connection& );
	void newTransfer( KIO::MetaData sourceMeta, const KURL::List& urls );
private: // Private attributes
	KBearChildViewPart* m_part;
};

#endif
