/***************************************************************************
                          kbearsettingsdialog.cpp  -  description
                             -------------------
    begin                : tor feb 28 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qlayout.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kapplication.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearsettingsdialog.h"

//-----------------------------------------------
KBearSettingsDialog::KBearSettingsDialog(QWidget *parent, const char *name )
	:	KDialogBase(KDialogBase::IconList,i18n("General Settings"),
					KDialogBase::Ok | KDialogBase::Apply | KDialogBase::Cancel,KDialogBase::Ok,
					parent,name,true)
{
/////////////////////////////////////////////////////
//	page1
	QFrame* page1Parent = addPage( i18n("Views"), QString::null, BarIcon("view_choose", KIcon::SizeLarge));
	QVBoxLayout* page1Layout = new QVBoxLayout( page1Parent, 0, 6 );
	page1 = new ViewSettingsWidget( page1Parent, "ViewSettings" );
	page1Layout->addWidget( page1 );
/////////////////////////////////////////////////////
//	page2
	QFrame* page2Parent = addPage( i18n("Windows"), QString::null, BarIcon("window_nofullscreen", KIcon::SizeLarge) );
	QVBoxLayout* page2Layout = new QVBoxLayout( page2Parent, 0, 6 );
	page2 = new WindowSettingsWidget( page2Parent, "WindowSettings" );
	page2Layout->addWidget( page2 );
/////////////////////////////////////////////////////
//	page3
	QFrame* page3Parent = addPage( i18n("Miscellaneous"), QString::null, BarIcon("misc", KIcon::SizeLarge));
	QVBoxLayout* page3Layout = new QVBoxLayout( page3Parent, 0, 6 );
	page3 = new MixedSettingsWidget( page3Parent, "MixedSettings" );
	page3Layout->addWidget( page3 );
/////////////////////////////////////////////////////
//	page3
	QFrame* page4Parent = addPage( i18n("Firewall"), QString::null, BarIcon("kbear-firewall", KIcon::SizeLarge));
	QVBoxLayout* page4Layout = new QVBoxLayout( page4Parent, 0, 6 );
	page4 = new FirewallSettingsWidget( page4Parent, "FirewallSettings" );
	page4Layout->addWidget( page4 );

/////////////////////////////////////////////////////
	setFocusPolicy( WheelFocus );
}
//-----------------------------------------------
KBearSettingsDialog::~KBearSettingsDialog(){
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbearsettingsdialog.moc"
#endif
