/***************************************************************************
 *   Copyright (C) 2004 by Roberto Virga                                   *
 *   rvirga@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KBSRPCMONITOR_H
#define KBSRPCMONITOR_H

#include <qsocket.h>
#include <qstringlist.h>

#include <kurl.h>

#include <boincdata.h>

class KBSBOINCMonitor;

class KBSRPCMonitor : public QObject
{
  Q_OBJECT
  public:
    KBSRPCMonitor(const QString &host, KBSBOINCMonitor *parent, const char *name=0);
    
    virtual bool canRPC() const;
    
    virtual int interval() const;
    virtual void setInterval(int interval);
    
    virtual QString host() const;
    virtual void setHost(const QString &host);
    
    virtual unsigned port() const;
    virtual void setPort(unsigned port);
    
    virtual BOINCRunMode runMode() const;
    virtual void setRunMode(BOINCRunMode mode);
    
    virtual BOINCNetworkMode networkMode() const;
    virtual void setNetworkMode(BOINCNetworkMode mode);
    
    virtual const BOINCMsgs *messages() const;
    virtual const BOINCFileTransfers *fileTransfers() const;
    
    virtual void setProxyInfo(const BOINCProxyInfo &info);
        
    virtual void attachProject(const KURL &url, const QString &id);
    virtual void detachProject(const KURL &url);
    virtual void resetProject(const KURL &url);
    virtual void updateProject(const KURL &url);
    virtual void suspendProject(const KURL &url, bool suspend);
    virtual void extinguishProject(const KURL &url, bool extinguish);
    
    virtual void showGraphics(const KURL &url, const QString &result);
    virtual void abortResult(const KURL &url, const QString &result);
    virtual void suspendResult(const KURL &url, const QString &result, bool suspend);
    
    virtual void abortFileTransfer(const KURL &url, const QString &name);
    virtual void retryFileTransfer(const KURL &url, const QString &name);
    
    virtual void sendCommand(const QString &command);
    
  signals:
    void intervalChanged(int interval);
    
    void updated();
    void runModeUpdated();
    void networkModeUpdated();
    void proxyInfoUpdated();
    void messagesUpdated();
    void fileTransfersUpdated();
    
    void error(const QString &message);
  
  protected:
    virtual KBSBOINCMonitor *monitor();
    
    virtual void projectCommand(const QString &tag, const KURL &url);
    virtual void resultCommand(const QString &tag, const KURL &url, const QString &result);
    virtual void fileTransferCommand(const QString &tag, const KURL &url, const QString &name);
    
    virtual void fetchData();
    virtual void timerEvent(QTimerEvent *);
  
  private:
    void startConnection();
    void sendQueued();
    
    void fetchRunMode();
    void fetchNetworkMode();
    void fetchMessages();
    void fetchFileTransfers();
    
    void massageFileTransfers(BOINCFileTransfers &fileTransfers);
  
  private slots:
    void slotConnected();
    void slotConnectionClosed();
    void slotReadyRead();
    void slotError(int error);

  protected:
    BOINCRunMode m_runMode;
    BOINCNetworkMode m_networkMode;
    BOINCMsgs m_msgs;
    int m_seqno;
    BOINCFileTransfers m_fileTransfers;
  
  private:
    QString m_host;
    QSocket *m_socket;
    enum Status {Disconnected, Connecting, Idle, Active} m_status;
    int m_interval, m_timer;
    unsigned m_port;
    QStringList m_queue;
    QString m_output;
};

#endif
