/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2004	  by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef PROJECTWIZARD_H
#define PROJECTWIZARD_H

#include <kwizard.h>

#include "kbproject.h"

#include "qmap.h"
#include "qstring.h"

class ProjectStep1;
class ProjectStep2;

namespace KBabel {

class ProjectWizard : public KWizard
{
    Q_OBJECT
public:
    ProjectWizard(QWidget* parent = 0, const char * name = 0);
    
    Project::Ptr project();

    static Project::Ptr newProject();

private slots:
    void textChanged(const QString &);
    void check();
    
private:
    ProjectStep1* _wizard;
    ProjectStep2* _wizard2;
    
    QMap<QString, QString> m_language_codes;
};

}

#endif // PROJECTPREF_H
