class Jobs:
    """ """
    def __init__(self, num, taskmaster):
        """ """
        self.job=None
        if num > 1:
            try:
                self.job=Parallel(taskmaster, num)
                self.num_jobs=num
            except NameError:
                pass
        if self.job is None:
            self.job=Serial(taskmaster)
            self.num_jobs=1
    def run(self):
        """ """
        try:
            self.job.start()
        except KeyboardInterrupt:
            import signal
            signal.signal(signal.SIGINT, signal.SIG_IGN)
            raise
class Serial:
    """ """
    def __init__(self, taskmaster):
        """ """
        
        self.taskmaster=taskmaster
    def start(self):
        """ """
        
        while 1:
            task=self.taskmaster.next_task()
            if task is None:
                break
            try:
                task.prepare()
                task.execute()
            except KeyboardInterrupt:
                raise
            except:
                task.exception_set()
                task.failed()
            else:
                task.executed()
            task.postprocess()
try:
    import Queue
    import threading
except ImportError:
    pass
else:
    class Worker(threading.Thread):
        """ """
        def __init__(self, requestQueue, resultsQueue):
            threading.Thread.__init__(self)
            self.setDaemon(1)
            self.requestQueue=requestQueue
            self.resultsQueue=resultsQueue
            self.start()
        def run(self):
            while 1:
                task=self.requestQueue.get()
                try:
                    task.execute()
                except KeyboardInterrupt:
                    ok=False
                except:
                    task.exception_set()
                    ok=0
                else:
                    ok=1
                self.resultsQueue.put((task, ok))
    class ThreadPool:
        """ """
        def __init__(self, num):
            """ """
            self.requestQueue=Queue.Queue(0)
            self.resultsQueue=Queue.Queue(0)
            for i in range(num):
                Worker(self.requestQueue, self.resultsQueue)
        def put(self, obj):
            """ """
            self.requestQueue.put(obj)
        def get(self, block=1):
            """ """
            return self.resultsQueue.get(block)
            
        def get_nowait(self):
            """ """
            return self.get(0)
    class Parallel:
        """ """
        def __init__(self, taskmaster, num):
            """ """
            self.taskmaster=taskmaster
            self.tp=ThreadPool(num)
            self.jobs=0
            self.maxjobs=num
        def start(self):
            """ """
            while 1:
                if self.jobs < self.maxjobs:
                    task=self.taskmaster.next_task()
                    if task is None:
                        break
                    try:
                        task.prepare()
                    except KeyboardInterrupt:
                        raise
                    except:
                        task.failed()
                    self.tp.put(task)
                    self.jobs=self.jobs + 1
                while 1:
                    try:
                        task, ok=self.tp.get_nowait()
                    except Queue.Empty:
                        if not (self.jobs is self.maxjobs or self.taskmaster.is_blocked()):
                            break
                        task, ok=self.tp.get()
                    self.jobs=self.jobs - 1
                    if ok:
                        task.executed()
                    else:
                        task.failed()
                    task.postprocess()
