/***********************************************************************
**
**   centertodialog.h
**
**   This file is part of KFLog2.
**
************************************************************************
**
**   Copyright (c):  2002 by Andree Somers
**
**   This file is distributed under the terms of the General Public
**   Licence. See the file COPYING for more information.
**
**   $Id: centertodialog.h,v 1.3 2003/05/19 12:16:06 florian Exp $
**
***********************************************************************/

#ifndef CENTERTODIALOG_H
#define CENTERTODIALOG_H

#include <kdialogbase.h>

#include "guicontrols/coordedit.h"
/**
 * @short Dialog to enter the coordinates to center the map to
 *
 * This dialog is shown if the user wants to center the map on a specific
 * coordinate. The user can enter a latitude and a longitude, and after
 * pressing OK the map is asked to center on that coordinate.
 *
 * @author Andr Somers
 * @version $Id: centertodialog.h,v 1.3 2003/05/19 12:16:06 florian Exp $
 */
class CenterToDialog : public KDialogBase
{
  Q_OBJECT

  public:
    /**
     * Constructor
     */
    CenterToDialog(QWidget* parent, const char* name);
    /**
     * Destructor
     */
    ~CenterToDialog();

  signals:
    /**
     * Signal send when coordinate is selected
     */
    void centerTo(int lattitude, int longitude);

  private:
    /**
     * Entrybox for the latitude
     */
    LatEdit* latE;
    /**
     * Entrybox for the longitude
     */
    LongEdit* longE;

  private slots:
    /**
     * Received if the OK button is clicked
     */
    void slotOk();
};

#endif
