/*              Name:           progload.c
                Version:        0.9.10
                Date:           14/6/2003
				Functions to deal with BFD and loading programs
*/

#define GTK_ENABLE_BROKEN 

#include <stdio.h>
#include <bfd.h>             
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <glib.h>
#include <string.h>
#include "interface.h"
#include "progload.h"
#include "view.h"
#include "misc.h"
#include "serial.h"
#include "callbacks.h"
#include "lint.h"


GList* progload_source_files=NULL;
GList* address_line_list=NULL;
GtkWidget *view_source=NULL;
address_line *old_pcline=NULL, *old_raline=NULL;

void progload_load (char* filename)  /* Load button pressed*/
{ /*                Load button       Text entry*/
 bfd *progload_abfd;
 asection *section;
 int tosend;
 uchar* address;
 long storage_needed;
 long i;
 asymbol **bfd_symbol_table = NULL;
 int symbol_count;
 Symbol* symbol;




 bfd_set_error (bfd_error_no_error);
 progload_abfd = bfd_openr (filename, NULL); 
 if (VERBOSE)g_print("Loading: %s\n",filename);
 if (bfd_get_error ()) {if (VERBOSE)g_print("ELF load error:%s\n",bfd_errmsg (bfd_get_error())); return;}
 if (!bfd_check_format(progload_abfd, bfd_object)) {if (VERBOSE) g_print("File is not BFD format");bfd_close(progload_abfd); gtk_widget_show (view_fileerror);return;} /* on any error just return */
// if(bfd_get_error()){g_print("%s\n",bfd_errmsg (bfd_get_error()));}
 bfd_set_error (bfd_error_no_error);
 
 storage_needed = bfd_get_symtab_upper_bound (progload_abfd);
 if (storage_needed < 0) {if (VERBOSE)g_print("ELF load error in symbol table load\n"); return;}
 if (storage_needed != 0) {
    if (symbol_table)    {
        symbol_free_table (symbol_table);
        symbol_table=NULL;
        }
    bfd_symbol_table = (asymbol **) g_malloc (storage_needed);
    symbol_count = bfd_canonicalize_symtab (progload_abfd, bfd_symbol_table);
    if (symbol_count < 0) {if (VERBOSE)g_print("ELF load error in symbol table load\n"); return;}
    
    for (i = 0; i < symbol_count; i++) {
        symbol = g_new(Symbol, 1);
        symbol->flags=bfd_symbol_table[i]->flags;
        symbol->name=g_strdup(bfd_symbol_table[i]->name);
        symbol->value=lint_new(bfd_symbol_table[i]->value + bfd_symbol_table[i]->section->vma); //add the value to the offset of the section
        symbol_table = g_list_append(symbol_table,symbol);
//        g_print("symbol:%8x %8x %8x %s\n",symbol_table[i].value, symbol_table[i].flags, bfd_symbol_table[i]->section->vma + bfd_symbol_table[i]->value, symbol_table[i].name);
        }
    }
 
 
   {
    GList* temp = progload_source_files;
    
    while (temp) {
        g_free(((source_file*)temp->data)->filename);
        g_list_free_contents(((source_file*)temp->data)->lines);
        g_list_free(((source_file*)temp->data)->lines);
        g_free( (source_file*)temp->data);
        temp = temp->next;
        }
    g_list_free(progload_source_files);

    g_list_free_contents(address_line_list);
    g_list_free(address_line_list);

    progload_source_files =NULL;    
    address_line_list = NULL;
    old_pcline=NULL;
    old_raline=NULL;
   }











 section=progload_abfd->sections;
 while(section){
  if (section->flags & 1){
     uchar *sectionContents;
     bfd_size_type sectionSize = bfd_get_section_size(section); /* get file */
     bfd_size_type count=0;
     uchar* start = view_int2chararr(board_memory_ptr_width, section->vma);
     sectionContents = g_new (uchar, sectionSize);
     bfd_get_section_contents (progload_abfd, section, (PTR) sectionContents, 0, sectionSize);
     if(bfd_get_error ()) {if (VERBOSE)g_print("ELF loads error5\n");bfd_close(progload_abfd); return;}
     
     while (count<sectionSize){
       gfloat float_temp;
       tosend=MIN(sectionSize-count,80);
       address = view_chararrAddint(board_memory_ptr_width, start, count); /* send data 80 at a time*/
       board_set_memory (tosend, address, sectionContents+count, 1);
       g_free(address);
	   if (board_micro_ping()) count +=tosend;                 /* if errored with microping then do again*/

       float_temp = ((gfloat)count)/((gfloat)sectionSize);

//        g_print("float:%f\n", float_temp);
//	   callback_main_progress_bar_update ();/* update progress bar*/

 if (float_temp<1) gtk_progress_set_format_string (GTK_PROGRESS(view_progressbar), "Loading:%p\%");
 else gtk_progress_set_format_string (GTK_PROGRESS(view_progressbar), "Loaded");
 gtk_progress_set_percentage  (GTK_PROGRESS(view_progressbar),(gfloat)float_temp);/* update progress bar*/
 while (gtk_events_pending())  gtk_main_iteration();          /*update display and do user stuff*/
       
	   }
     g_free(sectionContents);
     g_free(start);
     }
  
  
   {
   const char *filename;
   const char *functionname;
   unsigned int line;
   const char *last_filename="";
   unsigned int last_line = -1;
   long index;
   int changed;
   source_file* file = NULL;
   size_t sectionSize = bfd_get_section_size(section); /* get file */
   

   for (index=0;index < sectionSize; index++){
        bfd_find_nearest_line (progload_abfd, section, bfd_symbol_table, index, &filename, &functionname, &line);
//        g_print("line: %d %s\n",line, functionname);
        changed=0;
//        if (!functionname) filename=NULL;
	    if (line<=0) filename=NULL;
        if (filename)
            if (strcmp(filename,last_filename)){
                file = progload_load_source_file((char*)filename);
                changed=1;
                }
        if (last_line != line) changed=1;
        if (changed && filename){
            address_line* new_line = g_new(address_line,1);
            new_line->address = section->vma + index;
            new_line->line = line;
            new_line->file = file;
            address_line_list = g_list_insert_sorted (address_line_list,new_line,progload_address_line_compare);
//        g_print("%x, %s, %s, %d \n", new_line->address, filename, functionname, line);
//        g_print("%s\n",(char*)g_list_nth_data(file->lines, line));
            last_filename = filename;
            last_line=line;
            }
        }
  
   }
  section=section->next;
  }
 {
 int pcbank = 0, pcnumber = 0, temp;
 uchar* value;
  for (temp=0; temp<special_register_count; temp++){
        if (!g_strcasecmp(special_registers[temp].name, "PC")){
                pcbank =   special_registers[temp].banknumber;
                pcnumber = special_registers[temp].regnumber;
                }
        }
 value = view_int2chararr(4, progload_abfd->start_address);
 board_sendchar(BR_RESET);
 board_set_register(pcbank , pcnumber, value);
 g_free(value);
 }
 
 
 bfd_close(progload_abfd);
 g_free(bfd_symbol_table);
 progload_update();
 callback_global_refresh();
}


int progload_address_line_compare(gconstpointer a, gconstpointer b)
{
return ((address_line*) a)->address - ((address_line*) b)->address;

}




source_file* progload_load_source_file(char* filename)
{
 GList* filelist=progload_source_files;
 source_file* new_source_file;
 while (filelist){
    if (!strcmp(((source_file*)filelist->data)->filename, filename)) break;
    filelist=filelist->next;
    }
 if (filelist) return (source_file*)filelist->data;
 {
  FILE *Fhandle;
  char line[1000];    // I cant think why anyone would want lines longer than 1000 chars
                      // if someone does then this will go wrong
                      
  new_source_file = g_new(source_file,1); 
  progload_source_files = g_list_append(progload_source_files, new_source_file);
  new_source_file->filename = g_strdup(filename);
  new_source_file->error=NULL;
  new_source_file->lines=NULL;
  
  Fhandle = fopen (filename, "r");
  if (!Fhandle) {new_source_file->error="Can not open file"; return new_source_file;}
  while (fgets (line, sizeof line, Fhandle)){
     new_source_file->lines = g_list_append(new_source_file->lines, g_strdup(line)); //Possibly slow
     }
  return new_source_file;
 }
    
}










void progload_update (void)
{  /* update */
  int temp, pc=0 , ra=0;
  GList *list, *list2;
  GdkColor *pccolour = NULL, *racolour = NULL;

    address_line test_line;
    address_line *pcline=NULL, *raline=NULL;
    int pcline_no, raline_no = 0;
    char c;
    
    static int pc_char_index;

    int chars, lines;

  if (!view_source) return ;

  for (temp=0; temp<special_register_count; temp++){
        if (!g_strcasecmp(special_registers[temp].name, "PC")){
                pc = view_chararr2int(board_memory_ptr_width, special_registers[temp].value);
                pccolour = &special_registers[temp].colour;
                }

        if (!g_strcasecmp(special_registers[temp].name, "RA")){
                ra = view_chararr2int(board_memory_ptr_width, special_registers[temp].value);
                racolour = &special_registers[temp].colour;
                }
        }
    test_line.address = pc;
    list = g_list_find_custom(address_line_list,&test_line,progload_address_line_compare);
    if (!address_line_list) return;
    list=address_line_list;
    do  {
        if (!list->next) {
            if (!pcline) pcline = (address_line*)list->data;
            if (!raline) raline = (address_line*)list->data;
            break;
            }
        list=list->next;
        if (((address_line*)list->data)->address >  pc && !pcline) pcline = (address_line*)list->prev->data;
        if (((address_line*)list->data)->address == pc && !pcline) pcline = (address_line*)list->data;
        if (((address_line*)list->data)->address >  ra && !raline) raline = (address_line*)list->prev->data;
        if (((address_line*)list->data)->address == ra && !raline) raline = (address_line*)list->data;
        }
        while (((address_line*)list->data)->address < pc || ((address_line*)list->data)->address < ra);



    
    if (!old_pcline || pcline->file != old_pcline->file){
        pcline_no = pcline->line;
        if (pcline->file == raline->file) raline_no = raline->line;
        else raline = 0;
        temp=0;
        gtk_text_freeze(GTK_TEXT (view_source));
        gtk_text_set_point(GTK_TEXT (view_source), 0);
        gtk_text_forward_delete(GTK_TEXT (view_source), gtk_text_get_length(GTK_TEXT (view_source)));
        chars=0;
        for (list2=pcline->file->lines; list2; list2=list2->next){
            temp++;
            chars += strlen((char*)list2->data);
            if (pcline_no == temp) {    gtk_text_insert (GTK_TEXT (view_source), fixed_font, pccolour, NULL,(char*)list2->data , -1);
                                        pc_char_index = chars;}
            else if (raline_no == temp) gtk_text_insert (GTK_TEXT (view_source), fixed_font, racolour, NULL,(char*)list2->data , -1);
            else                        gtk_text_insert (GTK_TEXT (view_source), fixed_font, NULL,     NULL,(char*)list2->data , -1);
            }
        gtk_text_thaw(GTK_TEXT (view_source));
        }
    else {
        gtk_text_freeze(GTK_TEXT (view_source));
        if (raline->file != old_raline->file || raline->line != old_raline->line) {

          if (old_raline->file == pcline->file && old_raline->line != pcline->line){
            chars=0;
            list = old_raline->file->lines;
            lines = old_raline->line;
            while (lines-- > 0){
                chars += strlen((char*)list->data);
                list = list->next;
                }
            gtk_text_set_point(GTK_TEXT (view_source), chars);
            gtk_text_forward_delete(GTK_TEXT (view_source),strlen((char*)list->data));
            gtk_text_insert (GTK_TEXT (view_source),fixed_font , NULL, NULL,(char*)list->data , -1);
            gtk_text_thaw(GTK_TEXT (view_source));
            gtk_text_freeze(GTK_TEXT (view_source));        
            }
            
          if (raline->file == pcline->file && raline->line != pcline->line){
            chars=0;
            list = raline->file->lines;
            lines = raline->line;
            while (--lines){
                chars += strlen((char*)list->data);
                list = list->next;
                }
            gtk_text_set_point(GTK_TEXT (view_source), chars);
            gtk_text_forward_delete(GTK_TEXT (view_source),strlen((char*)list->data));
            gtk_text_insert (GTK_TEXT (view_source),fixed_font , racolour, NULL,(char*)list->data , -1);
            gtk_text_thaw(GTK_TEXT (view_source));
            gtk_text_freeze(GTK_TEXT (view_source));        
            }
          }

        if (pcline->line != old_pcline->line) {
        
          if (1){
            chars=0;
            list = old_pcline->file->lines;
            lines = old_pcline->line;
            while (--lines){
                chars += strlen((char*)list->data);
                list = list->next;
                }
            gtk_text_set_point(GTK_TEXT (view_source), chars);
            gtk_text_forward_delete(GTK_TEXT (view_source),strlen((char*)list->data));
            if (raline->file == pcline->file && raline->line == old_pcline->line)
                    gtk_text_insert (GTK_TEXT (view_source),fixed_font , racolour, NULL,(char*)list->data , -1);
            else    gtk_text_insert (GTK_TEXT (view_source),fixed_font , NULL, NULL,(char*)list->data , -1);
            gtk_text_thaw(GTK_TEXT (view_source));
            gtk_text_freeze(GTK_TEXT (view_source));        
            
            }
            
          if (1){
            chars=0;
            list = pcline->file->lines;
            lines = pcline->line;
            while (--lines){
                chars += strlen((char*)list->data);
//                g_print("char:%d\n", chars);
                list = list->next;
                }
//            g_print("final:%d\n", chars);
            pc_char_index = chars;
            gtk_text_set_point(GTK_TEXT (view_source), chars);
//            g_print("final2:%d\n", chars);
            lines = strlen((char*)list->data);
//            g_print("length:%d\n", lines);
            gtk_text_forward_delete(GTK_TEXT (view_source),lines);
            gtk_text_insert (GTK_TEXT (view_source),fixed_font , pccolour, NULL,(char*)list->data , -1);
            }
            
          }
          
          
          
          
        gtk_text_thaw(GTK_TEXT (view_source));
        
        c = GTK_TEXT_INDEX(GTK_TEXT (view_source), pc_char_index);
        gtk_text_set_point(GTK_TEXT (view_source), pc_char_index);
        gtk_text_freeze(GTK_TEXT (view_source));
        gtk_text_insert (GTK_TEXT (view_source),fixed_font , pccolour, NULL," " , 1);
        gtk_text_thaw(GTK_TEXT (view_source));
        gtk_text_backward_delete(GTK_TEXT (view_source),1);
        
        
        
        }


  old_pcline=pcline;
  old_raline=raline;

}
