/***************************************************************************
                      iptable.h  -  description
                         -------------------
begin                : Tue Aug 20 2002
copyright            : (C) 2002 by animal
email                : animal@shit.orphi.iki
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IPTABLE_H
#define IPTABLE_H

/**Class that represents the properties of a "table" in the iptables
 
  *@author animal
  */

// qt includes
#include <qptrlist.h>

// project includes
#include "iptchain.h"

// project classes
class KMFError;
class KMFErrorHandler;
class KMFDoc;
// qt classes
class QString;

class IPTable {
public:
	IPTable( KMFDoc*, const QString& name );
	~IPTable();

	/** Set the name of this table to name
	*/
	void setName( const QString& /* name */ );
	/** Set the used flag
	*/
	void setUsed( bool used ) {
		m_used = used;
	};

	/** Simply deletes all chains
	*/
	void resetTable();

	/** Return the name of this table
	*/
	const QString& name() const {
		return m_name;
	};

	IPTChain* chainForName( QString& );
	/**  Add a IPTChain object to this table
	*/

	KMFError* addChain( QString& chain_name, QString& chain_target, bool builtin );

	/** Remove the given IPTChain
	*/
	KMFError* delChain( IPTChain *chain );


	/** Move rule to target_chain
	*/
	KMFError* moveRuleToChain( IPTRule* rule, IPTChain *target_chain );

	/** Copy rule to target_chain
	*/
	KMFError* copyRuleToChain( IPTRule* rule, IPTChain *target_chain );

	/** Return a pointer to KMFDoc object to which this
		table belongs
	*/
	KMFDoc* kmfDoc() const {
		return kmfdoc;
	};


	/** Returns true if it used by the current configuration
	*/
	bool used() const {
		return m_used;
	};

	/** Returns the list with the iptchains in this table
	*/
	QPtrList<IPTChain>& chains() const;

	//	IPTable* createTableClone();

private:


	void settupDefaultChains();

	/** name of the table
	*/
	QString m_name;

	/** the list holding the chains in this table
	*/
	QPtrList<IPTChain> m_chains;

	/** used by the current configuration
	*/
	bool m_used;

	KMFError* addChain( IPTChain &chain );
	KMFError* m_err;
	KMFErrorHandler* m_err_handler;
	KMFDoc* kmfdoc;
};

#endif
