/***************************************************************************
                      iptrule.cpp  -  description
                         -------------------
begin                : Mon Feb 4 2002
copyright            : (C) 2002 by Christian Hubinger
email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/ 
//project includes
#include "iptrule.h"
#include "iptchain.h"
#include "iptable.h"
#include "kmferror.h"
#include "kmfcheckinput.h"

//qt includes
#include "qstring.h"
#include "qdict.h" 
// kde includes
#include <kdebug.h>
#include <klocale.h> 
//stdlib includes
#include <iostream>
IPTRule::IPTRule( const QString& tmp_name, IPTChain* tmp_chain, const QString& tmp_target ) : NetfilterObject() {
	m_name = "UNDEFINED";
	m_target = "UNDEFINED";
	m_check_input = new KMFCheckInput();
	m_err = new KMFError();
	setName( tmp_name );
	setTarget( tmp_target );
	setChain( tmp_chain );
	setTable( tmp_chain->table() );
  setCustomRule(false);
//  setDescription("");
	m_rule_num = -1;
	setUpKnownRules();
	m_enabled = true;
	m_log_rule = false;

	ipt_cmd = "$IPT";
	tab = "-t";
	ap = "-A";
	ws = " ";
	post = "-j";
}

IPTRule::~IPTRule() {
	kdDebug() << "\n\nIPTRule::~IPTRule()" << endl;
	delete m_check_input;
	available_options.clear();
	available_target_options.clear();
	used_options.clear();
	used_target_options.clear();
	option_list.clear();
	target_option_list.clear();
}

KMFError* IPTRule::setName( const QString& tmp_name ) {
	QString inp = tmp_name;
	m_err = m_check_input->checkInput( inp, "RULENAME" );
	if ( m_err->errNum() > 0 )
		return m_err;
	m_name = tmp_name;
	return m_err;
	//  kdDebug() << "Rule Name: " << m_name << endl;
}

const QString& IPTRule::name() const {
	return m_name;
}

void IPTRule::setChain( IPTChain* ch ) {
	m_chain = ch;
}

void IPTRule::setTable( IPTable* tmp_table ) {
	m_table = tmp_table;
	//		kdDebug() << "Rule Table: " << *m_table->name() << endl;
}

void IPTRule::setTarget( const QString& tmp_target ) {
  if ( !tmp_target.isNull() ) {
		m_target = tmp_target;
		target_option_list.clear();
	}
	//		kdDebug() << "Rule Target: " << *m_target << endl;
}

void IPTRule::setRuleNum( int num ) {
	//	kdDebug() << "IPTRule::setRuleNum(int num)" << endl;
	//  kdDebug() << "Setting Rule No: " << num << endl;
	m_rule_num = num;
}

//void IPTRule::setDescription( const QString& desc ) {
//	if ( desc.isNull() )
//		return;
//	m_desc = desc;
//}
void IPTRule::setCustomRule( bool on ) {
	m_custom_rule = on;
}

int IPTRule::ruleNum() const {
	return m_rule_num;
}

const QString& IPTRule::target() const {
	return m_target;
}

QPtrList<QPtrList<QString> >& IPTRule::ruleOptions() const {
	QPtrList<QPtrList<QString> >* ret_val = new QPtrList<QPtrList<QString> >;
	*ret_val = option_list;
	return *ret_val;
}

QPtrList<QPtrList<QString> >& IPTRule::ruleTargetOptions() const {
	QPtrList<QPtrList<QString> >* ret_val = new QPtrList<QPtrList<QString> >;
	*ret_val = target_option_list;
	return *ret_val;
}

bool IPTRule::addRuleOption( QString& par_name, QPtrList<QString>& cmds ) {
	QString option;
	option = par_name;
	//  kdDebug() << "Try to insetrt " <<  option << " Option." << endl;

	if ( !option_list.isEmpty() ) {
		for ( uint i = 0;i < option_list.count();i++ ) {
			QPtrList<QString>* vals = option_list.at( i );
			if ( vals->count() > 0 ) {
				QString * opt = vals->at( 0 );
				if ( *opt == par_name ) {
					option_list.remove( i );
					used_options.remove( par_name );
					//          kdDebug() << "Removed old " << par_name << " Option" << endl;
				}
			}
		}
	}

	QString* cmd = new QString();
	cmd = available_options.find( option );
	if ( cmd ) {
		int l = cmds.count();

		QString* value = new QString( "" );
		QString* src = new QString( "" );
		QString* dest = new QString( "" );
		QString* flags = new QString( "" );
		QString* tcp_options = new QString( "" );
		QString* interf = new QString( "" );
		QString* limit = new QString( "" );
		QString* burst = new QString( "" );
		QString* ports = new QString( "" );
		QString* state = new QString( "" );
		QString* mac = new QString( "" );
		QString* neg = new QString( "" );
		QString* custom_opt = new QString( "" );

		QPtrList<QString>* values = new QPtrList<QString>;
		QPtrList<QString>* option_values = new QPtrList<QString>;

		QString* opt_cmd = new QString( *cmd );
		const QString* op = new QString( option );

		values->append( opt_cmd );
		option_values->append( op );

		if ( option == "custom_option" ) {
			custom_opt = cmds.at( 0 );
			if ( !custom_opt->isEmpty() ) {
				value->append( *custom_opt );
				option_values->append( custom_opt );
				values->append( value );
			}
		} else if ( option == "tcp" ) {
			//			kdDebug() << "TCP OPTION FOUND" << endl;
			//    		kdDebug() << "Option count: " << l << endl;
			if ( l == 1 ) {
				src = cmds.at( 0 );
				if ( !src->isEmpty() ) {
					if ( *src != "nil" ) {
						value->append( "--source-port " );
						value->append( *src );
						option_values->append( src );
					}
				} else
					option_values->append( value );
				values->append( value );
			} else if ( l == 2 ) {
				src = cmds.at( 0 );
				dest = cmds.at( 1 );
				if ( !src->isEmpty() ) {
					if ( *src != "nil" ) {
						value->append( "--source-port " );
						value->append( *src );
					}
					option_values->append( src );
				} else
					option_values->append( value );
				values->append( value );
				value = new QString( "" );
				if ( !dest->isEmpty() ) {
					value->append( "--destination-port " );
					value->append( *dest );
					option_values->append( dest );
				} else
					option_values->append( src );
				values->append( value );
			} else if ( l == 3 ) {
				src = cmds.at( 0 );
				dest = cmds.at( 1 );
				flags = cmds.at( 2 );
				if ( !src->isEmpty() ) {
					if ( *src != "nil" ) {
						value->append( "--source-port " );
						value->append( *src );
					}
					option_values->append( src );
				} else
					option_values->append( value );
				values->append( value );
				value = new QString( "" );
				if ( !dest->isEmpty() ) {
					value->append( "--destination-port " );
					value->append( *dest );
					option_values->append( dest );
				} else
					option_values->append( value );
				values->append( value );
				value = new QString( "" );
				if ( !flags->isEmpty() ) {
					value->append( "--tcp-flags " );
					value->append( *flags );
					option_values->append( flags );
				} else
					option_values->append( value );
				values->append( value );
			} else if ( l == 4 ) {
				src = cmds.at( 0 );
				dest = cmds.at( 1 );
				flags = cmds.at( 2 );
				tcp_options = cmds.at( 3 );
				if ( !src->isEmpty() ) {
					if ( *src != "nil" ) {
						value->append( "--source-port " );
						value->append( *src );
					}
					option_values->append( src );
				} else
					option_values->append( value );
				values->append( value );
				value = new QString( "" );
				if ( !dest->isEmpty() ) {
					value->append( "--destination-port " );
					value->append( *dest );
					option_values->append( dest );
				} else
					option_values->append( value );
				values->append( value );
				value = new QString( "" );
				if ( !flags->isEmpty() ) {
					value->append( "--tcp-flags " );
					value->append( *flags );
					option_values->append( flags );
				} else
					option_values->append( value );
				values->append( value );
				value = new QString( "" );
				if ( !tcp_options->isEmpty() ) {
					value->append( "--tcp-option " );
					value->append( *tcp_options );
					option_values->append( tcp_options );
				} else
					option_values->append( value );
				values->append( value );
			}
		} else if ( option == "udp" ) {
			//    		kdDebug() << "Option count: " << l << endl;
			if ( l == 1 ) {
				src = cmds.at( 0 );
				if ( !src->isEmpty() ) {
					value->append( "--source-port " );
					value->append( *src );
					option_values->append( src );
				} else
					option_values->append( value );
				values->append( value );
			} else if ( l == 2 ) {
				src = cmds.at( 0 );
				dest = cmds.at( 1 );
				if ( !src->isEmpty() ) {
					value->append( "--source-port " );
					value->append( *src );
					option_values->append( src );
				} else
					option_values->append( value );
				values->append( value );
				value = new QString( "" );
				if ( !dest->isEmpty() ) {
					value->append( "--destination-port " );
					value->append( *dest );
					option_values->append( dest );
				} else
					option_values->append( value );
				values->append( value );
			}
		} else if ( option == "src_ip" ) {
			src = cmds.at( 0 );
			if ( !src->isEmpty() ) {
				value->append( *src );
				option_values->append( src );
				values->append( value );
			}
		} else if ( option == "dest_ip" ) {
			dest = cmds.at( 0 );
			if ( !dest->isEmpty() ) {
				value->append( *dest );
				option_values->append( dest );
				values->append( value );
			}
		} else if ( option == "in_int" ) {
			interf = cmds.at( 0 );
			if ( !interf->isEmpty() ) {
				value->append( *interf );
				option_values->append( interf );
				values->append( value );
			}
		} else if ( option == "out_int" ) {
			interf = cmds.at( 0 );
			if ( !interf->isEmpty() ) {
				value->append( *interf );
				option_values->append( interf );
				values->append( value );
			}
		} else if ( option == "limit" ) {
			//    		kdDebug() << "Option count: " << l << endl;
			if ( l == 1 ) {
				limit = cmds.at( 0 );
				if ( !limit->isEmpty() ) {
					value->append( "--limit " );
					value->append( *limit );
					option_values->append( limit );
					values->append( value );
				}
			} else if ( l == 2 ) {
				limit = cmds.at( 0 );
				burst = cmds.at( 1 );
				if ( !limit->isEmpty() ) {
					value->append( "--limit " );
					value->append( *limit );
					option_values->append( limit );
					values->append( value );
				}
				if ( !burst->isEmpty() ) {
					value = new QString( "" );
					value->append( "--limit-burst " );
					value->append( *burst );
					option_values->append( burst );
					values->append( value );
				}
			}
		} else if ( option == "mac" ) {
			for ( uint i = 0;i < cmds.count();i++ ) {
				mac = cmds.at( i );
				if ( !mac->isEmpty() ) {
					value->append( "--mac-source " );
					value->append( *mac );
					option_values->append( mac );
					values->append( value );
				}
			}
		} else if ( option == "state" ) {
			for ( uint i = 0;i < cmds.count();i++ ) {
				state = cmds.at( i );
				if ( !state->isEmpty() ) {
					value->append( "--state " );
					value->append( *state );
					option_values->append( state );
					values->append( value );
				}
			}
		} else if ( option == "tcp_src_multiport" ) {
			ports = cmds.at( 0 );
			if ( !ports->isEmpty() ) {
				value->append( *ports );
				option_values->append( ports );
				values->append( value );
			}
		} else if ( option == "tcp_dest_multiport" ) {
			ports = cmds.at( 0 );
			if ( !ports->isEmpty() ) {
				value->append( *ports );
				option_values->append( ports );
				values->append( value );
			}
		} else if ( option == "udp_src_multiport" ) {
			ports = cmds.at( 0 );
			if ( !ports->isEmpty() ) {
				value->append( *ports );
				option_values->append( ports );
				values->append( value );
			}
		} else if ( option == "udp_dest_multiport" ) {
			ports = cmds.at( 0 );
			if ( !ports->isEmpty() ) {
				value->append( *ports );
				option_values->append( ports );
				values->append( value );
			}
		} else if ( option == "tcp_equal_multiport" ) {
			ports = cmds.at( 0 );
			if ( !ports->isEmpty() ) {
				value->append( *ports );
				option_values->append( ports );
				values->append( value );
			}
		} else if ( option == "udp_equal_multiport" ) {
			ports = cmds.at( 0 );
			if ( !ports->isEmpty() ) {
				value->append( *ports );
				option_values->append( ports );
				values->append( value );
			}
		} else if ( option == "frag" ) {
			//    		QString* ports = new QString("");
			if ( !cmds.isEmpty() ) {
				QString * neg = cmds.at( 0 );
				if ( !neg->isEmpty() ) {
					value->append( *neg );
					value->append( " " );
					const QString* nega = new QString( "! " );
					option_values->append( nega );
				}
			}
			value->append( " --fragment" );
			values->append( value );
		} else if ( option == "tos" ) {
			ports = cmds.at( 0 );
			if ( !ports->isEmpty() ) {
				if ( cmds.count() > 1 ) {
					neg = cmds.at( 1 );
					value->append( "! " );
					const QString* nega = new QString( "! " );
					option_values->append( nega );
				}
				value->append( "--tos " );
				value->append( *ports );
				option_values->append( ports );
				values->append( value );
			}
		} else if ( option == "icmp" ) {
			ports = cmds.at( 0 );
			if ( !ports->isEmpty() ) {
				value->append( " --icmp-type " );
				value->append( *ports );
				option_values->append( ports );
				values->append( value );
			}
		} else if ( option == "all_prot" ) {
			value->append( " all" );
			values->append( value );
		}
		used_options.insert( option, values );
		option_list.append( option_values );
		return true;
	}
	return false;
}

bool IPTRule::addTargetOption( QString& par_name, QPtrList<QString>& cmds ) {
	kdDebug() << "IPTRule::addTargetOption(QPtrList&,QPtrList&)" << endl;
	QString option;
	option = par_name;
	kdDebug() << "Try to insetrt target option " << option << " Option." << endl;

	if ( !target_option_list.isEmpty() ) {
		for ( uint i = 0;i < target_option_list.count();i++ ) {
			QPtrList<QString>* vals = target_option_list.at( i );
			if ( vals->count() > 0 ) {
				QString * opt = vals->at( 0 );
				if ( *opt == par_name ) {
					target_option_list.remove( i );
					used_target_options.remove( par_name );
					kdDebug() << "Removed old " << par_name << " Option" << endl;
				}
			}
		}
	}

	QString* cmd = new QString();
	cmd = available_target_options.find( option );
	if ( cmd ) {
		QPtrList<QString>* values = new QPtrList<QString>;
		QPtrList<QString>* option_values = new QPtrList<QString>;

		QString* opt_cmd = new QString( *cmd );
		QString* level = new QString( "" );
		QString* value = new QString( "" );

		values->append( opt_cmd );
		const QString* op = new QString( option );
		option_values->append( op );

		int num = cmds.count();

		if ( option == "custom_option" ) {
			level = cmds.at( 0 );
			if ( !level->isEmpty() ) {
				value->append( *level );
				option_values->append( level );
				values->append( value );
			}
		} else if ( option == "log_level" ) {
			level = cmds.at( 0 );
			if ( !level->isEmpty() ) {
				value->append( *level );
				option_values->append( level );
				values->append( value );
			}
		} else if ( option == "log_prefix" ) {
			level = cmds.at( 0 );
			if ( !level->isEmpty() ) {
				value->append( *level );
				option_values->append( level );
				values->append( value );
			}
		} else if ( option == "log_tcp_seq" ) {
			level = cmds.at( 0 );
			if ( !level->isEmpty() ) {
				value->append( *level );
				option_values->append( level );
				values->append( value );
			}
		} else if ( option == "log_tcp_options" ) {
			level = cmds.at( 0 );
			if ( !level->isEmpty() ) {
				value->append( *level );
				option_values->append( level );
				values->append( value );
			}
		} else if ( option == "log_ip_options" ) {
			level = cmds.at( 0 );
			if ( !level->isEmpty() ) {
				value->append( *level );
				option_values->append( level );
				values->append( value );
			}
		} else if ( option == "snat" ) {
			if ( num == 1 ) {
				level = cmds.at( 0 );
				if ( !level->isEmpty() ) {
					value->append( *level );
					option_values->append( level );
					values->append( value );
				}
			} else if ( num == 2 ) {
				level = cmds.at( 0 );
				if ( !level->isEmpty() ) {
					value->append( *level );
					option_values->append( level );
					values->append( value );
				}
				level = cmds.at( 1 );
				if ( !level->isEmpty() ) {
					value = new QString( "" );
					value->append( ":" );
					value->append( *level );
					option_values->append( level );
					values->append( value );
				}
			}
			kdDebug() << endl;
		} else if ( option == "dnat" ) {
			if ( num == 1 ) {
				level = cmds.at( 0 );
				if ( !level->isEmpty() ) {
					value->append( *level );
					option_values->append( level );
					values->append( value );
				}
			} else if ( num == 2 ) {
				level = cmds.at( 0 );
				if ( !level->isEmpty() ) {
					value->append( *level );
					option_values->append( level );
					values->append( value );
				}
				level = cmds.at( 1 );
				if ( !level->isEmpty() ) {
					value = new QString( "" );
					value->append( ":" );
					value->append( *level );
					option_values->append( level );
					values->append( value );
				}
			}
			kdDebug() << endl;
		} else if ( option == "set_tos" ) {
			level = cmds.at( 0 );
			if ( !level->isEmpty() ) {
				value->append( *level );
				option_values->append( level );
				values->append( value );
			}
			kdDebug() << endl;
		} else if ( option == "reject_type" ) {
			level = cmds.at( 0 );
			if ( !level->isEmpty() ) {
				value->append( *level );
				option_values->append( level );
				values->append( value );
			}
			kdDebug() << endl;
		} else if ( option == "set_mark" ) {
			level = cmds.at( 0 );
			if ( !level->isEmpty() ) {
				value->append( *level );
				option_values->append( level );
				values->append( value );
			}
			kdDebug() << endl;
		}
		used_target_options.insert( option, values );
		target_option_list.append( option_values );
		return true;
	}
	return false;
}

bool IPTRule::delRuleOption( const QString& opt_name ) {
	kdDebug() << "IPTRule::delRuleOption(QString& opt_name)" << endl;
	kdDebug() << "Try to delete Option: " << opt_name << " in Rule: " << m_name << endl;

	if ( !option_list.isEmpty() ) {
		for ( uint i = 0;i < option_list.count();i++ ) {
			QPtrList<QString>* vals = option_list.at( i );
			if ( vals->count() > 0 ) {
				QString * opt = vals->at( 0 );
				//     	  kdDebug() << "Found Option " << opt_name << " in Rule: " << m_name << endl;

				if ( *opt == opt_name ) {
					option_list.remove( i );
					kdDebug() << "Deleting " << opt_name << " Option" << "in Rule: " << m_name << endl;
					used_options.remove( opt_name );
				}
			}
		}
		return true;
	}
	return false;
}

bool IPTRule::delTargetOption( const QString& opt_name ) {
	kdDebug() << "IPTRule::delTargetOption(int index)" << endl;
	if ( !target_option_list.isEmpty() ) {
		for ( uint i = 0;i < target_option_list.count();i++ ) {
			QPtrList<QString>* vals = target_option_list.at( i );
			if ( vals->count() > 0 ) {
				QString * opt = vals->at( 0 );
				//     	  kdDebug() << "Found Option " << opt_name << " in Rule: " << m_name << endl;

				if ( *opt == opt_name ) {
					target_option_list.remove( i );
					kdDebug() << "Deleting " << opt_name << " Option" << "in Rule: " << m_name << endl;
					used_target_options.remove( opt_name );
				}
			}
		}
		return true;
	}
	return false;
}

void IPTRule::cmdString_loop( QString find, bool target ) {
	QPtrList<QString>* opts = new QPtrList<QString>;

	if ( !target )
		opts = used_options.find( find );
	else
		opts = used_target_options.find( find );

	if ( opts ) {
		for ( uint i = 0;i < opts->count();i++ ) {
			opt = *opts -> at( i );
			option_cmd.append( opt );
			//  		kdDebug() << "Option String = " << *opt << endl;
			option_cmd. append( ws );
		}
	}
}

const QString& IPTRule::cmdString() {
	option_cmd = "";

//  if ( customRule() ) {
//  	if ( m_log_rule ) {
//			option_cmd.append( ipt_cmd ); // $IPT
//			option_cmd.append( ws );
//			option_cmd.append( tab );  // -t
//			option_cmd.append( ws );
//			option_cmd.append( m_table->name() ); // <TABLE>
//			option_cmd.append( ws );
//			option_cmd.append( ap ); // -A
//			option_cmd.append( ws );
//			option_cmd.append( m_chain->name() ); // <CHAIN>
//			option_cmd.append( ws );
//
//			opt = "";
//			cmdString_loop( "custom_option", false );
//			option_cmd. append( post );
//			option_cmd. append( ws );
//			option_cmd. append( "LOG" );
//			option_cmd. append( " --log-prefix \"Rule " + m_name + ": \"\n" );
//		}
//
//		option_cmd.append( ipt_cmd ); // $IPT
//		option_cmd.append( ws );
//		option_cmd.append( tab );  // -t
//		option_cmd.append( ws );
//		option_cmd.append( m_table->name() ); // <TABLE>
//		option_cmd.append( ws );
//		option_cmd.append( ap ); // -A
//		option_cmd.append( ws );
//		option_cmd.append( m_chain->name() ); // <CHAIN>
//		option_cmd.append( ws );
//
//		opt = "";
//
//		cmdString_loop( "custom_option", false );
//
//		option_cmd. append( post );
//		option_cmd. append( ws );
//		option_cmd. append( m_target );
//		option_cmd. append( ws );
//
//    QPtrList<QString>* opts2 = new QPtrList<QString>;
//
//		opts2 = new QPtrList<QString>;
//		opts2 = used_target_options.find( "custom_option" );
//		if ( opts2 ) {
//			for ( uint i = 0;i < opts2->count();i++ ) {
//				opt = *opts2 -> at( i );
//				option_cmd. append( opt );
//				//        kdDebug() << "Option String = " << opt << endl;
//				if ( i < 1 )
//					option_cmd.append( ws );
//			}
//		}
//
//    return *( new QString( option_cmd ) );
//	}

	


	/* 	If the logging is enabled we simply generate an rule
			ident to the normal command but with LOG as target
	*/
	if ( m_log_rule ) {
		option_cmd.append( ipt_cmd ); // $IPT
		option_cmd.append( ws );
		option_cmd.append( tab );  // -t
		option_cmd.append( ws );
		option_cmd.append( m_table->name() ); // <TABLE>
		option_cmd.append( ws );
		option_cmd.append( ap ); // -A
		option_cmd.append( ws );
		option_cmd.append( m_chain->name() ); // <CHAIN>
		option_cmd.append( ws );

		// Start getting options+++++++++++++++++++++++++++++
		//		QPtrList<QString>* opts = new QPtrList<QString>;
		opt = "";

		cmdString_loop( "src_ip", false );
		cmdString_loop( "dest_ip", false );

		cmdString_loop( "in_int", false );
		cmdString_loop( "out_int", false );

		cmdString_loop( "tcp", false );
		cmdString_loop( "tcp_src_multiport", false );
		cmdString_loop( "tcp_dest_multiport", false );
		cmdString_loop( "tcp_equal_multiport", false );

		cmdString_loop( "udp", false );
		cmdString_loop( "udp_src_multiport", false );
		cmdString_loop( "udp_dest_multiport", false );
		cmdString_loop( "udp_equal_multiport", false );

		cmdString_loop( "icmp", false );
		cmdString_loop( "all_prot", false );

		cmdString_loop( "mac", false );
		cmdString_loop( "limit", false );
		cmdString_loop( "state", false );
		cmdString_loop( "frag", false );
		cmdString_loop( "tos", false );
		cmdString_loop( "custom_option", false );


		// end options /////////////////////////////////////////////
		option_cmd. append( post );
		option_cmd. append( ws );
		option_cmd. append( "LOG" );
		option_cmd. append( " --log-prefix \"Rule " + m_name + ": \"\n" );
	}

	option_cmd.append( ipt_cmd ); // $IPT
	option_cmd.append( ws );
	option_cmd.append( tab );  // -t
	option_cmd.append( ws );
	option_cmd.append( m_table->name() ); // <TABLE>
	option_cmd.append( ws );
	option_cmd.append( ap ); // -A
	option_cmd.append( ws );
	option_cmd.append( m_chain->name() ); // <CHAIN>
	option_cmd.append( ws );

	// Start getting options+++++++++++++++++++++++++++++
	QPtrList<QString>* opts = new QPtrList<QString>;
	opt = "";

	cmdString_loop( "src_ip", false );
	cmdString_loop( "dest_ip", false );

	cmdString_loop( "in_int", false );
	cmdString_loop( "out_int", false );

	cmdString_loop( "tcp", false );
	cmdString_loop( "tcp_src_multiport", false );
	cmdString_loop( "tcp_dest_multiport", false );
	cmdString_loop( "tcp_equal_multiport", false );

	cmdString_loop( "udp", false );
	cmdString_loop( "udp_src_multiport", false );
	cmdString_loop( "udp_dest_multiport", false );
	cmdString_loop( "udp_equal_multiport", false );

	cmdString_loop( "icmp", false );
	cmdString_loop( "all_prot", false );

	cmdString_loop( "mac", false );
	cmdString_loop( "limit", false );
	cmdString_loop( "state", false );
	cmdString_loop( "frag", false );
	cmdString_loop( "tos", false );
	cmdString_loop( "custom_option", false );


	// end options /////////////////////////////////////////////
	option_cmd. append( post );
	option_cmd. append( ws );
	option_cmd. append( m_target );
	option_cmd. append( ws );
	// beging target options //////////////////////////////////
	if ( m_target == "LOG" ) {
		cmdString_loop( "log_level", true );
		cmdString_loop( "log_prefix", true );
		cmdString_loop( "log_tcp_seq", true );
		cmdString_loop( "log_tcp_options", true );
		cmdString_loop( "log_ip_options", true );
	}
	if ( m_target == "SNAT" ) {
		opts = new QPtrList<QString>;
		opts = used_target_options.find( "snat" );
		if ( opts ) {
			for ( uint i = 0;i < opts->count();i++ ) {
				opt = *opts -> at( i );
				option_cmd. append( opt );
				//        kdDebug() << "Option String = " << opt << endl;
				if ( i < 1 )
					option_cmd.append( ws );
			}
		}
	}
	if ( m_target == "DNAT" ) {
		opts = new QPtrList<QString>;
		opts = used_target_options.find( "dnat" );
		if ( opts ) {
			for ( uint i = 0;i < opts->count();i++ ) {
				opt = *opts -> at( i );
				option_cmd. append( opt );
				//        kdDebug() << "Option String = " << opt << endl;
				if ( i < 1 )
					option_cmd. append( ws );
			}
		}
	}
	if ( m_target == "TOS" ) {
		opts = new QPtrList<QString>;
		opts = used_target_options.find( "set_tos" );
		if ( opts ) {
			for ( uint i = 0;i < opts->count();i++ ) {
				opt = *opts -> at( i );
				option_cmd. append( opt );
				//        kdDebug() << "Option String = " << opt << endl;
				if ( i < 1 )
					option_cmd. append( ws );
			}
		}
	}
	if ( m_target == "REJECT" ) {
		opts = new QPtrList<QString>;
		opts = used_target_options.find( "reject_type" );
		if ( opts ) {
			for ( uint i = 0;i < opts->count();i++ ) {
				opt = *opts -> at( i );
				option_cmd.append( opt );
				//        kdDebug() << "Option String = " << opt << endl;
				if ( i < 1 )
					option_cmd.append( ws );
			}
		}
	}
	if ( m_target == "MARK" ) {
		opts = new QPtrList<QString>;
		opts = used_target_options.find( "set_mark" );
		if ( opts ) {
			for ( uint i = 0;i < opts->count();i++ ) {
				opt = *opts -> at( i );
				option_cmd.append( opt );
				//        kdDebug() << "Option String = " << opt << endl;
				if ( i < 1 )
					option_cmd.append( ws );
			}
		}
	}
	opts = new QPtrList<QString>;
	opts = used_target_options.find( "custom_option" );
	if ( opts ) {
		for ( uint i = 0;i < opts->count();i++ ) {
			opt = *opts -> at( i );
			option_cmd.append( opt );
			//        kdDebug() << "Option String = " << opt << endl;
			if ( i < 1 )
				option_cmd.append( ws );
		}
	}




	// end target options    //////////////////////////////////

	//	kdDebug() << "Rule Cmd Line for Rule "<< m_name << ": " << *option_cmd << endl;
	return *( new QString( option_cmd ) );
}

IPTRule* IPTRule::createRuleClone() {
	kdDebug() << "IPTRule& IPTRule::createRuleClone()" << endl;
	QString na = name();
	if ( na.length() > 15 ) {
		na = na.left( 15 ) ;
	}
	QString new_rule_name = i18n( "%1_Copy" ).arg( na );
	IPTRule *new_rule = new IPTRule( new_rule_name, chain(), target() );
  new_rule->setCustomRule(m_custom_rule);
  new_rule->setDescription( description() );
  new_rule->setLogging( logging() );
  new_rule->setEnabled( enabled() );
	QPtrList<QString>* curr_option;
	for ( curr_option = option_list.first(); curr_option; curr_option = option_list.next() ) {
		QString opt_name = *curr_option->at( 0 );
		//		kdDebug() << "Option Name: " << opt_name << endl;
		QPtrList<QString> *opt_values = new QPtrList<QString>;
		if ( option_list.count() > 0 ) {
			for ( uint j = 1; j < curr_option->count(); j++ ) {
				QString *curr_val = new QString( *curr_option->at( j ) );
				opt_values->append( curr_val );
			}
			new_rule->addRuleOption( opt_name, *opt_values );
		}
	}
	QPtrList<QString>* curr_option2;
	for ( curr_option2 = target_option_list.first(); curr_option2; curr_option2 = target_option_list.next() ) {
		QString opt_name = *curr_option2->at( 0 );
		//		kdDebug() << "Option Name: " << opt_name << endl;
		QPtrList<QString> *opt_values = new QPtrList<QString>;
		if ( target_option_list.count() > 0 ) {
			for ( uint j = 1; j < curr_option2->count(); j++ ) {
				QString *curr_val = new QString( *curr_option2->at( j ) );
				opt_values->append( curr_val );
			}
			new_rule->addTargetOption( opt_name, *opt_values );
		}
	}
	return new_rule;
}


void IPTRule::setUpKnownRules() {
	// ALL MATCH OPTIONS
	// IP Options
	// SRC-IP
	available_options.insert( "src_ip", new QString( "--source" ) );
	// DEST-IP
	available_options.insert( "dest_ip", new QString( "--destination" ) );
	// Interface Options
	// Incoming interface
	available_options.insert( "in_int", new QString( "--in-interface" ) );
	// Outgoing interface
	available_options.insert( "out_int", new QString( "--out-interface" ) );
	// Protocol based
	// All
	available_options.insert( "all_prot", new QString( "--protocol" ) );
	// TCP
	available_options.insert( "tcp", new QString( "--protocol tcp" ) );
	// UDP
	available_options.insert( "udp", new QString( "--protocol udp" ) );
	// ICMP
	available_options.insert( "icmp", new QString( "--protocol icmp " ) );
	// MAC
	available_options.insert( "mac", new QString( "--match mac" ) );
	// LIMIT
	available_options.insert( "limit", new QString( "--match limit" ) );
	// TCP_SRC_MULTIPORT
	available_options.insert( "tcp_src_multiport", new QString( "--protocol tcp --match multiport --source-port" ) );
	// TCP_DEST_MULTIPORT
	available_options.insert( "tcp_dest_multiport", new QString( "--protocol tcp --match multiport --destination-port" ) );
	// UDP_SRC_MULTIPORT
	available_options.insert( "udp_src_multiport", new QString( "--protocol udp --match multiport --source-port" ) );
	// UDP_DEST_MULTIPORT
	available_options.insert( "udp_dest_multiport", new QString( "--protocol udp --match multiport --destination-port" ) );
	// TCP_EQUAL_MULTIPORT
	available_options.insert( "tcp_equal_multiport", new QString( "--protocol tcp --match multiport --port" ) );
	// UDP_EQUAL_MULTIPORT
	available_options.insert( "udp_equal_multiport", new QString( "--protocol udp --match multiport --port" ) );
	// STATE
	available_options.insert( "state", new QString( "--match state" ) );
	// Fragmentation
	available_options.insert( "frag", new QString( "" ) );
	// TOS
	available_options.insert( "tos", new QString( "--match tos" ) );
	// Custom Option
	available_options.insert( "custom_option", new QString( "" ) );
	// ALL TARGET OPTIONS
	// available_target_options = new QDict<QString>;

	//  -j LOG <option>
	// log level
	available_target_options.insert( "log_level", new QString( "--log-level" ) );
	// log prefix
	available_target_options.insert( "log_prefix", new QString( "--log-prefix" ) );
	// log TCP sequebce
	available_target_options.insert( "log_tcp_seq", new QString( "--log-tcp-secquence" ) );
	// log TCP options
	available_target_options.insert( "log_tcp_options", new QString( "--log-tcp-options" ) );
	// log IP options
	available_target_options.insert( "log_ip_options", new QString( "--log-ip-options" ) );
	//  -j MARK <option>
	// set mark
	available_target_options.insert( "set_mark", new QString( "--set-mark" ) );
	//  -j REJECT <option>
	// reject with type
	available_target_options.insert( "reject_type", new QString( "--reject-with" ) );
	//  -j TOS <option>
	// log level
	available_target_options.insert( "set_tos", new QString( "--set-tos" ) );
	//  -j SNAT <option>
	// SNAT
	available_target_options.insert( "snat", new QString( "--to-source" ) );
	//  -j DNAT <option>
	// DNAT
	available_target_options.insert( "dnat", new QString( "--to-destination" ) );
	//  -j MASQUERADE <option>
	// MASQUERADE
	available_target_options.insert( "masq_to_ports", new QString( "--to-ports" ) );
	// initialise some Variables
  // custom option
	available_target_options.insert( "custom_option", new QString( "" ) );
	// initialise some Variables

}
