/***************************************************************************
                    iptruleoption.cpp  -  description
                       -------------------
begin                : Mon Feb 4 2002
copyright            : (C) 2002 by Christian Hubinger
email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "iptruleoption.h" 
// KDE
#include <kdebug.h>
#include <klocale.h>

// QT
#include <qdom.h>

// PROJECT
#include "kmfdoc.h"

// #include <kmfeditcmd.h>
QDict<QStringList>* IPTRuleOption::m_dict_option_strings = new QDict<QStringList>;
QDict<QStringList>* IPTRuleOption::m_dict_gui_strings = new QDict<QStringList>;
QPtrList<QString>* IPTRuleOption::m_known_types = new QPtrList<QString>;
bool IPTRuleOption::m_created_dict = false;

IPTRuleOption::IPTRuleOption(  IPTRule* rule  ) : NetfilterObject( rule ) {
	if ( rule != 0 ) {
		kdDebug() << "IPTRuleOption::IPTRuleOption(..): Creating new IPTRuleOption" << endl;
		m_object_type = NetfilterObject::RULEOPTION;
		m_rule = rule;
		m_parent = rule;
		m_option_type = "UNDEFINED";
// 		m_used = false;
		m_max_undos = 10;
		m_rule_id = -1;
		m_target_option = false;
		m_dict_option_strings->setAutoDelete( true );
		m_known_types->setAutoDelete( true );
		for ( int i = 0; i < MAXOPTNUM;i++ )
			m_values[ i ] = "UNDEFINED";

		createOptionDict();  // Initialise Dict on first use

	}
}

IPTRuleOption::~IPTRuleOption() {
// 	delete m_values;
}

void IPTRuleOption::changed() {
	m_rule->changed( m_object_id );
}


void IPTRuleOption::setOptionType( const QString& type ) {
	if ( type.isNull() )
		return ;
	m_option_type = type;
	kdDebug() << "Setting Object Type: " << m_option_type << endl;
}

void IPTRuleOption::setTargetOption( bool is_tg_opt ) {
	m_target_option = is_tg_opt;
}

void IPTRuleOption::reset() {
	for ( int i = 0; i < MAXOPTNUM;i++ )
		m_values[ i ] = "UNDEFINED";
	changed();
}

bool IPTRuleOption::isEmpty() {
	for ( int i = 0; i < MAXOPTNUM ;i++ ) {
// 		kdDebug() << "Curr opt: " << m_values[ i ] << endl;
		if ( !m_values[ i ].isEmpty() && m_values[ i ] != "UNDEFINED" && m_values[ i ] != ""  && m_values[ i ] != "bool:off" && m_values[ i ] != " "  ) {
// 			kdDebug() << "Curr opt: " << getOptionType() << " is not empty found Value: "<< m_values[ i ]  << endl;
			return false;
		}
	}
// 	kdDebug() << "Curr opt: " << getOptionType() << " is empty!" << endl;
	return true;
}

void IPTRuleOption::loadXML( const QDomDocument& doc ) {
	//	kdDebug() << "const QString& IPTRuleOption::restoreState( )\nXML INPUT: "<< xml << endl;
	QDomElement root = doc.documentElement();
	QString new_opt_type = root.toElement().attribute( "type" );
	if ( m_option_type == "UNDEFINED" ) {
// 		kdDebug() << "IPTRuleOption::restoreState: Setting Option Type: " << new_opt_type << endl;
		m_option_type = new_opt_type;
	}
	if ( m_option_type == new_opt_type )
		kdDebug() << "Found Option Type: " << m_option_type << endl;

	QString tmp = root.toElement().attribute( "targetoption" );
	if ( tmp == "yes" )
		setTargetOption( true );
	else
	setTargetOption( false );

	QDomNode curr = root.firstChild();
	while ( !curr.isNull() ) {
		if ( curr.isElement() ) {
			if ( curr.nodeName() == "ruleoptionvalue" ) {
				for ( int i = 0; i < MAXOPTNUM;i++ ) {
					QDomText textChild = curr.firstChild().toText();
					QString attrib = QString( "value%1" ).arg( i );
					QString val = curr.toElement().attribute( attrib );

					if ( !val.isEmpty() && val != "UNDEFINED" ) {
						m_values[ i ] = val;
						//            kdDebug() << "Found Option Value: " << m_values[i] << endl;
					}
				}
			}
		}
		curr = curr.nextSibling();
	}
	changed();
}

void IPTRuleOption::setRule( int id ) {
	m_rule_id = id;
}


void IPTRuleOption::loadValues( QStringList args ) {
	for ( uint i = 0; i < MAXOPTNUM; i++ )
		m_values[ i ] = "UNDEFINED";
	int i = 0;
	for ( QStringList::Iterator it = args.begin(); it != args.end(); ++it ) {
		m_values[ i ] = *it;
		kdDebug() << "+ Inserted Option Argument Nr: " << i << " value: " << m_values[ i ] << endl;
		i++;
	}
	changed();
}

const QStringList& IPTRuleOption::getValues() {
// 	kdDebug() << "const QStringList& IPTRuleOption::getValues()" << endl;
	QStringList vals;
	for ( uint i = 0; i < MAXOPTNUM; i++ ){
		QString val =m_values[ i ];
// 		kdDebug() << "Append Value: "  <<  val << endl;
		vals << val;
	}
	return *( new QStringList( vals ) );
}


const QDomDocument& IPTRuleOption::getDOMTree() {
	kdDebug() << "const QString& IPTRuleOption::getDOMTree( )" << endl;
	QDomDocument doc;
	if ( isEmpty() )
		return *( new QDomDocument( doc ) );

	bool found = false;
	for ( uint i = 0; i < MAXOPTNUM; i++ )
		if ( !m_values[ i ].isEmpty() && m_values[ i ] != "UNDEFINED" )
			found = true;
	if ( true ) {
		QDomElement root = doc.createElement( "ruleoption" );
		root.setAttribute( "type", m_option_type );
		if ( m_target_option )
			root.setAttribute( "targetoption", "yes" );
		else
			root.setAttribute( "targetoption", "no" );

		root.setAttribute( "id", m_object_id );
		kdDebug() << "Root Element Should be: ruleoption" << endl;
		kdDebug() << "Root Element: " << root.tagName() << endl;
		doc.appendChild( root );
		//  kdDebug() << "Storing: " << m_values->length() << " values" << endl;
		for ( uint i = 0; i < MAXOPTNUM; i++ ) {
			QString val = m_values[ i ];
			if ( !val.isEmpty() && val != "UNDEFINED" ) {
				QDomElement tag = doc.createElement( "ruleoptionvalue" );
				tag.setTagName( "ruleoptionvalue" );
				//			kdDebug() << "Writing Attribute: value" << i << " val: " << val << endl;
				QString attrib = QString( "value%1" ).arg( i );
				tag.setAttribute( attrib, val );
				root.appendChild( tag );
			}
		}
	}
// 	kdDebug() << "XML:\n " << doc.toString() << endl;
	return *( new QDomDocument( doc ) );
}


const QString& IPTRuleOption::toString() {
// 	kdDebug() << "const QString& IPTRuleOption::toString()" << endl;

	QStringList* tmp;
	tmp = m_dict_option_strings->find( m_option_type );
	QString s = "";
	QTextStream str( &s, IO_WriteOnly );
	QString ws = " ";
// 	kdDebug() << "Option: " << m_option_type << " defined " << used << endl;
	if ( tmp && !tmp->isEmpty() ) {
		str << *tmp->at( 0 );
		str << ws;
// 		bool was_modifier = false;
		for ( uint i = 1; i < tmp->count(); i++ ) {
			QString command = *tmp->at( i );
			QString val = m_values[ i - 1 ];
			if ( !val.isEmpty() && val != "UNDEFINED" &&  val != "bool:off") {
// 				if ( was_modifier == false )
//  					str << " \\ \n";

				if ( val == "bool:on") {
					val = "";
// 					was_modifier = true;
				} else {
// 					was_modifier = false;
				}

				str << command;
				str << ws;
				str << val;
				str << ws;
			}
		}
	}
// 	kdDebug() << "Returning String: " << s << endl;

	return *( new QString( s.simplifyWhiteSpace() ) );
}

//############ static members ####################//
QDict<QStringList>* IPTRuleOption::getOptionStringDict() {
	return m_dict_option_strings;
};

QDict<QStringList>* IPTRuleOption::getGUIStringDict() {
	return m_dict_gui_strings;
};

QPtrList<QString>* IPTRuleOption::getAvailableOptionTypes() {
// 	kdDebug() << "QPtrList<QString> IPTRuleOption::getAvailableOptionTypes()" << endl;
	return m_known_types;
};

void IPTRuleOption::registerRuleOption( const QString& type, const QStringList& options, const QStringList& gui_strings ) {
	kdDebug() << "+ Register Rule Option: " << type << endl;

	QStringList *vals = new QStringList();
	for ( uint i = 0; i < options.count(); i ++ ) {
		QString s;
		s = *options.at( i );
		s.simplifyWhiteSpace();
		vals->append(s);
		kdDebug() << "---+ Registering Option String:  " << s << endl;
	}

	QStringList *gui = new QStringList();
	for ( uint i = 0; i < gui_strings.count(); i ++ ) {
		QString s;
		s = *gui_strings.at( i );
		s.simplifyWhiteSpace();
		gui->append(s);
		kdDebug() << "---+ Registering GUI String:  " << s << endl;
	}


	m_dict_option_strings->insert( type, vals );
	m_dict_gui_strings->insert( type, gui );

	m_known_types->append( ( new QString( type ) ) );
	kdDebug() << "+ Testing Key:" << type << endl;
	QStringList* list;
	list = m_dict_option_strings->find( type );
	if ( list ) {
		for ( uint i = 0; i < list->count(); i ++ ) {
			QString s = *list->at( i );
			kdDebug() << "---+ Found Option String:  " << s << endl;
			s = "";
		}
	} else {
		kdDebug() << "!!!!Couldn't fetch QStringList with key: " << type << endl;
	}
}

void IPTRuleOption::createOptionDict() {
// 	kdDebug() << "void IPTRuleOption::createOptionDict()\n" << endl;
	if ( m_created_dict ) {
// 		kdDebug() << "Rule Option Dict allready exists - doing nothing" << endl;
		return ;
	}
	kdDebug() << "######### Start Creating Rule Option Dict ########" << endl;

	// 	const QStringList& list = QStringList::split(  "","--source" ,"--destination");

	//############### Register Options ########################
	// IP src and dest option
	registerRuleOption( "ip_opt",
								QStringList::split( "|", "| --source | --destination", true ),
								QStringList::split( "|",  i18n("IP Address|Src. IP:|Dest. IP:"), true ) );

	// Mac option
	registerRuleOption( "mac_opt",
								QStringList::split( "|", "|--match mac|--mac-source", true ),
								QStringList::split( "|",  i18n("MAC Address||MAC:"), true ));

	registerRuleOption( "interface_opt" ,
								QStringList::split( "|", "|--in-interface|--out-interface", true ),
								QStringList::split( "|", i18n("Network Interface|Incoming Interface:|Outgoing Interface:"), true ));

	registerRuleOption( "state_opt" ,
								QStringList::split( "|", "|--match state| --state", true ),
								QStringList::split( "|", i18n("Stateful Inspection||Match State:"), true ));

	registerRuleOption( "limit_opt" ,
								QStringList::split( "|", "|--match limit|--limit|--limit-burst", true ),
								QStringList::split( "|", i18n("Limit Matches||Limit Matches To:|Set Burst:"), true ));

	registerRuleOption( "tos_opt" ,
								QStringList::split( "|", "|--match tos|--tos", true ),
								QStringList::split( "|", i18n("Match TOS (Type Of Service)|TOS:"), true ));

	registerRuleOption( "tcp_opt" ,
								QStringList::split( "|", "|-p tcp|--source-port|--destination-port|--tcp-flags|--tcp-option", true ),
								QStringList::split( "|", i18n("Protocol TCP||Src. Port:|Dest. Port:|TCP Flags|TCP Option:"), true ));

	registerRuleOption( "udp_opt" ,
								QStringList::split( "|", "|-p udp|--source-port|--destination-port", true ),
								QStringList::split( "|", i18n("Protocol UDP||Src. Port:|Dest. Port:"), true ));

	registerRuleOption( "tcp_multiport_opt" ,
								QStringList::split( "|", "|-p tcp --match multiport|--source-ports|--destination-ports|--equal-ports", true ),
								QStringList::split( "|", i18n("TCP Multiport||Src. Ports:|Dest. Ports:|Equal. Ports:"), true ));

	registerRuleOption( "udp_multiport_opt" ,
								QStringList::split( "|", "|-p udp --match multiport|--source-ports|--destination-ports|--equal-ports", true ),
								QStringList::split( "|", i18n("UDP Multiport||Src. Ports:|Dest. Ports:|Equal. Ports:"), true ));

	registerRuleOption( "icmp_opt" ,
								QStringList::split( "|", "|-p icmp|--icmp-type", true ),
								QStringList::split( "|", i18n("Match ICMP||Type:"), true ));

	registerRuleOption( "all_prot_opt" ,
								QStringList::split( "|", "|-p all", true ),
								QStringList::split( "|", i18n("Match ALL Protocols|"), true ));

	registerRuleOption( "frag_opt" ,
								QStringList::split( "|", "| -f| ! -f", true ),
								QStringList::split( "|", i18n("Match Fragments|Match First Fragment|Match Other Fragments"), true ));

	registerRuleOption( "custom_opt" ,
								QStringList::split( "|", "|", true ),
								QStringList::split( "|", i18n("Custom Option|Option:"), true ));

	//################ Register Target Options ##################
	registerRuleOption( "target_log_opt" ,
								QStringList::split( "|", "|--log-prefix|--log-level|--log-tcp-secquence|--log-tcp-options|--log-ip-options", true ),
								QStringList::split( "|", i18n("Log Options|Log Prefix:|Log Level:|Logging TCP Sequence Numbers|Logging TCP Options|Logging IP Options"), true ));

	registerRuleOption( "target_set_tos_opt" ,
								QStringList::split( "|", "|--set-tos", true ),
								QStringList::split( "|", i18n("Set TOS (Type Of Service)| To TOS:"), true ));

	registerRuleOption( "target_reject_type_opt" ,
								QStringList::split( "|", "|--reject-with", true ),
								QStringList::split( "|", i18n("Reject With ICMP Type|ICMP Type:"), true ));

	registerRuleOption( "target_custom_opt" ,
								QStringList::split( "|", "|", true ),
								QStringList::split( "|", i18n("Custom Option|Custom Target Option:"), true ));

	registerRuleOption( "target_dnat_opt" ,
								QStringList::split( "|", "|--to-destination", true ),
								QStringList::split( "|", i18n("Destination NAT|Translate to Dest.:"), true ));

	registerRuleOption( "target_snat_opt" ,
								QStringList::split( "|", "|--to-source", true ),
								QStringList::split( "|", i18n("Source NAT|Translate to Src.:"), true ));

	registerRuleOption( "target_mark_opt" ,
								QStringList::split( "|", "|--set-mark", true ),
								QStringList::split( "|", i18n("Set Mark|Set Mark Nr.:"), true ));

// 	registerRuleOption( "tcp_opt" , 	QStringList::split( "|", " | -p tcp | --source-port | --destination-port | --tcp-flags | --tcp-option", true ),
// 													QStringList::split( "|", i18n(" Protocol: TCP | -p tcp | Src. Port(s): | Dest. Port(s): | TCP Flags: | TCP Option: "), true ));
/*	registerRuleOption( "udp_opt", QStringList::split( "|", " | -p udp | --source-port | --destination-port", true ) );
	registerRuleOption( "icmp_opt", QStringList::split( "|", " | -p icmp | --icmp-type", true ) );
	registerRuleOption( "int_opt", QStringList::split( "|", "| --in-interface |--out-interface", true ) );
	registerRuleOption( "tcp_mp_opt", QStringList::split( "|", " | -p tcp --match multiport | --source-port | --destination-port | --equal-port", true ) );
	registerRuleOption( "udp_mp_opt", QStringList::split( "|", " | -p tcp --match multiport | --source-port | --destination-port | --equal-port", true ) );*/
	kdDebug() << "######## Finished dict creation ########" << endl;
	m_created_dict = true;
}




