#ifndef KMFLISTVIEWITEM_H
#define KMFLISTVIEWITEM_H

#include "kmflistview.h"

// QT includes
#include <qstring.h>
// KDE includes

// Project includes

/**
@author Christian Hubinger
*/
class IPTable;
class IPTChain;
class IPTRule;
class IPTRuleOption;
class NetfilterObject;

class KMFListViewItem : public KListViewItem {
public:
	KMFListViewItem( KListView *parent, NetfilterObject* );
	KMFListViewItem( KListViewItem *parent, NetfilterObject* );
	KMFListViewItem( KListView *parent, KListViewItem *after, NetfilterObject* );
	KMFListViewItem( KListViewItem *parent, KListViewItem *after, NetfilterObject* );

	virtual ~KMFListViewItem();

	NetfilterObject* netfilterObject() const;

	IPTable* table()  const {
		return m_table;
	};
	IPTChain* chain() const {
		return m_chain;
	};
	IPTRule* rule() const {
		return m_rule;
	};
	IPTRuleOption* ruleOption() const {
		return m_option;
	};
	bool isTopItem() const {
		return m_top;
	};
	int type() const {
		return m_type;
	}

	int objectID() const {
		return m_obj_id;
	}
	void deleteChildren();
	void setChildrenInUse( bool );
	void setTopItem( bool );
	void setInUse( bool );
	bool inUse();
	enum { TABLE = 0, CHAIN = 1, RULE = 2, RULEOPTION = 3 };

	void loadNetfilterObject( NetfilterObject* );
	QString key( int column, bool ascending ) const;

private:
	IPTable *m_table;
	IPTChain *m_chain;
	IPTRule *m_rule;
	IPTRuleOption *m_option;
	int m_type;
	int m_obj_id;
	bool m_top;
	bool m_inUse;
};

#endif
