/***************************************************************************
                       kmfnewchaindlg.cpp  -  description
                          -------------------
 begin                : Sat Mar 9 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfnewchaindlg.h"

// qt includes
#include <qstring.h>
#include <qmessagebox.h>
#include <qradiobutton.h>
#include <qlineedit.h>

// kde includes
#include <klocale.h>
#include <kdebug.h>
#include <kmessagebox.h>

// my includes
#include "../core/kmfdoc.h"
#include "../core/kmferror.h"
#include "../core/kmferrorhandler.h"
#include "../core/kmfcheckinput.h"

KMFNewChainDlg::KMFNewChainDlg( QWidget *parent, const char *name, bool modal, WFlags fl ) : KMyFirewallChainEditorNewChain( parent, name, modal, fl ) {
	kmfdoc = 0;
}

KMFNewChainDlg::~KMFNewChainDlg() {}
void KMFNewChainDlg::loadDoc( KMFDoc* doc ) {
	kmfdoc = doc;
}
/** No descriptions */
void KMFNewChainDlg::accept() {
	KMFError * err = new KMFError();
	KMFErrorHandler* err_handler = new KMFErrorHandler( "KMFNewChainDlg" );
	KMFCheckInput* check_input = new KMFCheckInput();
	if ( kmfdoc == 0 ) {
		KMessageBox::error( 0, i18n( "KMFNewChainDlg: kmfdoc = 0. This happened because of a bug." ), i18n( "Error" ) );
		return ;
	}
	QStringList StringList;
	QString name = t_name->text();
	QString target = "DROP";

	err = check_input->checkInput( name, "CHAINNAME" );
	if ( !err_handler->showError( err ) ) {
		return ;
	}

	if ( !name.isEmpty() ) {
		if ( c_filter->isChecked() ) {
			QString table = "filter";
			err = kmfdoc->addChain( name, table, target, false );
			if ( err_handler->showError( err ) ) {
				kmfdoc->changed();
				emit documentChanged( kmfdoc );
			}
			QDialog::accept();
		}
		if ( c_nat->isChecked() ) {
			QString table = "nat";
			err = kmfdoc->addChain( name, table, target, false );
			if ( err_handler->showError( err ) ) {
				kmfdoc->changed();
				emit documentChanged( kmfdoc );
			}
			QDialog::accept();
		}
		if ( c_mangle->isChecked() ) {
			QString table = "mangle";
			err = kmfdoc->addChain( name, table, target, false );
			if ( err_handler->showError( err ) ) {
				kmfdoc->changed();
				emit documentChanged( kmfdoc );
			}
			QDialog::accept();
		}
	} else {
		KMessageBox::sorry( 0, i18n( "You must set a name for your chain." ), i18n( "Warning" ) );
		QDialog::accept();
		return ;
	}

}


#include "kmfnewchaindlg.moc"
