/***************************************************************************
                        kmfruleeditorprotocol.h  -  description
                           -------------------
  begin                : Fri Nov 1 2002
  copyright            : (C) 2002 by Christian Hubinger
  email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFRULEEDITORPROTOCOL_H
#define KMFRULEEDITORPROTOCOL_H

#include <qwidget.h>
#include <kmyfirewallruleeditorprotocol.h>
#include <qptrlist.h>

/**
  *@author Christian Hubinger
  */
class KMFMultiPortWidget;
class KMFPortWidget;
class IPTRule;
class QString;

class KMFRuleEditorProtocol : public KMyFirewallRuleEditorProtocol {
	Q_OBJECT
public:
	KMFRuleEditorProtocol( QWidget *parent = 0, const char *name = 0, WFlags fl = 0 );
	~KMFRuleEditorProtocol();

	void loadRule( IPTRule* rule );
private slots:
	void toggleMultiPort( bool );
	void toggleUdpRule( bool );
	void toggleIcmpRule( bool );
	void toggleTcpRule( bool );
	void slotHelp();
	void reject();
private:
	KMFMultiPortWidget *mpwid;
	KMFPortWidget *pw_dest_port, *pw_src_port;
	bool multiportEnabled() const ;
	void accept();
signals:
	void sigAddRuleOpt( QString *, QPtrList<QString> * );
	void sigDelRuleOpt( QString * );
	void sigDocumentChanged();
	void sigHideMe();
private:   // data
	bool use_multiport;


};

#endif
