/***************************************************************************
                       kmfruleeditortos.cpp  -  description
                          -------------------
 begin                : Wed Mar 27 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleeditortos.h"

// QT includes
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qstring.h>
#include <qlabel.h>

// kde includes
#include <klocale.h>
#include <kdebug.h>
#include <kapplication.h>

// project includes
#include "../core/iptrule.h"

KMFRuleEditorTos::KMFRuleEditorTos( QWidget *parent, const char *name, WFlags fl ) : KMyFirewallRuleEditorTos( parent, name, fl ) {
	m_option_type = "SETTOS";
}
KMFRuleEditorTos::~KMFRuleEditorTos() {}

void KMFRuleEditorTos::setType( const QString& type ) {
	m_option_type = type;
	if ( m_option_type == "SETTOS" ) {
		c_use_tos->setText( i18n( "Set TOS" ) );
	} else if ( m_option_type == "CHECKTOS" ) {
		c_use_tos->setText( i18n( "Check TOS" ) );
	} else if ( m_option_type == "REJECTTYPE" ) {
		c_use_tos->setText( i18n( "Reject with type:" ) );
	}

}

void KMFRuleEditorTos::loadRule( IPTRule* rule ) {
	kdDebug() << "void KMFRuleEditorTos::loadRule( IPTRule* rule )" << endl;
	curr_rule = rule;
	if ( m_option_type == "SETTOS" ) {
		setItems();
		QPtrList<QPtrList<QString> > opt_list = curr_rule->ruleTargetOptions();
		for ( uint j = 0;j < opt_list.count();j++ ) {
			options = new QPtrList<QString>;
			options = opt_list.at( j );
			if ( options->count() > 1 ) {
				QString * opt = options->at( 0 );
				QString* cmd = options->at( 1 );
				if ( *opt == "set_tos" ) {
					c_use_tos->setChecked( true );
					int index = getItemNum( *cmd );
					if ( index > 0 )
						cb_tos->setCurrentItem( index );
				}
			}
		}
	} else if ( m_option_type == "CHECKTOS" ) {
		setItems();
		QPtrList<QPtrList<QString> > opt_list = curr_rule->ruleOptions();
		for ( uint j = 0;j < opt_list.count();j++ ) {
			options = new QPtrList<QString>;
			options = opt_list.at( j );
			if ( options->count() > 1 ) {
				QString * opt = options->at( 0 );
				QString* cmd = options->at( 1 );
				if ( *opt == "tos" ) {
					c_use_tos->setChecked( true );
					int index = getItemNum( *cmd );
					if ( index > 0 )
						cb_tos->setCurrentItem( index );
				}
			}
		}
	} else if ( m_option_type == "REJECTTYPE" ) {
		setItems();
		l_header->setText( i18n( "Reject with icmp-type" ) );
		QPtrList<QPtrList<QString> > opt_list = curr_rule->ruleTargetOptions();
		for ( uint j = 0;j < opt_list.count();j++ ) {
			options = new QPtrList<QString>;
			options = opt_list.at( j );
			if ( options->count() > 1 ) {
				QString * opt = options->at( 0 );
				QString* cmd = options->at( 1 );
				if ( *opt == "reject_type" ) {
					c_use_tos->setChecked( true );
					int index = getItemNum( *cmd );
					if ( index > 0 )
						cb_tos->setCurrentItem( index );
				}
			}
		}
	} else {
		kdDebug() << "Misuse of this class no type set !!" << endl;
	}
}

void KMFRuleEditorTos::accept() {
	if ( m_option_type == "SETTOS" ) {
		bool use_tos = c_use_tos->isChecked();
		if ( !use_tos ) {
			QString * del = new QString( "set_tos" );
			emit sigDelTargetOpt( del );
		} else {
			QString* del = new QString( "set_tos" );
			emit sigDelTargetOpt( del );
			QPtrList<QString>* options = new QPtrList<QString>;
			QString* name = new QString( "set_tos" );
			QString* opt = new QString( "" );
			QString val = cb_tos->currentText();
			opt->append( val );
			options->append( opt );
			emit sigAddTargetOpt( name, options );
		}

	} else if ( m_option_type == "CHECKTOS" ) {
		bool use_tos = c_use_tos->isChecked();
		if ( !use_tos ) {
			QString * del = new QString( "tos" );
			emit sigDelRuleOpt( del );
		} else {
			QString* del = new QString( "tos" );
			emit sigDelRuleOpt( del );
			QPtrList<QString>* options = new QPtrList<QString>;
			QString* name = new QString( "tos" );
			QString* opt = new QString( "" );
			QString val = cb_tos->currentText();
			opt->append( val );
			options->append( opt );
			emit sigAddRuleOpt( name, options );
		}
	} else if ( m_option_type == "REJECTTYPE" ) {
		bool use_tos = c_use_tos->isChecked();
		if ( !use_tos ) {
			QString * del = new QString( "reject_type" );
			emit sigDelTargetOpt( del );
		} else {
			QString* del = new QString( "reject_type" );
			emit sigDelTargetOpt( del );
			QPtrList<QString>* options = new QPtrList<QString>;
			QString* name = new QString( "reject_type" );
			QString* opt = new QString( "" );
			QString val = cb_tos->currentText();
			opt->append( val );
			options->append( opt );
			emit sigAddTargetOpt( name, options );
		}
	}
	emit sigDocumentChanged();
	//	QDialog::accept();
}

void KMFRuleEditorTos::setItems() {
	kdDebug() << "void KMFRuleEditorTos::setItems(const QString& type)" << endl;
	cb_tos->clear();
	if ( m_option_type == "SETTOS" || m_option_type == "CHECKTOS" ) {
		cb_tos->insertItem( "Normal-Service" );
		cb_tos->insertItem( "Minimize-Cost" );
		cb_tos->insertItem( "Maximize-Reliability" );
		cb_tos->insertItem( "Maximize-Throughput" );
		cb_tos->insertItem( "Minimize-Delay" );
	} else if ( m_option_type == "REJECTTYPE" ) {
		cb_tos->insertItem( "icmp-port-unreachable" );
		cb_tos->insertItem( "icmp-net-unreachable" );
		cb_tos->insertItem( "icmp-host-unreachable" );
		cb_tos->insertItem( "icmp-proto-unreachable" );
		cb_tos->insertItem( "icmp-net-prohibited" );
		cb_tos->insertItem( "icmp-host-prohibited" );
	}
}

int KMFRuleEditorTos::getItemNum( const QString& option ) {
	kdDebug() << "int KMFRuleEditorTos::getItemNum(const QString& option)" << endl;
	int index = -1;
	for ( int i = 0; i < cb_tos->count(); i++ ) {
		QString tmp_item = cb_tos->text( i );
		if ( tmp_item == option ) {
			index = i;
		}
	}
	return index;
}
void KMFRuleEditorTos::slotHelp() {
	kdDebug() << "void KMFRuleEditorTos::slotHelp()" << endl;
	kapp->invokeHelp( "tos" );
}

void KMFRuleEditorTos::reject() {
	kdDebug() << "void KMFRuleEditorTos::reject()" << endl;
	emit sigHideMe();
}
#include "kmfruleeditortos.moc"
