#include <iostream>
using namespace std;

#include <stdio.h> // for sscanf

#include <klocale.h>
#include "knapster2.h"

#include <qdatetime.h>

//#include <kmainwindow.h>
#include <qbuttongroup.h>
#include <qframe.h>
#include <qpushbutton.h>
#include <qwidgetstack.h>

#include <qwidget.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qlabel.h> 
#include <qsplitter.h> 

#include <qtimer.h> 

#include <kapp.h>
#include <kaction.h>
#include <kstdaction.h>

// the main organiser
#include "knap_buttontabbar.h"

// the pannels
#include "knap_homepanel.h"
#include "knap_searchpanel.h"
#include "knap_librarypanel.h"
#include "knap_transferpanel.h"
#include "knap_hotlistpanel.h"
#include "knap_chanpanel.h"
#include "knap_chatmanagerpanel.h"

// windows that will open
#include "knap_preferencesdlg.h"
#include "knap_whois.h"
#include "knap_napigatordlg.h"
#include "knap_connectdlg.h"
#include "knap_ipaddressdlg.h"

#include "knap_createchandlg.h"
#include "knap_chanlist.h"

#include "knap_preferences.h"

#include "songinfo.h"
#include "support_funcs.h"

// include pixmaps for tab icons
#include "home.xpm"
#include "chat.xpm"
//#include "library.xpm"
#include "mp3.xpm"
#include "search.xpm"
#include "transfer.xpm"
#include "hotlist.xpm"
#include "discover.xpm"

#include <ksystemtray.h>
#include "mini-knapster2.xpm"

#include "napsterdownload1.h"

// added for kde3
#include "kstatusbar.h"
//-

#define UPDATETIME 2

/* 
 *  Constructs a Knapster2 which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
Knapster2::Knapster2(const char * name)
: KMainWindow(0,name)
{
   pinglist.setAutoDelete(true);
   
   channellist = 0;

   connection = 0; 
 
   processeddata = false;
   timeoutcount = 0;
   
   // make it save the window size on exit
   setAutoSaveSettings(name,true);
   
   setupMenus();
   
   statusBar()->show();
   
   statusBar()->insertItem("Connected",1,1);
   statusBar()->insertItem("00000000000 songs",2,1);
   statusBar()->insertItem("0000000 Libraries.",3,1);
   statusBar()->insertItem("Total 00000000000 Gig.",4,2);

   statusBar()->message(i18n("Not connected")); 

   setupTabs();

   QTimer *timer=new QTimer(this);
   if(timer) 
   {
      connect(timer,SIGNAL(timeout()),this,SLOT(timerUpdate()));

      timer->start(UPDATETIME * 1000); // update every 2 seconds
   }  

   // add to the system tray - why? - well why not - it is so easy to do
   KSystemTray *tray = new KSystemTray(this,"knapster");
   tray->setPixmap(QPixmap((const char **)mini_knapster2_xpm));
   tray->setAlignment(Qt::AlignCenter);
   tray->show();

}

/*  
 *  Destroys the object and frees any allocated resources
 */
Knapster2::~Knapster2()
{
   if(connection) delete connection; // not really needed?

   // no need to delete child widgets, Qt does it all for us
   recent->saveEntries(KGlobal::config());
}

void Knapster2::setupMenus()
{
   connmenu = new KAction(i18n("&Connect"),0,this,SLOT ( menuConnect() ),
	 actionCollection(),"login");

   new KAction(i18n("Connect &To..."),0,this,SLOT ( menuConnectTo() ),
	 actionCollection(),"login_to");

   new KAction(i18n("Connect via &Napigator..."),0,this,SLOT ( menuNapigator() ),
	 actionCollection(),"login_napigator");

   KStdAction::quit(kapp, SLOT(closeAllWindows()), actionCollection()); 

   recent =  KStdAction::openRecent( 0,0, actionCollection(),"login_recent");
   recent->loadEntries (KGlobal::config());

   connect(recent,SIGNAL(urlSelected(const KURL &) ),
	 this,SLOT( menuRecent(const KURL &) ));


//   new KAction(i18n("&Preferences"),0,this,SLOT ( menuPreferences() ),
//	 actionCollection(),"preferences");
   KStdAction::preferences(this, SLOT(menuPreferences()), actionCollection());

   new KAction(i18n("&Channels..."),0,this,SLOT ( menuChannels() ),
	 actionCollection(),"show_chanlist");

   new KAction(i18n("Create &New channel..."),0,this,SLOT ( menuCreateChannel() ),
	 actionCollection(),"join_chan");

   createGUI(); // read the resource file
}
void Knapster2::setupTabs()
{
   MainFrame = new KNAP_ButtonTabbar(this,"main");

   tab_0 = new KNAP_HomePanel(MainFrame,"home");
   QPixmap home_pixmap((const char **)home_xpm);
   MainFrame->addTab( tab_0, i18n("Home"),home_pixmap );
   (( KNAP_HomePanel *)tab_0)->loadDefault();

   tab_1 = new KNAP_ChatManagerPanel(MainFrame,"chan");
   QPixmap chat_pixmap((const char **)chat_xpm);
   MainFrame->addTab( tab_1, i18n("Chat"),chat_pixmap );

   KNAP_ChanPanel *chan = ((KNAP_ChatManagerPanel *)tab_1)->findWidget("Console");

   if(chan) connect(chan,SIGNAL( sendcommand(const char *) ),this, SLOT( chatCommand(const char *) ) ); 

   tab_2 = new KNAP_LibraryPanel(MainFrame,"library");

   QPixmap lib_pixmap((const char **)mp3_xpm);
   MainFrame->addTab( tab_2, i18n("Library"),lib_pixmap );

   // go thru share list and add the songs
   ((KNAP_LibraryPanel *)tab_2)->rescan(); 
   
   tab_3 = new KNAP_SearchPanel(MainFrame,"search_panel");
   QPixmap search_pixmap((const char **)search_xpm);
   MainFrame->addTab( tab_3, i18n("Search"),search_pixmap );

   // connect up a few slots from other places
   connect(tab_3,SIGNAL( sendcommand(const char *) ),
	 this,SLOT( chatCommand(const char *) ) );

   tab_4 = new KNAP_HotlistPanel(MainFrame,"hotlist");

   QPixmap hotlist_pixmap((const char **)hotlist_xpm);
   MainFrame->addTab( tab_4, i18n("Hotlist"),hotlist_pixmap );

   connect(tab_4,SIGNAL( sendcommand(const char *) ),
	 this,SLOT( chatCommand(const char *) ) );

   tab_5 = new QFrame(MainFrame,"transfer");

   QGridLayout *grid=new QGridLayout(tab_5,1,1,0,0);

   QSplitter *split
      //tab_5
      = new QSplitter(QSplitter::Vertical,tab_5,"transfer_splitter");
   grid->addWidget(split,0,0); 

   downloadpanel = new KNAP_TransferPanel(split,"download");
   connect(downloadpanel,SIGNAL( sendcommand(const char *) ),
	 this,SLOT( chatCommand(const char *) ) );
   uploadpanel = new KNAP_TransferPanel(split,"upload");
   connect(uploadpanel,SIGNAL( sendcommand(const char *) ),
	 this,SLOT( chatCommand(const char *) ) );

   QPixmap transfer_pixmap((const char **)transfer_xpm);
   MainFrame->addTab( tab_5, i18n("Transfers"),transfer_pixmap );

#ifdef DEVEL_CODE   
   tab_6 = new QWidget( MainFrame, "tab_6" );
   new QLabel("In tab6",tab_6);
   QPixmap discover_pixmap((const char **)discover_xpm);
   MainFrame->addTab( tab_6, i18n("Discover"),discover_pixmap );
#endif
   setCentralWidget(MainFrame);

}
void Knapster2::menuConnectTo()
{
   KNAP_IPAddressDlg addr(this,"Connect-to");
   addr.exec();
   //addr.show();
   
   QString server = addr.getIPAddress();
   
   if(server.length()>0) menuRecent("http://" + server);

}
void Knapster2::menuConnect()
{
   if(connection) 
   {
      // if was connected - then must have been disconnect menuoption chosen
      napsterClosed();
      return;
   }

   SongList slist = ((KNAP_LibraryPanel *)tab_2)->getAllSongs();
   QStringList hotlist = ((KNAP_HotlistPanel *)tab_4)->getUsers(); 

   KNAP_ConnectDlg p(slist,hotlist,this,"Connect");
   //kde3 p.show();
   p.exec();

   connection = p.getConnection();

   postConnect();
}
void Knapster2::menuRecent(const KURL &url)
{
   // a recent connection has been selected
   QString host = url.host() + ":" + QString().setNum(url.port());

   cerr << "Knapster2::menuRecent(): " << host << endl;

   if(connection) 
   {
      napsterClosed();
      return;
   }

   SongList slist = ((KNAP_LibraryPanel *)tab_2)->getAllSongs();
   QStringList hotlist = ((KNAP_HotlistPanel *)tab_4)->getUsers(); 

   KNAP_ConnectDlg p(slist,hotlist,this,"Connect",host);
   //kde3 p.show();
   p.exec();

   connection = p.getConnection();

   postConnect();
}
void Knapster2::menuNapigator()
{
   // get server from napigator and connect
   KNAP_NapigatorDlg p(this,"Napigator",true);
   //kde3 p.show();
   p.exec();
   QString server = p.getSelectedServer();

   cerr << "Knapster2::menuNapigator(): " << server << endl;

   if(server) menuRecent("http://" + server);
}

void Knapster2::postConnect()
{
   processeddata = false;
   timeoutcount = 0;

   if(connection)
   {
      connect(connection,SIGNAL( onClosed() ),this, SLOT( napsterClosed() ) );
      connect(connection,SIGNAL( onTransferConnection(KSocket *,SongInfo *,bool) ),this, 
	    SLOT( napsterTransferStarted(KSocket *,SongInfo *,bool) ));
      connect(connection,SIGNAL( onRead( NAPBLOCKPTR ) ),this, SLOT( napsterMessage( NAPBLOCKPTR ) ) );

      ((KNAP_ChatManagerPanel *)tab_1)->clearChannel("Console"); 

      QString connstr =  QTime::currentTime().toString() + ": " 
          + QString(i18n("Connected to ")) + connection->getIPAddressString() +
	  " as " + connection->getUser();

      ((KNAP_ChatManagerPanel *)tab_1)->writeChannel("Console",connstr,
          KNAP_ChanPanel::MessageNotify);

   // set who we were to channel manager
      ((KNAP_ChatManagerPanel *)tab_1)->setWhoAmI(connection->getUser());

      pinglist.clear();

      recent->addURL(QString("http://") + connection->getIPAddressString() + ":" 
	    + QString().setNum(connection->getIPPort()));

      connmenu->setText(i18n("&Disconnect"));
      // start processing
      connection->receiveData(true);
   }  


}


void Knapster2::menuPreferences()
{
   KNAP_PreferencesDlg p(this,"prefs",true);
   //kde3 p.show();
   p.exec();
}
void Knapster2::menuChannels()
{
   cerr << "Knapster2::menuChannels()\n";

   if(!connection) return;
   
   if(!channellist) 
   {
      channellist = new KNAP_Channellist(this,"chanlist");
      if(channellist)
      {
	 connect(channellist,SIGNAL( sendcommand(const char *) ),this,
	       SLOT( chatCommand(const char *) ));

      }
   }
   if(channellist)
   {
      //channellist->show();
      channellist->show();

      channellist->clear();
      channellist->startChannellist();
      connection->sendChannellist(false);
   }
}

void Knapster2::menuCreateChannel()
{
   cerr << "Knapster2::menuCreateChannel()\n";

   if(!connection) return;
   
   KNAP_CreateChannelDlg p(this,"chanlist");
   //p.show();
   p.exec();
   // getname if there was one
   QString n = p.getChannelName();
   if(n.length()>0)
   {
      chatCommand("/join " + n);
   }
}


void Knapster2::startDownload(SongInfo *si)
{
   cerr << "Knapster2::startDownload(): " 
      << si->filename << " " << si->user << " " << si->ip << ":" << si->port << endl;

  if(!connection) return;
   
   // TODO clear file if we need too
   if(si->port == 0)   
   {
      cerr << "Knapster2::startDownload(): doing new dload request\n";
      connection->sendDownloadRequest2(si->user,si->filename);
   }
   else 
   {
      // TODO make the path work :)
      downloadpanel->startDownload(si,"thefilepathtosave the file to.mp3",
	    connection->getUser());
   }
}
//----------------------------
void Knapster2::napsterTransferStarted(KSocket *sock,SongInfo *song,bool dload)
{
 if(dload)
 {
      cerr << "Knapster2::napsterTransferStarted(): download\n";
// TODO what if we get one of these AFTER connection is closed - ERROR thats what!!!!
      
      downloadpanel->startDownload(sock,song,"thefilepathtosave the file to.mp3",
	    connection->getUser());
 }
 else // an uplaod
 {

      cerr << "Knapster2::napsterTransferStarted(): upload\n";

      uploadpanel->startUpload(sock,song,"thefilepathtosave the file to.mp3",
	    connection->getUser());
 }
}
void Knapster2::napsterClosed()
{

   ((KNAP_ChatManagerPanel *)tab_1)->setOffline();
   ((KNAP_HotlistPanel *)tab_4)->setOffline();

   if(connection) delete connection;
   connection = 0;

   QString msg = QTime::currentTime().toString() + ": " + i18n("Disconnected"); 
   ((KNAP_ChatManagerPanel *)tab_1)->writeChannel("Console",
       msg,
       KNAP_ChanPanel::MessageNotify);

   statusBar()->message(i18n("Not connected"));
   // set menu back to connect
   connmenu->setText(i18n("&Connect"));
}
void Knapster2::napsterMessage(NAPBLOCKPTR msg)
{
   processeddata = true; // mark that we had data

   SongInfo *tmpinfo;
   QString msgstr;

   switch(msg->type) 
   {
      case NAP_ERROR:	
	 if(msg->size>0)
	 { 
	   msgstr = QString("** ") + msg->data;
	   ((KNAP_ChatManagerPanel *)tab_1)->writeError(msgstr);
	 }
	 break;
      case NAP_LOGIN_RESULT:
	 break;
      case NAP_SERVER_STATS:
	 showServerStats(msg); 
	 break;
      case NAP_ADVERTISMENT:
	 {
	    QString tmp = msg->data;
	    QString c = extractString(tmp);
	    QString m = extractString(tmp);

	    ((KNAP_ChatManagerPanel *)tab_1)->writeChannel(c,m);
	    break;
	 }
      case NAP_SYSTEM_MSG:
	 msgstr = QString("* ") +msg->data;
	 ((KNAP_ChatManagerPanel *)tab_1)->writeChannel("Console",msgstr);
	 break;
      case NAP_SEARCH_RESULT:
	 if(msg->size>0) 
	 {
	    tmpinfo=parseSearchBuffer(msg->data);
	    if(tmpinfo) ((KNAP_SearchPanel *)tab_3)->addSearchItem(tmpinfo);
	 }
	 break;
      case NAP_SEARCH_COMPLETE:
	 statusBar()->changeItem( i18n("Connected") ,1);
	 break;
      case NAP_BROWSE_RESULT:
	 if(msg->size>0) 
	 {
	    tmpinfo=parseBrowseBuffer(msg->data);
	    if(tmpinfo) ((KNAP_HotlistPanel *)tab_4)->addSong(tmpinfo);
	 } 
	 break;
      case NAP_BROWSE_COMPLETE:
	 ((KNAP_HotlistPanel *)tab_4)->endSonglist(msg->data); 
	 break;
      case NAP_ERROR_MSG:
	 msgstr = QString("** ") + QTime::currentTime().toString() + ": " + msg->data;
	 ((KNAP_ChatManagerPanel *)tab_1)->writeError(msgstr); 
	 // error
	 break;
      case NAP_HOTLISTUSER_LOGGEDON:
	 {
	    ((KNAP_HotlistPanel *)tab_4)->addUser(msg->data,true);
	    break;
	 }
      case NAP_HOTLISTUSER_LOGGEDOFF:
	 ((KNAP_HotlistPanel *)tab_4)->addUser(msg->data,false); 
	 break;
      case NAP_ADDTOHOTLIST_ERROR:
	 msgstr = QString(i18n("Couldnt add to hot list: ")) + msg->data;
	 ((KNAP_ChatManagerPanel *)tab_1)->writeChannel("Console",
	    msgstr,
	    KNAP_ChanPanel::MessageError);
	 break;
      case NAP_ADDTOHOTLIST_RESULT:
	 ((KNAP_HotlistPanel *)tab_4)->addUser(msg->data,false);
	 break;       
      case NAP_WHOIS_RESULT:
	 {
	    msgstr = msg->data;
	    KNAP_Whois *who = new KNAP_Whois(msgstr);
	    who->show();
	    break;
	 }
      case NAP_CHANLIST_RESULT:
	 if(channellist) channellist->addChannel(msg->data);
	 break;
      case NAP_CHANLIST_COMPLETE:
	 if(channellist) channellist->endChannellist();
	 break;

      case NAP_JOINCHAN_RESULT:
	 {
	    KNAP_ChanPanel *chan = ((KNAP_ChatManagerPanel *)tab_1)->openChatWindow(msg->data,true);
	    if(chan) 
	       connect(chan,SIGNAL( sendcommand(const char *) ),
		     this, SLOT( chatCommand(const char *) ) );
	    break;
	 }
      case NAP_CHAN_TOPIC:
	 msgstr = msg->data;
	 ((KNAP_ChatManagerPanel *)tab_1)->setChannelTopic(msgstr);
	 break;
      case NAP_CHANACTION_MSG: // TODO implemnt this slightly different
	 //msgstr = msg->data;
	 ((KNAP_ChatManagerPanel *)tab_1)->writeChannelActionMessage(msg->data);
	 break;
      case NAP_CHAN_MSG:
	 ((KNAP_ChatManagerPanel *)tab_1)->writeChannelMessage(msg->data);
	 break;
      case NAP_CHAN_USERINFO:
	 ((KNAP_ChatManagerPanel *)tab_1)->userJoined(msg->data,false);
	 break;
      case NAP_CHAN_USERJOINED:
	 ((KNAP_ChatManagerPanel *)tab_1)->userJoined(msg->data,true);
	 break;
      case NAP_CHAN_USERLEFT:
	 ((KNAP_ChatManagerPanel *)tab_1)->userLeft(msg->data);
	 break;

      case NAP_USER_MSG:
	 ((KNAP_ChatManagerPanel *)tab_1)->writeUserMessage(msg->data);
	 break;

      case NAP_REMOTEQUEUEFULL: //TODO **********

	 tmpinfo = parseRemoteQueueBuffer(msg->data);
	 if(tmpinfo)
	    downloadpanel->stopDownload(tmpinfo, false,  msg->type);
	 
	 break;
      case NAP_DOWNLOAD_ERROR:
      case NAP_GET_ERROR:	 
	 msgstr = QString("** GET error: ") + msg->data;
	 ((KNAP_ChatManagerPanel *)tab_1)->writeError(msgstr);
	 
	 tmpinfo=parseDownloadErrorBuffer(msg->data);
	 // find by name - report as an error
         if(tmpinfo) downloadpanel->stopDownload(tmpinfo,false, msg->type);

	 break; 
      case NAP_DOWNLOAD_RESULT:
	 if(msg->size>0) 
	 {
	    tmpinfo=parseDownloadBuffer(msg->data);
	    if(tmpinfo) startDownload(tmpinfo);
	 }
	 break; 
      case NAP_UPLOAD_REQ_NEW:
        cerr << "In NAPUPLOAD_REQ_NEW: " << msg->data << endl;
        //TODO start the new type upload request

        // upload info is same format as the download request
        tmpinfo = parseDownloadBuffer(msg->data);
        if(tmpinfo) uploadpanel->startUpload(tmpinfo, connection->getUser());
        break;
      case NAP_UPLOAD_REQ:
	 // is in same format as error so get song this way 
	 tmpinfo=parseDownloadErrorBuffer(msg->data);
         //if(tmpinfo) uploadpanel->addUpload(tmpinfo,false);
         if(tmpinfo) 
	 {
	    // if we will allow the upload - send upalod ok message
	    cerr << "in NAP_UPLOAD_REQ:\n";
	    uploadpanel->addDownloadItem(tmpinfo->user,tmpinfo->filename);

//TODO	
	    connection->sendUploadAllowed(tmpinfo->user,tmpinfo->filename);
	    //connection.queuefull(str); user song maxupload
	 }
	 break;
      case NAP_PING_REQ:
	 connection->sendPong(msg->data);
	 break;
      case NAP_PING_RESULT:
	 {
	    processPing(msg->data);
	 }
      default:
	 break;
   }
}
//--------------------- slots
void Knapster2::timerUpdate()
{
   if(connection)
   {

      if(processeddata==false) timeoutcount++;
      else timeoutcount = 0;

      // if we have no data occuring for 4 minutes
      if(timeoutcount >= (4*60)/UPDATETIME)
      {
	 QString str = i18n("No data detected - connection lost? .. closing connection.");
	 ((KNAP_ChatManagerPanel *)tab_1)->writeChannel("Console",
   	    str, 
	    KNAP_ChanPanel::MessageError); 

	 napsterClosed();
      }
      processeddata = false; // clear for checking later
   }
   else timeoutcount =  0;
}
void Knapster2::chatCommand(const char *comm)
{
   cerr << "Knapster2::chatCommand(): " << comm << endl;

   QString tmp = comm;

   QString command = extractString(tmp);
   
   // this command can be done even when no connection
   if(command == "/close")
   {
      QString channame = extractString(tmp);
      KNAP_ChanPanel *chan = ((KNAP_ChatManagerPanel *)tab_1)->findWidget(channame);
      if(chan && channame!="Console")
      {
	 // close if - after sending close message if needed
	 cerr << "close chan window ----------- " << channame << endl;

	 if(chan->isUserlistShown()==true) // assuming is a channel
	 {
	    if(connection) connection->sendPartChannel(channame);
	 }
	 ((KNAP_ChatManagerPanel *)tab_1)->closeChatWindow(channame);
      }
      return;
   }
   
   // other commands require a connection to work
   if(!connection) return;
  
   if(command == "/chan")
   {
      QString chan = extractString(tmp);
      tmp = tmp.stripWhiteSpace();
      connection->sendChannelMessage(chan,tmp);
   }
   else if(command == "/msg")
   {
      QString user = extractString(tmp);
      tmp = tmp.stripWhiteSpace();
      connection->sendUserMessage(user,tmp);
   }
   else if(command == "/talk")
   {
      QString user = extractString(tmp);
      KNAP_ChanPanel *chan = ((KNAP_ChatManagerPanel *)tab_1)->openChatWindow(user,false);
      if(chan) 
      {
	 chan->setEchoMode(true);

	 connect(chan,SIGNAL( sendcommand(const char *) ),this, SLOT( chatCommand(const char *) ) ); 
      }
   }
   else if(command == "/ping")
   {
      QString user = extractString(tmp);
      addPing(user);
   }
   else if(command == "/version")
   {
      connection->sendVersionRequest();
   }
   else if(command=="/add")
   {
      QString user = extractString(tmp);

      connection->sendHotlistUser(user);
   }
   else if(command=="/del")
   {
      QString user = extractString(tmp);

      connection->sendRemoveHotlistUser(user);
   }
   else if(command=="/browse")
   {
      QString user = extractString(tmp);

      connection->sendBrowseUser(user);
   }  
   else if(command=="/download")
   {
      QString user = extractString(tmp);
      QString file = extractString(tmp);
      connection->sendDownloadRequest(user,file); 

      downloadpanel->addDownloadItem(user,file);
   }
   else if(command=="/search")
   {
      if(connection)
      {
	 //if(clearonnewsearch)
	 ((KNAP_SearchPanel *)tab_3)->clearSearch();

	 statusBar()->changeItem( i18n("Searching...") ,1);
	 connection->sendSearch(tmp);
      }
   }
   else if(command=="/ignore")
   {
      QString user = extractString(tmp);

      connection->sendIgnoreUser(user);
   }
   else if(command=="/unignore")
   {
      QString user = extractString(tmp);

      connection->sendUnignoreUser(user);
   }

   else if(command == "/whois")
   {
      QString user = extractString(tmp);
      if(connection) connection->sendWhoisUser(user);      
   }
   else if(command == "/join")
   {
      QString chan = extractString(tmp);
      connection->sendJoinChannel(chan);
   }
   else if(command == "/list")
   {
      menuChannels();
   }
   else if(command=="/kill")
   {
      QString user = extractString(tmp);

      connection->sendKillUser(user,tmp);
   }
   else if(command=="/downloadstarted")
   {
      connection->sendIncDownloads();
   }
   else if(command=="/downloadended")
   {
     connection->sendDecDownloads();
   }
   else if(command=="/uploadstarted")
   {
      connection->sendIncUploads();
   }
   else if(command=="/uploadended")
   {
     connection->sendDecUploads();
   }
}

// function called by napster read on getting a server stats block
// -> get the counts and display in status bar
void Knapster2::showServerStats(NAPBLOCKPTR n)
{
   int libs,songs,gigs;
   sscanf(n->data,"%d %d %d",&libs,&songs,&gigs);

   statusBar()->changeItem( QString().setNum(songs) + QString(i18n(" Songs ") ),2);
   statusBar()->changeItem( QString().setNum(libs) + QString(i18n(" Libraries.")),3);
   statusBar()->changeItem( QString(i18n("Total ")) + QString().setNum(gigs) 
	 + QString(i18n(" Gig.")),4);

}                                                                         
//
void Knapster2::addPing(const char *u)
{
   KNAP_Ping *it = findPing(u);
   if(it) pinglist.remove(it);

   pinglist.append(new KNAP_Ping(u));  
   connection->sendPingRequest(u);
}
KNAP_Ping * Knapster2::findPing(const char *user)
{

   KNAP_Ping *pi;
   int ms;

   for(pi=pinglist.first();pi!=NULL;pi=pinglist.next()) {
      if(pi->user==user) 
      {
	 return pi;
      }
   }
   return 0;
}
void Knapster2::processPing(const char *data)
{
   QString tmp = data; 
   QString user = extractString(tmp);

   KNAP_Ping *pi;
   int ms;

   pi = findPing(user);
   if(pi)
   {
      // found -> print and remove
      
      ms=pi->time.msecsTo(QTime::currentTime());
      QString msgstr = QString(i18n("** Ping ")) + user + " " + (QString().setNum(ms));
      ((KNAP_ChatManagerPanel *)tab_1)->writeChannel("Console",msgstr,
	  KNAP_ChanPanel::MessageNotify);

      pinglist.remove(pi);

   }
}
//------ parsing message string functions

// parse a search block data for the song info and create a temp SOngInfo from it
// returns NULL on an invalid one
SongInfo * Knapster2::parseSearchBuffer(char *buff)
{
   //   "C:\SHARED\Steps - You're Everything That Matters To Me.mp3" 
   //   AAAAAMD5AAAAAA 59392 128 44100 3 witchfinder-2000 2174828606 4
   static SongInfo si;

   QString tmp;
   QString work=buff;

   si.songnum = 0;

   si.filename=extractString(work);
   si.md5=extractString(work);
   tmp=extractString(work);
   if(!tmp.isNull()) si.size=tmp.toLong();

   tmp=extractString(work);
   if(!tmp.isNull()) si.bitrate=tmp.toInt();
   tmp=extractString(work);
   if(!tmp.isNull()) si.freq=tmp.toInt();
   tmp=extractString(work);

   if(!tmp.isNull()) si.seconds=tmp.toLong();

   si.user=extractString(work);
   tmp=extractString(work);
   if(!tmp.isNull()) si.ip=tmp.toULong();
   tmp=extractString(work);
   if(!tmp.isNull()) si.speed=tmp.toInt();

   if(tmp.isNull()) return NULL; //warped data???

   return &si;
}
// parse a browse block data for the song info and create a temp SOngInfo from it
// returns NULL on an invalid one 
SongInfo * Knapster2::parseBrowseBuffer(char *buff)
{
   static SongInfo si;

   QString tmp;
   QString work=buff;

   si.user=extractString(work);
   si.filename=extractString(work);
   si.md5=extractString(work);

   tmp=extractString(work);
   if(!tmp.isNull()) si.size=QString(tmp).toLong();

   tmp=extractString(work);
   if(!tmp.isNull()) si.bitrate=QString(tmp).toInt();
   tmp=extractString(work);
   if(!tmp.isNull()) si.freq=QString(tmp).toInt();

   tmp=extractString(work);
   if(!tmp.isNull()) si.seconds=QString(tmp).toLong();
   else return NULL; //warped data???

   return &si;
}  

SongInfo * Knapster2::parseDownloadErrorBuffer(char *buff)
{
   static SongInfo si;

   QString tmp;
   QString work=buff;

   si.user=extractString(work);

   si.filename=extractString(work);

   return &si;
}
/*
SongInfo * Knapster2::parseRemoteQueueBuffer(char *buff)
{
   static SongInfo si;

   QString tmp;
   QString work=buff;

   si.user=extractString(work);

   si.filename=extractString(work);

   return &si;
} 
*/
// parse a browse block data for the song info and create a temp
// SOngInfo from it
// // returns NULL on an invalid one  
SongInfo * Knapster2::parseDownloadBuffer(char *buff)
{
   // wearable_computer 3306359250 6699 "home\jade\mp3\Chieftans - Celtic Harp.mp3" MD5 1
   static SongInfo si;

   QString tmp;
   QString work=buff;

   si.user=extractString(work);
   tmp=extractString(work);
   if(!tmp.isNull()) si.ip=QString(tmp).toULong();
   tmp=extractString(work);
   if(!tmp.isNull()) si.port=QString(tmp).toInt();

   si.filename=extractString(work);

   si.md5=extractString(work);

   tmp=extractString(work);
   if(!tmp.isNull()) si.speed=QString(tmp).toInt();

   if(tmp.isNull()) return NULL; //warped data???
   return &si;
}  
// parse a remote queue block data for the song info and create a temp
// //SOngInfo from it
// // returns NULL on an invalid one
SongInfo * Knapster2::parseRemoteQueueBuffer(char *buff)
{
   static SongInfo si;

   QString tmp;
   QString work=buff;

   si.user=extractString(work);
   si.filename=extractString(work);

   tmp=extractString(work);
   if(!tmp.isNull()) si.songnum=QString(tmp).toInt(); // NOTE: using songnum to hold num of downloads

   if(tmp.isNull()) return NULL; //warped data???

   return &si;
}  
