/***************************************************************************
                          chessclock.h  -  description
                             -------------------
    begin                : Mon Jul 2 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHESSCLOCK_H
#define CHESSCLOCK_H

#include <qwidget.h>
#include <qstring.h>
#include <stdlib.h>
#include "definitions.h"
#include "resource.h"

/**
  *@author Troy Corbin Jr.
  */

class chessclock : public QWidget
{
	Q_OBJECT

		public:

								chessclock( QWidget *parent=0, const char *name=0, resource *Rsrc=0 );
								~chessclock();

								/* The Set function accepts Centiseconds ( 1/100 second ) */
			void			Set( const int WhiteSec, const int BlackSec, const bool onMove );
			void			Reset( void );
			void			Pause( void );
			void			Resume( void );
			void			Moved( void );
			int				getCentiseconds( const bool Army );

			QString		whiteClock;
			QString		blackClock;
			bool			Silent;
			bool			Flag[2];

		public slots:
			void			Tick( void );

		signals:
			void			flagFell( const bool );

		private:

			resource	*Resource;

			TCP				White;
			TCP				Black;

			int				WhiteIndex;
			int				BlackIndex;

			bool			ArmyOnMove;
			bool			External;

			void			UpdateStrings( void );
};

#endif
