/***************************************************************************
                          setpageservers.cpp  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "setpageservers.moc"
#include <qstyle.h>
#include <kicontheme.h>

setPageServers::setPageServers(QWidget *parent, resource *Rsrc  ) : QVBoxLayout(parent)
{
	QStyle& Style = QApplication::style();
	margin = Style.defaultFrameWidth();
	Resource = Rsrc;
	Servers_ListView = NULL;
	resetServer = FALSE;

	TabParent = new QTabWidget( parent, "setPageDisplay" );
	initTab1();
	initTab2();
	addWidget( TabParent );
}
setPageServers::~setPageServers()
{
	Servers_ListView->saveLayout( kapp->config(), "Servers_ListView" );
	delete Servers_ButtonBox;
	delete Servers_ListView;
	delete GROUP_Servers;
	delete GROUP_Current;
}
///////////////////////////////////////
//
//	setPageServers::initTab1
//
///////////////////////////////////////
void setPageServers::initTab1( void )
{
	Tab1 = new QVBox( TabParent );
	Tab1->setMargin( margin );

	/* Current Server */
	GROUP_Current = new QGroupBox( 	1,
																	Qt::Vertical,
																	i18n( "Current Server" ),
																	Tab1 );
	
	Servers = new KComboBox ( GROUP_Current );
	Servers->setEditable( FALSE );

	/* Chess Servers ListView */
	GROUP_Servers = new QGroupBox(	2,
																	Qt::Horizontal,
																	i18n( "Chess Servers" ),
																	Tab1 );
	
	Servers_ListView = new KListView( GROUP_Servers );
	Servers_ListView->addColumn( i18n( "Name" ) );
	Servers_ListView->addColumn( i18n( "URL" ) );
	Servers_ListView->setAllColumnsShowFocus( TRUE );
	Servers_ListView->setMultiSelection( FALSE );
	Servers_ListView->setShowSortIndicator( TRUE );
	Servers_ListView->restoreLayout( kapp->config(), "Servers_ListView" );

	Servers_ButtonBox = new KButtonBox( GROUP_Servers, Vertical );
		Servers_Button_Add = Servers_ButtonBox->addButton( i18n( "&Add..." ) );
		Servers_Button_Change = Servers_ButtonBox->addButton( i18n( "&Modify..." ) );
		Servers_Button_Delete = Servers_ButtonBox->addButton( i18n( "&Delete..." ) );
		Servers_ButtonBox->layout();

	BuildServerData();

	connect( Servers_Button_Add, SIGNAL( clicked() ), this, SLOT( slotServer_Add() ) );
	connect( Servers_Button_Change, SIGNAL( clicked() ), this, SLOT( slotServer_Modify() ) );
	connect( Servers_Button_Delete, SIGNAL( clicked() ), this, SLOT( slotServer_Delete() ) );
	connect( Servers, SIGNAL( activated(int) ), this, SLOT( slotCurrent(int) ) );
	connect( Servers_ListView, SIGNAL( selectionChanged() ), this, SLOT( selectionChanged() ) );

	TabParent->addTab( Tab1, i18n("Servers") );
}
///////////////////////////////////////
//
//	setPageServers::initTab2
//
///////////////////////////////////////
void setPageServers::initTab2( void )
{
	QStringList FilterLevels;
	Tab2 = new QVBox( TabParent );
	Tab2->setMargin( margin );

	/* Current Profanity Filter */
	BOX_Profanity = new QGroupBox( 	1,
																	Qt::Vertical,
																	i18n( "Profanity Filter" ),
																	Tab2 );
	COMBO_Profanity = new KComboBox ( BOX_Profanity );
	COMBO_Profanity->setEditable( FALSE );
	FilterLevels << i18n("Filter Everything") << i18n("Default") << "---" << "---" << "---" << i18n("No Filtering");
	COMBO_Profanity->insertStringList( FilterLevels );
	COMBO_Profanity->setCurrentItem( Resource->OPTION_Profanity );
	connect( COMBO_Profanity, SIGNAL( activated(int) ), this, SLOT( slot_Profanity(int) ) );

	BUTTON_Auto_Close_ICS = new QCheckBox( i18n( "Automatically Close Previous ICS Match" ), Tab2 );
	BUTTON_Auto_Close_ICS->setChecked( Resource->OPTION_Auto_Close_Last_ICS );
	connect(	BUTTON_Auto_Close_ICS, SIGNAL( toggled(bool) ),
						this, SLOT( slot_Auto_Close_ICS(bool) ) );

	BUTTON_Private = new QCheckBox( i18n( "Private Matches" ), Tab2 );
	BUTTON_Private->setChecked( Resource->OPTION_Private );
	connect( BUTTON_Private, SIGNAL( toggled(bool) ), this, SLOT( slot_Private(bool) ) );

	BUTTON_Premove = new QCheckBox( i18n( "Enable Premove" ), Tab2 );
	BUTTON_Premove->setChecked( Resource->OPTION_Premove );
	connect( BUTTON_Premove, SIGNAL( toggled(bool) ), this, SLOT( slot_Premove(bool) ) );

	BUTTON_Kibitz = new QCheckBox( i18n( "Enable Kibitzes" ), Tab2 );
	BUTTON_Kibitz->setChecked( Resource->OPTION_Kibitz );
	connect( BUTTON_Kibitz, SIGNAL( toggled(bool) ), this, SLOT( slot_Kibitz(bool) ) );

	BUTTON_Tell = new QCheckBox( i18n( "Enable Unregistered Tells" ), Tab2 );
	BUTTON_Tell->setChecked( Resource->OPTION_Tell );
	connect( BUTTON_Tell, SIGNAL( toggled(bool) ), this, SLOT( slot_Tell(bool) ) );

	BUTTON_Shout = new QCheckBox( i18n( "Enable Shouts" ), Tab2 );
	BUTTON_Shout->setChecked( Resource->OPTION_Shout );
	connect( BUTTON_Shout, SIGNAL( toggled(bool) ), this, SLOT( slot_Shout(bool) ) );

	BUTTON_Seek = new QCheckBox( i18n( "Enable Seeks" ), Tab2 );
	BUTTON_Seek->setChecked( Resource->OPTION_Seek );
	connect( BUTTON_Seek, SIGNAL( toggled(bool) ), this, SLOT( slot_Seek(bool) ) );

	BOX_SeekTimer = new QHBox( Tab2 );
		BUTTON_SeekTimer = new QSpinBox( 3, 120, 1, BOX_SeekTimer );
		BUTTON_SeekTimer->setSuffix( i18n(" sec.") );
		BUTTON_SeekTimer->setValue( Resource->Seek_Timer / 10 );
		connect(	BUTTON_SeekTimer, SIGNAL( valueChanged(int) ),
							this, SLOT( slot_SeekTimer(int) ) );
		LABEL_SeekTimer = new QLabel( i18n("Seconds Between Seek Updates"), BOX_SeekTimer );

	TabParent->addTab( Tab2, i18n("Options") );
}
///////////////////////////////////////
//
//	setPageServers::BuildServerData
//
///////////////////////////////////////
void setPageServers::BuildServerData( void )
{
	bool 	SERVER_FLAG(FALSE);
	QStringList ServerList;
	int Index(0);
	serverList::Iterator	serversIT;

	/* Clear Comboboxes */
	Servers->clear();
	Servers_ListView->clear();
	/* Read the server list */
	if( Resource->servers.isEmpty() ) return;
	for ( serversIT = Resource->servers.begin(); serversIT != Resource->servers.end(); ++serversIT )
	{
		(void) new QListViewItem( Servers_ListView,
															(*serversIT).Name,
															(*serversIT).URL );
		ServerList.append( (*serversIT).Name );
	}
	/* Insert engines into comboboxes */
	ServerList.sort();
	Servers->insertStringList( ServerList );
	/* Now run the list again, setting the current engine for each combobox */
	for ( serversIT = Resource->servers.begin(); serversIT != Resource->servers.end(); ++serversIT )
	{
 		if( (*serversIT).CurrentRef )
			for( Index = 0; Index < Servers->count(); Index++ )
				if( Servers->text(Index) == (*serversIT).Name )
				{
		 			Servers->setCurrentItem(Index);
					SERVER_FLAG = TRUE;
				}
	}
	/* This prevents a bug where you had to modify the current_server_combobox
		before you could get any servers to run. */
	if( ( !SERVER_FLAG ) && ( Servers->count() ) ) slotCurrent( Servers->currentItem() );

	Servers_Button_Change->setEnabled( FALSE );
	Servers_Button_Delete->setEnabled( FALSE );
}
///////////////////////////////////////
//
//	setPageServers::slotServer_Add
//
///////////////////////////////////////
void setPageServers::slotServer_Add( void )
{
	Server_Dialog = new dlg_server( TabParent, "ServerDialog", Resource );
	connect( Server_Dialog, SIGNAL( destroyed() ), this, SLOT( BuildServerData() ) );
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageServers::slotServer_Modify
//
///////////////////////////////////////
void setPageServers::slotServer_Modify( void )
{
	QListViewItem *Item;
	QList<QListViewItem> Select = Servers_ListView->selectedItems();

	if( Select.isEmpty() ) return;
	Item = Select.first();
	Server_Dialog = new dlg_server( TabParent, "ServerDialog", Resource, Item->text(0) );
	connect( Server_Dialog, SIGNAL( destroyed() ), this, SLOT( BuildServerData() ) );
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageServers::slotServer_Delete
//
///////////////////////////////////////
void setPageServers::slotServer_Delete( void )
{
	serverList::Iterator	serversIT;
	QListViewItem *Item;
	QList<QListViewItem> Select = Servers_ListView->selectedItems();

	if( Select.isEmpty() ) return;
	Item = Select.first();

	for ( serversIT = Resource->servers.begin(); serversIT != Resource->servers.end(); ++serversIT )
	{
		if( (*serversIT).Name == Item->text(0) ) break;
	}
	Resource->servers.remove(serversIT);
	BuildServerData();
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageServers::slotCurrent
//
///////////////////////////////////////
void setPageServers::slotCurrent( int Index )
{
	QString Name;
	serverList::Iterator	serversIT;
	
	Name = Servers->text(Index);
	for ( serversIT = Resource->servers.begin(); serversIT != Resource->servers.end(); ++serversIT )
	{
		if( (*serversIT).CurrentRef ) (*serversIT).CurrentRef = FALSE;
		if( (*serversIT).Name == Name ) (*serversIT).CurrentRef = TRUE;
	}
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageServers::slot_Profanity
//
///////////////////////////////////////
void setPageServers::slot_Profanity( int Index )
{
	Resource->OPTION_Profanity = Index;
	emit enableApply();
	resetServer = TRUE;
}
///////////////////////////////////////
//
//	setPageServers::slot_Premove
//
///////////////////////////////////////
void setPageServers::slot_Premove( bool state )
{
	Resource->OPTION_Premove = state;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageServers::slot_Shout
//
///////////////////////////////////////
void setPageServers::slot_Shout( bool state )
{
	Resource->OPTION_Shout = state;
	emit enableApply();
	resetServer = TRUE;
}
///////////////////////////////////////
//
//	setPageServers::slot_Private
//
///////////////////////////////////////
void setPageServers::slot_Private( bool state )
{
	Resource->OPTION_Private = state;
	emit enableApply();
	resetServer = TRUE;
}
///////////////////////////////////////
//
//	setPageServers::slot_Kibitz
//
///////////////////////////////////////
void setPageServers::slot_Kibitz( bool state )
{
	Resource->OPTION_Kibitz = state;
	emit enableApply();
	resetServer = TRUE;
}
///////////////////////////////////////
//
//	setPageServers::slot_Tell
//
///////////////////////////////////////
void setPageServers::slot_Tell( bool state )
{
	Resource->OPTION_Tell = state;
	emit enableApply();
	resetServer = TRUE;
}
///////////////////////////////////////
//
//	setPageServers::slot_Seek
//
///////////////////////////////////////
void setPageServers::slot_Seek( bool state )
{
	Resource->OPTION_Seek = state;
	emit enableApply();
	resetServer = TRUE;
}
///////////////////////////////////////
//
//	setPageServers::slot_Auto_Close_ICS
//
///////////////////////////////////////
void setPageServers::slot_Auto_Close_ICS( bool state )
{
	Resource->OPTION_Auto_Close_Last_ICS = state;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageServers::slot_SeekTimer
//
///////////////////////////////////////
void setPageServers::slot_SeekTimer( int value )
{
	Resource->Seek_Timer = value * 10;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageServers::selectionChanged
//
///////////////////////////////////////
void setPageServers::selectionChanged( void )
{
	if( Servers_ListView->selectedItem() == 0 )
	{
		Servers_Button_Change->setEnabled( FALSE );
		Servers_Button_Delete->setEnabled( FALSE );
	}
	else
	{
		Servers_Button_Change->setEnabled( TRUE );
		Servers_Button_Delete->setEnabled( TRUE );
	}
}
