/***************************************************************************
                          knutclient.h  -  description
                             -------------------
    begin                : t srp 21 19:12:20 CEST 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTCLIENT_H
#define KNUTCLIENT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "knutmainwindow.h"
#include "knutvardata.h"
#include "knutupsdata.h"
#include "knutnet.h"
#include "knutdock.h"
#include "knutprefdlg.h"
#include "knutmessagemanager.h"

#include <kapplication.h>


#include <qwidget.h>
#include <qtimer.h>
#include <qstringlist.h>


class KNutClient : public QObject, public KSessionManaged {
  Q_OBJECT
  public:
    KNutClient(bool noDock = false, QObject* parent=0,const char* name=0);
    ~KNutClient();

  private slots:
    void timeout (void);
    void setNewUPS (QString name);

    void slotPreferenceUps(void);
    void slotSetConfig (unsigned int changeSetting);

    void slotPrintUPSVars(void);
    void slotInstComms(void);
    void slotRWVars(void);
    void slotChangeRWVars( QString varName);

    void slotExitApplication(void);

/**
 * .
 *
 * @since  0.1
 **/
    void slotRefreshConnection(void);


    void minimizeMainWindow (void);
    void exitMainWindow (void);
    void activeMainWindow (void);

    virtual bool commitData (QSessionManager&);
    virtual bool saveState (QSessionManager&);

  private:
    void makeMainWindow (void);

    void initVars (void);

    void loadConfiguration ( void );
    void saveConfiguration ( bool all = true );

    void upsActivate (void);
    void upsDeactivate (void);

    void setActiveUpsVars (bool mWindow = true);
    void setActiveXFerVars (bool activate);

    void getUpsData (void);
    
    void setActiveUpsInfo (QString name);

    void addEventString (const QString text, const QString UPSAddress = QString::null);

    void showStatusEvent(void);




/********* PRIVATE VARS****************/
    // hlavni informace o upsce
    struct upsInfo mainUpsInfo;

    // v teto strukture jsou ulozeny promene ktere nastavuji konfiguraci
    SettingDataDef settingData;

    KNutDock* myDock;

    KNutMainWindow* mainWindow;

    KNutUpsData* upsRecords;
    KNutVarData* analogRecords;

    QTimer* upsTimer;

    QStringList* listKNutEvent;

//   indikuje zda je panel nulovany
    bool panelsAreZeroing;
//  kod posledni chyby spojeni zjistene v timeoutu
//  nebere ohled zda byla chyba pri inicializaci
    int lastError;

    KNutMessageManager* myMessMan;

  };
#endif
