/* @(#) .del-fs.h 1.5 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: db
\***************************************************************/

#ifndef _KOALAMUD_LIB_FS_H
#define _KOALAMUD_LIB_FS_H "@(#) nitehawk@winghove.1ststep.net|BitKeeper/deleted/.del-fs.h|20000308020902|19410 @(#)"

/* We need fstypes.h for generic file system types */
#include "fstypes.h"

/* This file details the superblock structures that track database state. */

/* The first superblock will always live in block 0.  Other superblock
 * locations are stored in the superblock.  
 */

/* This define is the maximum length of of the mount point string
 * 	For now this is 256 so that everything will fit into a single block */
#define MAXKMNTLEN	256

/* TAG_SUPERBLOCK
 *		This superblock should always be able to fit in a single block.  The
 *		first 256 bytes of the block are used for various attributes of the
 *		superblock.  The last 256 bytes contains the last mount path string.
 *
 * 		Dnodes should be allocated to a superblock in multiples of 4.  This
 * 		ensures that the dnode table will stay on full blocks boundries.
 */
typedef struct TAG_SUPERBLOCK
{
	/* Address pointers */
	kdbfs_blockid_t	fs_sbno;	/* Block number of this superblock */
	kdbfs_blockid_t	fs_dbno;	/* Block number where dnode table starts */
	kdbfs_blockid_t	fs_btno;	/* Block number where block bitmap starts */
	kdbfs_blockid_t fs_nxtsb;	/* Block number of the next superblock */

	/* Counters */
	kdbfs_dnode_t	fs_dsize;	/* Total number of dnodes in database */
	kdbfs_dnode_t	fs_sbdsize;	/* Number of dnodes in superblock */
	kdbfs_blockid_t	fs_size;	/* Total number of blocks in the database */
	kdbfs_blockid_t	fs_sbsize;	/* Number of blocks in this superblock */
	
	/* Table sizes */
	kdbfs_blockid_t fs_dtsize;	/* Number of blocks in dnode table */
	kdbfs_blockid_t fs_btsize;	/* Number of blocks in block table */
	
	/* Usage levels */
	kdbfs_dnode_t	fs_dfree;	/* number of free dnodes in this superblock */
	kdbfs_dnode_t	fs_bfree;	/* number of free blocks in this superblock */

	/* Time information */
	int32_t		fs_ctime;		/* Superblock creation time */
	int32_t		fs_ctimesec;	/* Superblock creation time */
	int32_t		fs_ltime;		/* Last Superblock change time */
	int32_t		fs_ltimesec;	/* Last Superblock change time */

	/* File system flags */
	int8_t		fs_clean;	/* File system is clean flag */

	/* First free locations */
	kdbfs_dnode_t	fs_ffdnode;	/* First Free dnode */
	kdbfs_blockid_t	fs_ffblock;	/* First Free block */

	/* First dnode and block number tracked by this superblock */
	kdbfs_dnode_t	fs_firstdnode;	/* First dnode tracked by this superblock */
	kdbfs_blockid_t	fs_firstblock;	/* First block tracked by this superblock */

	/* Reserved for future usage */
	u_int8_t	fs_reserved[175];

	/* Last mount path is at the end of the superblock */
	u_char	fs_lastmnt[MAXKMNTLEN];		/* Path of last mount */

} superblock;

/* Clean flags */
#define FS_CLEAN	0x0
#define FS_DIRTY	0x1

/* Base allocation levels */
#define FS_BLOCKSBASE		4096
#define FS_BLOCKBITMAPSIZE	(512 * 8)  // 4096
#define FS_BITMAPBLOCKS		(FS_BLOCKSBASE / FS_BLOCKBITMAPSIZE)
#define FS_DNODESBASE		256
#define FS_DNODESPERBLOCK	4
#define FS_DNODEBLOCKS		(FS_DNODESBASE / FS_DNODESPERBLOCK)

#endif
