/* @(#) conf.h 1.12 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: Config
\***************************************************************/

#ifndef _KOALAMUD_CONF_H
#define _KOALAMUD_CONF_H "@(#) nitehawk@winghove.1ststep.net|include/conf.h|20000320061933|36286 @(#)"

#include "koalatypes.h"
#include "llist.h"

/* Types */
typedef struct TAG_CONFOPTION_T
{
	char *optname;
	enum
	{
		/*  String types have their memory dynamically allocated in
		 *  confgetoptionsfromsection
		 */
		OPT_STRING,
		OPT_UINT,
		OPT_INT,
		OPT_ULONG,
		OPT_LONG,
		OPT_DOUBLE,
		OPT_BOOL,
	} opttype;
	union {
		char **ostring;
		unsigned int *ouint;
		int *oint;
		unsigned long *oulong;
		long *olong;
		double *odouble;
		bool *obool;
	} opt;
} confoption_t;

/* Prototypes */
koalaerror gendefaultconfig(const char *filename);
koalaerror readxmlconfig(const char *filename);
koalaerror finddaemonconfig(void);
koalaerror confgetnodeid(void);
koalaerror confcreatelisten(listnodeptr list);
koalaerror confopenlogs(void);
bool confquerybackground(void);
koalaerror confcreateuplink(listnodeptr uplinklist);
koalaerror confgetoptions(void);
koalaerror confgetoptionsfromsection(char *section, confoption_t *optionlist,
	int num);

#endif
