/* @(#) commandtablehandler.c 1.4 @(#) */
/***************************************************************\
*	Copyright (c) 1999-00 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: COMMAND
*
*	Handle manipulation of the command table(s)
\***************************************************************/

#define _KOALAMUD_PARSER_C "@(#) nitehawk@winghove.1ststep.net|lib/koala/commandtablehandler.c|20001105025141|48820 @(#)"

#include "autoconf.h"

#include "version.h"
#include "log.h"
#include "koalatypes.h"
#include "buffer.h"
#include "memory.h"
#include "kparser.h"

pcommandentry ctablehead = NULL;

/* When inserting a command into the list, it will be inserted after the
 * 'back' pointer and before the 'front' pointer. */
koalaerror registercommand(pcommandentry cmd, dynmod_t *ownermod)
{
	pcommandentry front = ctablehead, back=front, new = NULL;
	int i;
	
	/* Allocate memory for a new command */
	if ((new = kmalloc(sizeof(commandentry), ALLOC_CMDTABLE)) ==NULL)
	{
		/* Bad things going on.  No memory available. */
		logmsg(LOGCRIT, "Unable to allocate memory for new command: %s",
				strerror(errno));
		return KENOMEM;
	}

	/* Copy the new command into the list */
	new->next = NULL;
	if ((new->command = kmalloc(strlen(cmd->command), ALLOC_STRING))
				== NULL)
	{
		logmsg(LOGCRIT, "Unable to allocate memory for new command: %s",
				strerror(errno));
		kmfree(new, ALLOC_CMDTABLE);
		return KENOMEM;
	}
	strcpy(new->command, cmd->command);
	new->handler = cmd->handler;
	new->numargs = cmd->numargs;
	new->commandtype = cmd->commandtype;

	/* The argument list needs to be cloned in its entirety.  */
	if ((new->arglist = kmalloc(sizeof(argument)*new->numargs, ALLOC_CMDTABLE))
				== NULL)
	{
		logmsg(LOGCRIT, "Unable to allocate memory for argument list: %s",
				strerror(errno));
		kmfree(new->command, ALLOC_STRING);
		kmfree(new, ALLOC_CMDTABLE);
		return KENOMEM;
	}
	for (i=0; i < new->numargs; i++)
	{
		new->arglist[i].argtype = cmd->arglist[i].argtype;
		new->arglist[i].argdata.argint = 0;
		new->arglist[i].strlen = 0;
	}
	new->unlock = cmd->unlock;	/* Since the key is stored separately, we don't
								 * need clone the key separately */
	new->owner = ownermod;

	if (front == NULL)
	{
		/* If front is null, it means that we don't have a head pointer yet.
		 * In this case, we simply need to point ctablehead to new and we are
		 * done.
		 */
		ctablehead = new;
		return KESUCCESS;
	}
	else
	{
		/* Otherwise, we need to search through the command list for the
		 * correct place to insert the command */
		while (front && strncasecmp(front->command, new->command,
				strlen(new->command)) < 0)
		{
			back = front;
			front = front->next;
		}

		if (front == ctablehead)
		{
			/* In this case, the new command comes earlier in the list then
			 * the head.  Move the head out a level
			 */
			new->next = front;
			ctablehead = new;
		}
		else
		{
		/* At this point, back points the the location immediatly before the
		 * insert, and front points the the location immediatly after, or NULL
		 * if we are adding to the end of the list.
		 */
			new->next = front;
			back->next = new;
		}
	}
	
	return KESUCCESS;
}

