/* @(#) hub.c 1.34 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
\***************************************************************/

#define _KOALAMUD_HUB_C "@(#) nitehawk@localhost.1ststep.net|src/hub/hub.c|20000827025250|24506 @(#)"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "network.h"
#include "log.h"
#include "conf.h"
#include "llist.h"
#include "memory.h"
#include "uplinkprotocol.h"
#include "reboot.h"
#include "buffer.h"

/* Initialize state variables */
koalaerror daemoninitstate(void)
{
	koptions.daemontype = DAEMON_HUB;
	return KESUCCESS;
};

/* Startup the daemon */
koalaerror rundaemon(void)
{
	int selectreturn;
	pdescriptor desc = NULL;
	pdescriptor newdesc = NULL;
	koalaerror acceptreturn;
	listnodeptr desclist, tmplist;
	fd_set insockets, outsockets, errsockets;
	int descriptorcount = 0;
	int numuplinks = 0;
	int maxdescriptor = 0;
	unsigned long loopcount = 0;
	struct timeval waitcycle;

	/* Startup networking */
	netstartup();

	desclist = getdescriptorlist();

	if (desclist == NULL)
	{
		logmsg(LOGCRIT, "Unable to create descriptor linked list - bail out");
		return KENOMEM;
	}

	/* check to see if this was a reboot */
	if (!(kstate.running == DSTATE_REBOOTING &&
				(reloaddescriptors() == KESUCCESS)))
	{
		/* Attempt to create an uplink */
		if (confcreateuplink(desclist) != KESUCCESS)
		{
			logmsg(LOGWARN, "Error connecting to uplink, use 'link' as an"
					" admin to create an uplink");
		}

		/* Start listening for uplink connections */
		if (confcreatelisten(desclist) < 0)
		{
			logmsg(LOGCRIT, "Error starting network interface, shutting down");
			return KENONETWORK;
		}
	}

	logmsg(LOGINFO, "Starting main hub routing loop on node ID: %x",
			kstate.nodeid);
	while (kstate.running == DSTATE_RUNNING)
	{
		descriptorcount = 0;
		numuplinks = 0;
		maxdescriptor = 0;
		FD_ZERO(&insockets);
		FD_ZERO(&outsockets);
		FD_ZERO(&errsockets);

		for(tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			desc = tmplist->data.desc;

			// Filter dummy sockets
			if (desc->type == DESCRIPTOR_DUMMY)
			{
				continue;
			}
			
			// Add descriptor to select sets
			if (desc->type != DESCRIPTOR_LISTEN)
			{
				numuplinks++;
				FD_SET(desc->socket, &errsockets);
				FD_SET(desc->socket, &outsockets);
			}
			FD_SET(desc->socket, &insockets);
			descriptorcount++;

			maxdescriptor = (maxdescriptor > desc->socket) ?
				maxdescriptor : desc->socket;
		}

		if (((loopcount++) % koptions.reportingperiod) == 0)
		{
			logmsg(LOGINFO, "%d descriptors, %d Listen, %d Uplink, Max FD=%d",
				descriptorcount, (descriptorcount - numuplinks), (numuplinks),
				maxdescriptor);
		}

		if (numuplinks == 0)
		{
			logmsg(LOGINFO, "No Connections, sleeping");

			if ((selectreturn = select(maxdescriptor + 1, &insockets,
						NULL, NULL, NULL)) < 0)
			{
				if (errno == EINTR)
				{
					logmsg(LOGINFO, "Waking up to process signal");
				}
				else
				{
					logmsg(LOGERR, "Problems with select - bailing water");
					continue;
				}
			}
			else
			{
				logmsg(LOGINFO, "New uplink in progress - Waking to process");
			}
		}

		// Wait for data on the socket
		waitcycle.tv_sec = 0;
		waitcycle.tv_usec = koptions.ticklen;
		if ((selectreturn = select(maxdescriptor + 1, &insockets,
			NULL, &errsockets, &waitcycle)) < 0)
		{
			if (errno == EINTR)
			{
				logmsg(LOGINFO, "Waking up to process signal");
				continue;
			}
			logmsg(LOGCRIT, "Main hub routing loop dead - falling out");
			return KESELECTFAIL;
		}
		
		/* Process all data shown by select */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			desc = tmplist->data.desc;

			/* Filter out invalid descriptors
			 * Since this is a hub daemon, player descriptors are invalids
			 */
			if (desc->type == DESCRIPTOR_DUMMY ||
					desc->type == DESCRIPTOR_NULL ||
					desc->type == DESCRIPTOR_PLAYER)
			{
				continue;
			}

			/* Close descriptors marked to be closed */
			if (desc->status == STATUS_CLOSE ||
					FD_ISSET(desc->socket, &errsockets))
			{
				tmplist = listprevnode(tmplist);
				listremovenode(desclist, desc);
				FD_CLR(desc->socket, &insockets);
				FD_CLR(desc->socket, &outsockets);
				netclose(desc);
			}
			
			/* Receive data from network */
			if (FD_ISSET(desc->socket, &insockets))
			{
				/* Are we a listener? */
				if (desc->type == DESCRIPTOR_LISTEN)
				{
					acceptreturn = netaccept(desc, &newdesc);
					if (acceptreturn == KENOMEM)
					{
						return KENOMEM;
					}
					if (acceptreturn == KENOACCEPT)
					{
						/* Probaly just no connections waiting
						 * 	shouldn't get this in normal operations */
						logmsg(LOGWARN, "No connections waiting");
						continue;
					}
					netwrite(newdesc, magic.daemonmagic,
							strlen(magic.daemonmagic));
					listaddnode(desclist, newdesc);
				}  // Accept new connection
				else
				{
					/* normal uplinks read into the buffer */
					buffer_receive(desc);
				}
			}  // Receive data

			/* This is as far as listen sockets need to go */
			if (desc->type == DESCRIPTOR_LISTEN)
			{
				continue;
			}

			/* Parse pending data */
			if (desc->type == DESCRIPTOR_UNKNOWN &&
						desc->status < STATUS_NOMINAL)
			{
				/* This is an uplink, but we don't know what type yet
				 * - Handle protocol negotiation
				 */
				uplinknegotiatestage(desc);
			}
			/* We can't uplink to a client server */
			else
			{
				/* If we have input on an uplink, pass it off to
				 * uplinkreceivemessage
				 */
				uplinkroutemessage(desc);
			}
		}  // Select processor loop
	} // Main daemon loop

	if (kstate.running == DSTATE_SHUTDOWN)
	{
		/* If we get here, we were told to shutdown the system, scan through the
		 * descriptor list and send a disconnect message to all uplinks */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			message_data msgdata;
			msgdata.data = NULL;

			desc = tmplist->data.desc;
			
			switch (desc->type)
			{
				case DESCRIPTOR_HUBSRV:
				case DESCRIPTOR_CLIENTSRV:
				case DESCRIPTOR_ZONESRV:
					/* Its an uplink - send a disconnect message */
					uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, &msgdata, 0);
					break;

				default:
					continue;
			}
		}
	}
	
	return KESUCCESS;
}
