/***************************************************************************
                          komba2view.cpp  -  description
                             -------------------
    begin                : Wed Jan 31 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// include files for Qt
#include <qheader.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qregexp.h>
#include <qtabwidget.h>
#include <qlineedit.h>

// includes for KDE
#include <klocale.h>
#include <kfiledialog.h>
#include <kiconloader.h>
// application specific includes
#include "komba2view.h"
#include "komba2doc.h"
#include "komba2.h"
#include "InfoTabDlg.h"

Komba2View::Komba2View (QWidget * parent, const char *name):QSplitter (parent,
	   name)
{
//    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)7, sizePolicy().hasHeightForWidth() ) );
  popupmenu = 0L;

  setOpaqueResize (true);
  setOrientation (QSplitter::Horizontal);
  mynettree = new QListView (this, "Nettree");
  myinfotab = new InfoTab (this);
  // Remove Informationtabs
  myinfotab->frameHost->hide ();
  myinfotab->frameShare->hide ();
  myinfotab->frameWg->hide ();

  myinfotab->lblItem->setText (i18n ("Network"));
  // Change Header font to bold, italic, 18 pica  
  QFont f = myinfotab->lblItem->font ();
  f.setBold (true);
  f.setItalic (true);
  f.setPointSize (18);
  myinfotab->lblItem->setFont (f);

  //-------------------------------------------------
  tooltip = new MyTip (this);
  nettree ()->addColumn (i18n ("Network"));
  nettree ()->addColumn (i18n ("IP"));
  nettree ()->addColumn (i18n ("Comment"));
  setBackgroundMode (PaletteBase);
  nettree ()->setRootIsDecorated (true);
  nettree ()->setBackgroundMode (PaletteBase);
  // Right Button popups a menu
  connect (myinfotab->btnSearchTree, SIGNAL (clicked ()),
	   SLOT (slotSearchTree ()));

  // Right Button popups a menu
  connect (myinfotab->lstMounted,
	   SIGNAL (rightButtonPressed (QListViewItem *, const QPoint &, int)),
	   SLOT (slotListMountedRightButtonMenu
		 (QListViewItem *, const QPoint &, int)));
  // in listMounted item is selected
  connect (myinfotab->lstMounted, SIGNAL (currentChanged (QListViewItem *)),
	   this, SLOT (selItemChanged (QListViewItem *)));
  // in listMounted item is clicked
//      connect(myinfotab->lstMounted, SIGNAL(clicked()), this, SLOT(slotMountedClicked()));
  // Item in Nettree will be removed, must removed also in copyitems
  connect (getDocument (), SIGNAL (itemRemoved (QListViewItem *)), this,
	   SLOT (slotItemRemoved (QListViewItem *)));
  // in listMounted item is selected
  connect (myinfotab->lstFound, SIGNAL (currentChanged (QListViewItem *)),
	   this, SLOT (selItemChanged (QListViewItem *)));
  // Selected Item changed
  connect (nettree (), SIGNAL (currentChanged (QListViewItem *)),
	   SLOT (slotCurrentHasChanged (QListViewItem *)));
  // expand a treeitem
  connect (nettree (), SIGNAL (expanded (QListViewItem *)),
	   SLOT (slotExpanded (QListViewItem *)));
  // Right Button popups a menu
  connect (nettree (),
	   SIGNAL (rightButtonPressed (QListViewItem *, const QPoint &, int)),
	   SLOT (slotRightButtonMenu (QListViewItem *, const QPoint &, int)));
}

Komba2View::~Komba2View ()
{
}

Komba2Doc *
Komba2View::getDocument () const
{
  Komba2App *theApp = (Komba2App *) parentWidget ();

  return theApp->getDocument ();
}

void
Komba2View::print (QPrinter * pPrinter)
{
  QPainter printpainter;
  printpainter.begin (pPrinter);

  // TODO: add your printing code here

  printpainter.end ();
}


void
Komba2View::slotExpanded (QListViewItem * item)
{
  getDocument ()->searchItem (item);
}

/** the currend(clicked) Item has changed */
void
Komba2View::slotCurrentHasChanged (QListViewItem * item)
{
  if (item)
    {
      getDocument ()->searchItem (item);
      setMenu (item);
      setInfoTab (item);
    }
}

QValueList < int >
Komba2View::getSplitterPos ()
{
  return sizes ();
}

void
Komba2View::setSplitterPos (QValueList < int >i)
{
  setSizes (i);
}


void
Komba2View::setMenu (QListViewItem * item)
{
  QString s;
  if (item)
    {
      ((Komba2App *) parent ())->enableNetworkMenu (false);
      ((Komba2App *) parent ())->enableWorkgroupMenu (false);
      ((Komba2App *) parent ())->enableHostMenu (false);
      ((Komba2App *) parent ())->enableShareMountedMenu (false);
      ((Komba2App *) parent ())->enableShareUnmountedMenu (false);
      switch (item->depth ())
	{
	  // Network is clicked
	case 0:
	  ((Komba2App *) parent ())->enableNetworkMenu (true);
	  break;
	  // Workgroup is clicked
	case 1:
	  ((Komba2App *) parent ())->enableWorkgroupMenu (true);
	  break;

	  // Host is clicked
	case 2:
	  ((Komba2App *) parent ())->
	    setHostAskForPassword (((MyHostItem *) item)->askForPassword ());
	  ((Komba2App *) parent ())->enableHostMenu (true);
	  ((MyHostItem *) item)->getIP (&s);
	  s =
	    (QString) "IP: " + s + (QString) "\t Comment:" + QString (" ") +
	    ((MyHostItem *) item)->getComment ();
	  break;
	case 3:
	  ((Komba2App *) parent ())->
	    setHostAskForPassword (((MyShareItem *) item)->askForPassword ());
	  if ((((MyShareItem *) item)->getMountPath ().length () == 0)
	      && (((MyShareItem *) item)->getSharetype () ==
		  MyShareItem::Disk))
	    ((Komba2App *) parent ())->enableShareUnmountedMenu (true);
	  else if ((((MyShareItem *) item)->getMountPath ().length () != 0))
	    ((Komba2App *) parent ())->enableShareMountedMenu (true);
	  break;
	}
    }
}

// for MyTip get back a Tooltipstring and Rect for the Cursor
QRect Komba2View::tip (const QPoint & p, QString & s)
{
  // Columnheader must be substract
  QPoint
  p1 (p.x (), p.y () - nettree ()->header ()->height ());
  QListViewItem *
    item =
    nettree ()->
    itemAt (p1);
  if (item)
    {
      switch (item->depth ())
	{
	  // over Network
	case 0:
	  s = i18n ("Samba-Network");
	  break;
	  // over Workgroup
	case 1:
	  s = i18n ("Master : ");
	  if (((MyWorkgroupItem *) item)->getMaster ())
	    s.append (((MyWorkgroupItem *) item)->getMaster ()->Name ());
	  break;

	  // over Host
	case 2:
	  s = i18n ("Comment : ");
	  s.append (((MyHostItem *) item)->getComment ());
	  break;
	  // over Share
	case 3:
	  if ((((MyShareItem *) item)->getSharetype () == MyShareItem::Disk)
	      && (((MyShareItem *) item)->getMountPath ().length () > 0))
	    {
	      s = i18n ("Mountpath : ");
	      s.append (((MyShareItem *) item)->getMountPath ());
	    }
	  else
	    {
	      s = i18n ("Comment : ");
	      s.append (((MyShareItem *) item)->getComment ());
	    }
	  break;
	}
      // get a Rect TopLeft 0, columnheader+itemposition, listwidth, itemheight
      // if cursor moves out of the rect the tooltip will hided
      QRect
	r (0, item->itemPos () + nettree ()->header ()->height (),
	   nettree ()->width (), item->height ());
      return r;
    }
  s = "";
  return QRect (0, 0, -1, -1);
}


void
Komba2View::slotRightButtonMenu (QListViewItem * item, const QPoint & p, int)
{
  if (item)
    {
      nettree ()->setCurrentItem (item);
      nettree ()->setSelected (item, true);
      switch (item->depth ())
	{
	case 0:
	  ((Komba2App *) parent ())->popupMenu ("PopupNetwork", p);
	  break;
	case 1:
	  ((Komba2App *) parent ())->popupMenu ("PopupWorkgroup", p);
	  break;
	case 2:
	  ((Komba2App *) parent ())->popupMenu ("PopupHost", p);
	  break;
	case 3:
	  ((Komba2App *) parent ())->popupMenu ("PopupShare", p);
	  break;
	}
    }
}


void
Komba2View::setTheCurrentItem (QListViewItem * item)
{
  QListViewItem *i;
  nettree ()->setCurrentItem (item);
  nettree ()->setSelected (item, true);
  i = item->parent ();
  while (i != nettree ()->firstChild ())
    {
      i->setOpen (true);	//      expands all parentitems
      i = i->parent ();
    }
  i->setOpen (true);		//      expands the item "Network"
  nettree ()->ensureItemVisible (item);
}

//////////////////////////////////////////////////////////
//  slotNoActiveProcess
//
//  Description : all Processes are exited, is needed for
//                                                              rescan why it deletes items which used by
//                                                              processes
//////////////////////////////////////////////////////////
void
Komba2View::slotNoActiveProcess ()
{
  setMenu (nettree ()->currentItem ());
}

void
Komba2View::itemDataChanged (QListViewItem * item)
{
  if (item == nettree ()->currentItem ())
    {
      if (item->depth () == 3)
	{
	  ((Komba2App *) parent ())->
	    enableMount ((((MyShareItem *) item)->getMountPath ().length () ==
			  0)
			 && (((MyShareItem *) item)->getSharetype () ==
			     MyShareItem::Disk));
	  ((Komba2App *) parent ())->
	    enableUnmount ((((MyShareItem *) item)->getMountPath ().
			    length () != 0));
	  myinfotab->lblMountPath->setText (((MyShareItem *) item)->
					    getMountPath ());
	}
    }
  if (nettree ()->currentItem ()->depth () == 0)
    {
    }
}

void
Komba2View::slotMountTo ()
{
  QListViewItem *item = nettree ()->currentItem ();
  if (item->depth () == 3)
    {
      QString filename = KFileDialog::getExistingDirectory (QString::null,
							    this,
							    i18n
							    ("Choose a mountpath"));
      if (filename != QString::null)
	((MyShareItem *) item)->mount (filename);
    }
}

void
Komba2View::setInfoTab (QListViewItem * item)
{
  int count = 0, countUnknown = 0, countNT = 0, countUnix = 0, countW2k = 0;
  QString ip;
  QString wganz, hostanz;
  QListViewItem *wgitem;
  QListViewItem *netname;
  MyHostItem *hostitem;
  if (item)
    {
      // Remove Informationtabs
      myinfotab->frameNetwork->hide ();
      myinfotab->frameHost->hide ();
      myinfotab->frameShare->hide ();
      myinfotab->frameWg->hide ();
      switch (item->depth ())
	{
	  // over Network
	case 0:
	  myinfotab->lblItem->setText (i18n ("Network"));
	  myinfotab->PixmapLabel_Host->setPixmap (DesktopIcon ("komba2"));
	  myinfotab->PixmapLabel_Host->repaint ();
	  myinfotab->frameNetwork->show ();
	  myinfotab->lblName->setText (QString::null);
	  wganz.setNum (item->childCount ());
	  myinfotab->lblWorkgroupAnz_Net->setText (wganz);
	  wgitem = item->firstChild ();
	  while (wgitem)
	    {
	      count += wgitem->childCount ();
	      hostitem = (MyHostItem *) wgitem->firstChild ();
	      while (hostitem)
		{
		  if (hostitem->getOS ().contains ("Windows NT"))
		    countNT++;
		  else if (hostitem->getOS () == "Windows 5.0")
		    countW2k++;
		  else if (hostitem->getOS () == "Unix")
		    countUnix++;
		  else
		    countUnknown++;
		  hostitem = (MyHostItem *) hostitem->nextSibling ();
		}
	      wgitem = wgitem->nextSibling ();
	    }
	  hostanz.setNum (count);
	  myinfotab->lblHostAnz_Net->setText (hostanz);
	  hostanz.setNum (countUnknown);
	  myinfotab->lblNetUnknown->setText (hostanz);
	  hostanz.setNum (countUnix);
	  myinfotab->lblNetUnix->setText (hostanz);
	  hostanz.setNum (countW2k);
	  myinfotab->lblNetW2k->setText (hostanz);
	  hostanz.setNum (countNT);
	  myinfotab->lblNetWinNt->setText (hostanz);
	  break;

	  // over Workgroup
	case 1:
	  myinfotab->lblItem->setText (i18n ("Workgroup"));
	  myinfotab->frameWg->show ();
	  myinfotab->PixmapLabel_Host->setPixmap (DesktopIcon ("network"));
	  myinfotab->lblName_Wg->setText (((MyWorkgroupItem *) item)->
					  Name ());
	  if (((MyWorkgroupItem *) item)->getMaster ())
	    myinfotab->lblMaster_Wg->setText (((MyWorkgroupItem *) item)->
					      getMaster ()->Name ());
	  hostitem = (MyHostItem *) item->firstChild ();
	  while (hostitem)
	    {
	      if (hostitem->getOS ().contains ("Windows NT"))
		countNT++;
	      else if (hostitem->getOS () == "Windows 5.0")
		countW2k++;
	      else if (hostitem->getOS () == "Unix")
		countUnix++;
	      else
		countUnknown++;
	      hostitem = (MyHostItem *) hostitem->nextSibling ();
	    }
	  hostanz.setNum (countUnknown);
	  myinfotab->lblWgUnknown->setText (hostanz);
	  hostanz.setNum (countUnix);
	  myinfotab->lblWgUnix->setText (hostanz);
	  hostanz.setNum (countW2k);
	  myinfotab->lblWgW2k->setText (hostanz);
	  hostanz.setNum (countNT);
	  myinfotab->lblWgWinNt->setText (hostanz);
	  wganz.setNum (item->childCount ());
	  myinfotab->lblHostAnz_Wg->setText (wganz);
	  break;
	  // over Host
	case 2:
	  myinfotab->lblItem->setText (i18n ("Host"));

	  myinfotab->frameHost->show ();
	  myinfotab->lblName->setText (((MyHostItem *) item)->Name ());
	  myinfotab->PixmapLabel_Host->setPixmap (DesktopIcon ("host"));
	  myinfotab->lblComment_Host->setText (((MyHostItem *) item)->
					       getComment ());
	  myinfotab->lblOS->
	    setText ((((MyHostItem *) item)->getOS ().
		      isEmpty ())? i18n ("unknown") : ((MyHostItem *) item)->
		     getOS ());
	  myinfotab->lblServer->setText (((MyHostItem *) item)->getServer ());
	  myinfotab->lstNetBiosNames->clear ();
	  netname =
	    ((MyHostItem *) item)->firstNetName (myinfotab->lstNetBiosNames);
	  while (netname)
	    netname =
	      ((MyHostItem *) item)->nextNetName (myinfotab->lstNetBiosNames);
	  ((MyHostItem *) item)->getIP (&ip);
	  myinfotab->lblIP->setText (ip);
	  break;
	  // over Share
	case 3:
	  myinfotab->lblItem->setText (i18n ("Share"));
	  myinfotab->frameShare->show ();
	  myinfotab->lblName_Share->setText (((MyShareItem *) item)->Name ());
	  myinfotab->lblComment_Share->setText (((MyShareItem *) item)->
						getComment ());
	  switch (((MyShareItem *) item)->getSharetype ())
	    {
	    case MyShareItem::Disk:
	      myinfotab->PixmapLabel_Host->setPixmap (DesktopIcon ("folder"));
	      myinfotab->lbl_ShareType->setText (i18n ("Disk"));
	      break;
	    case MyShareItem::Printer:
	      myinfotab->PixmapLabel_Host->
		setPixmap (DesktopIcon ("printer1"));
	      myinfotab->lbl_ShareType->setText (i18n ("Printer"));
	      break;
	    case MyShareItem::IPC:
	      myinfotab->PixmapLabel_Host->
		setPixmap (DesktopIcon ("blockdevice"));
	      myinfotab->lbl_ShareType->setText (i18n ("IPC$"));
	      break;
	    default:
	      myinfotab->PixmapLabel_Host->setPixmap (DesktopIcon ("help"));
	      myinfotab->lbl_ShareType->setText (i18n ("unknown"));
	      break;
	    }

	  myinfotab->lblMountPath->setText (((MyShareItem *) item)->
					    getMountPath ());
	  break;
	}
    }
}


////////////////////////////////////////////////////////////////////////////
// Methods for lstMounted (InfoTab)

/** insert a share to mounted tab  */
void
Komba2View::newMountedShare (MyShareItem * share)
{
  if (share == nettree ()->currentItem ())
    {
      ((Komba2App *) parent ())->enableShareMountedMenu (true);
      ((Komba2App *) parent ())->enableShareUnmountedMenu (false);
      setInfoTab ((QListViewItem *) share);
    }
  if (share)
    {
      MyCopyItem *citem = new MyCopyItem (myinfotab->lstMounted, share);
      citem->setText (1,
		      ((MyShareItem *) citem->getCopyItem ())->
		      getMountPath ());
    }
}

/** remove a share from mounted tab */
void
Komba2View::delMountedShare (MyShareItem * share)
{
  MyCopyItem *citem;
  if (share == nettree ()->currentItem ())
    {
      ((Komba2App *) parent ())->enableShareMountedMenu (false);
      ((Komba2App *) parent ())->enableShareUnmountedMenu (true);
      setInfoTab ((QListViewItem *) share);
    }
  citem = (MyCopyItem *) myinfotab->lstMounted->firstChild ();
  while (citem)
    {
      if (citem->getCopyItem () == share)
	{
	  delete citem;
	  return;
	}
      citem = (MyCopyItem *) citem->nextSibling ();
    }
}

/**   */
void
Komba2View::slotMountedClicked ()
{
  if (myinfotab->lstMounted->currentItem ())
    setTheCurrentItem (((MyCopyItem *) myinfotab->lstMounted->
			currentItem ())->getCopyItem ());
}



/** */
void
Komba2View::selItemChanged (QListViewItem * item)
{
  if (item)
    setTheCurrentItem (((MyCopyItem *) item)->getCopyItem ());
}

void
Komba2View::slotListMountedRightButtonMenu (QListViewItem * item,
					    const QPoint & p, int)
{
  if (item)
    {
      myinfotab->lstMounted->setCurrentItem (item);
      myinfotab->lstMounted->setSelected (item, true);
      ((Komba2App *) parent ())->popupMenu ("PopupShare", p);
    }
}



////////////////////////////////////////////////////////////////////////
// The Findtab

void
Komba2View::slotSearchTree ()
{
  MyHostItem *host;
  MyShareItem *share;
  QString ip;
  enum TO_FIND
  { byName, byIP };
  myinfotab->lstFound->clear ();
  QRegExp tofind (myinfotab->txtSearch->text (), false, true);
  MyWorkgroupItem *wg =
    (MyWorkgroupItem *) nettree ()->firstChild ()->firstChild ();
  while (wg)
    {
      if (myinfotab->cmbFind->currentItem () == byName)
	if (((QString) wg->Name ()).find (tofind) == 0)
	  new MyCopyItem (myinfotab->lstFound, wg);
      host = (MyHostItem *) wg->firstChild ();
      while (host)
	{
	  if (myinfotab->cmbFind->currentItem () == byName)
	    {
	      // else why only one Item of the Host should be in Findlist
	      if (((QString) host->Name ()).find (tofind) == 0)
		{
		  new MyCopyItem (myinfotab->lstFound, host);
		}
	      else
		{
		  if (host->searchNetNames (tofind))
		    new MyCopyItem (myinfotab->lstFound, host);
		}
	    }
	  if (myinfotab->cmbFind->currentItem () == byIP)
	    {
	      host->getIP (&ip);
	      if (ip.find (tofind) == 0)
		new MyCopyItem (myinfotab->lstFound, host);
	    }

	  share = (MyShareItem *) host->firstChild ();
	  while (share)
	    {
	      if (myinfotab->cmbFind->currentItem () == byName)
		if (((QString) share->Name ()).find (tofind) == 0)
		  new MyCopyItem (myinfotab->lstFound, share);
	      share = (MyShareItem *) share->nextSibling ();
	    }
	  host = (MyHostItem *) host->nextSibling ();
	}
      wg = (MyWorkgroupItem *) wg->nextSibling ();
    }
}


void
Komba2View::slotSendMessage ()
{
  getDocument ()->sendMessage ();
}

////////////////////////////////////////////////////////////////////
// slotItemRemoved
//      Parameter : item - the Item that will be removed
//      
//      Description : copyitems have a pointer to a Item in Nettree
//                                                              so they must be removed bevor a nettreeitem will
//                                                              be removed
///////////////////////////////////////////////////////////////////
void
Komba2View::slotItemRemoved (QListViewItem * item)
{
  MyCopyItem *citem;
  // lstMounted all Item will be searched
  citem = (MyCopyItem *) myinfotab->lstMounted->firstChild ();
  while (citem)
    {
      if (citem->getCopyItem () == item)
	{
	  myinfotab->lstMounted->takeItem ((QListViewItem *) citem);
	  delete citem;
	  citem = 0;
	}
      else
	citem = (MyCopyItem *) ((QListViewItem *) citem)->nextSibling ();
    }
  // lstFound all Item will be searched
  citem = (MyCopyItem *) myinfotab->lstFound->firstChild ();
  while (citem)
    {
      if (citem->getCopyItem () == item)
	{
	  myinfotab->lstFound->takeItem ((QListViewItem *) citem);
	  delete citem;
	  citem = 0;
	}
      else
	citem = (MyCopyItem *) ((QListViewItem *) citem)->nextSibling ();
    }

}
