#include "plugin_speaker.h"

#include <kaction.h>
#include <kinstance.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <krun.h>
#include <kprocess.h>
#include <kprocio.h>
#include <khtml_part.h>
#include <iostream.h>
#include <ktempfile.h>
#include <qtextstream.h>
#include <qfile.h>
#include <kstddirs.h>

PluginSpeaker::PluginSpeaker( QObject* parent, const char* name )
  : Plugin( parent, name )
{
  KActionMenu *menu;
  menu = new KActionMenu( i18n("Spea&k Web Page"), "speaker",
                          actionCollection(), "speakwebpage" );
  menu->setDelayed( false );

  menu->insert( new KAction( i18n("Speak selecte&d"),ALT + Key_Plus ,
                             this, SLOT(slotSpeak()),
                             actionCollection()) );

  menu->insert( new KAction( i18n("Speak &all"), ALT + Key_Minus,
                             this, SLOT(slotSpeakAll()),
                             actionCollection()) );

  menu->insert( new KAction( i18n("Speak all with &ViaVoice"), 0,
                             this, SLOT(slotSpeakAllVV()),
                             actionCollection()) );
  menu->insert( new KAction( i18n("Speak with ViaVoic&e"), 0,
                             this, SLOT(slotSpeakVV()),
                             actionCollection()) );
 }

PluginSpeaker::~PluginSpeaker()
{
}

void PluginSpeaker::Error(const QString &title , const QString &text ){
    KMessageBox::sorry( 0L, text, title );
    return;
}

void PluginSpeaker::speak( )
{
  // The parent is assumed to be a KHTMLPart
  if ( !parent()->inherits("KHTMLPart") )
  {
    Error(i18n( "Cannot speak from source" ),
          i18n( "You cannot read anything except web pages with\n"
                "this plugin, sorry." )
    );
    return;
  }

  // Get URL
  KHTMLPart *part = dynamic_cast<KHTMLPart *>(parent());

  QString query;
  // we check if we have text selected.  if so, we use that.  if
  // not, we show error message
  if ( part->hasSelection() ){
    query = part->selectedText();

    KProcIO process;
     
    process << "festival"
            << "--tts";

    process.start(KProcess::DontCare);
    process.writeStdin(query);
    //process.writeStdin("This is a test message");
  }
  else
  {
    Error(i18n( "No selected Text" ),
          i18n( "There was no text selected to read, please "
                "correct it and try again" )
    );
    return;

  }

}

void PluginSpeaker::speakAllVV(){
  // The parent is assumed to be a KHTMLPart
  if ( !parent()->inherits("KHTMLPart") )
  {
   Error(i18n( "Cannot speak from source" ),
         i18n( "You cannot read anything except web pages with\n"
               "this plugin, sorry." )
   );
   return;
  }

  // Get URL
  KHTMLPart *part = dynamic_cast<KHTMLPart *>(parent());

  QString query;

  // select all text in the part.
    part->selectAll();
    query = part->selectedText();
  
    KProcess process;
    KStandardDirs dir;
    KTempFile temp;
    QString theFile = dir.findResource("tmp",temp.name());
    QFile f(theFile);  
    if ( !f.open( IO_WriteOnly ) ) {
      Error(i18n( "Cannot create file" ),
            i18n( "I cannot write to the temporary file")
                  
      );
      return;
    }
    
    QTextStream t( &f );
    t << query;
   
    process << "cmdlinespeakfile"
            << theFile;

      
    if (!process.start(KProcess::DontCare))
      Error(QString("Ooops"),QString("False returned"));
    f.close();
    temp.close();
    
  }

void PluginSpeaker::speakVV(){
// The parent is assumed to be a KHTMLPart
  if ( !parent()->inherits("KHTMLPart") )
  {
   Error(i18n( "Cannot speak from source" ),
         i18n( "You cannot read anything except web pages with\n"
               "this plugin, sorry." )
   );
   return;
  }

  // Get URL
  KHTMLPart *part = dynamic_cast<KHTMLPart *>(parent());

  QString query;

    query = part->selectedText();

  KProcess process;
    KStandardDirs dir;
    KTempFile temp;
    QString theFile = dir.findResource("tmp",temp.name());
    QFile f(theFile);  
    if ( !f.open( IO_WriteOnly ) ) {
      Error(i18n( "Cannot create file" ),
            i18n( "I cannot write to the temporary file")
                  
      );
      return;
    }
    
    QTextStream t( &f );
    t << query;
   
    process << "cmdlinespeakfile"
            << theFile;

      
    if (!process.start(KProcess::DontCare))
      Error(QString("Ooops"),QString("False returned"));
    f.close();
    temp.close();


}

void PluginSpeaker::speakAll( )
{
  // The parent is assumed to be a KHTMLPart
  if ( !parent()->inherits("KHTMLPart") )
  {
   Error(i18n( "Cannot speak from source" ),
         i18n( "You cannot read anything except web pages with\n"
               "this plugin, sorry." )
   );
   return;
  }

  // Get URL
  KHTMLPart *part = dynamic_cast<KHTMLPart *>(parent());

  QString query;

  // select all text in the part.
    part->selectAll();
    query = part->selectedText();

    KProcIO process;

    process << "festival"
            << "--tts";

    process.start(KProcess::DontCare);
    process.writeStdin(query);
    //process.writeStdin("This is a test message");
  }


void PluginSpeaker::slotSpeak() {
  speak();
}

void PluginSpeaker::slotSpeakAll() {
  speakAll();
}

void PluginSpeaker::slotSpeakAllVV() {
  speakAllVV();
}

void PluginSpeaker::slotSpeakVV() {
  speakVV();
}

SpeakerFactory::SpeakerFactory()
{
}

SpeakerFactory::~SpeakerFactory()
{
  delete s_instance;
  s_instance = 0;
}

QObject* SpeakerFactory::createObject( QObject* parent, const char* name, const char*, const QStringList & )
{
  return new PluginSpeaker( parent, name );
}

KInstance *SpeakerFactory::instance()
{
  if ( !s_instance )
    s_instance = new KInstance( "speaker" );
  return s_instance;
}

extern "C"
{
  void* init_libspeakerplugin()
  {
    return new SpeakerFactory;
  }
}

KInstance* SpeakerFactory::s_instance = 0L;

#include <plugin_speaker.moc>
