/***************************************************************************
                          mystatusbar.h  -  description
                             -------------------
    begin                : Tue Sep 12 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYSTATUSBAR_H
#define MYSTATUSBAR_H

#include <qwidget.h>
#include <kstatusbar.h>
#include <qstatusbar.h>

/**
  *@author Luc Langehegermann
	*
	* An Statusbar, similar to the KStatusBar, but with tooltip support
  * 99,9% of the code is from the KStatusBar by Sven Radej / Mark Donohoe
	*
  */

class myStatusBar : public QStatusBar  {
   Q_OBJECT
public: 
	myStatusBar(QWidget *parent=0, const char *name=0);
	~myStatusBar();

/**
*  Construct KStatusBar object. @p parent is usually @ref KTMainWindow.
*  @see KTMainWindow::setStatusBar
*/

/**
*  Insert text label into the status bar.
*  Paremeters @p stretch and  @p permanent are passed to
*  @ref QStatusBar::addWidget .
*
*  If @p permanent is true, then item will be placed on the far right of
*  the statusbar and will never be hidden by @ref QStatusBar::message.
*
*  @param id id of item
*  @param stretch stretch passed to @ref QStatusBar::addWidget
*  @param permanent is item permanent or not (passed to @ref QStatusBar::addWidget )
*
*  @see QStatusbar::addWidget
*
*/
void insertItem(const QString& text, int id, int stretch=0, bool permanent=false );

/**
*  Insert fixed width text label into status bar. The width will be set
*  according to @p text, but will remain fixed even if you change text.
*  You can change fixed width by calling @ref setItemFixed.
*  @param id id ov item
*  @param permanent permanent flag passed to QStatusBar::addWidget
*/
inline void insertFixedItem(const QString& text, int id, bool permanent=false)
{ insertItem(text, id, 0, permanent); setItemFixed(id); }

/**
*  Remove an item.
*
* @param id The item to remove.
*/
void removeItem( int id );

/**
* Change the text in a status bar field.
*
* The item will be resized to fit the text. If you change text to be empty,
* item will not be visible (untill you add some text).
*
* @param id The id of item.
*/
void changeItem( const QString& text, int id );

/**
* Sets the alignment of item @p id. By default all fields are aligned
* @p AlignHCenter | @p AlignVCenter. See @ref QLabel::setAlignment for details.
*
*/
void setItemAlignment(int id, int align);

/**
* Sets item @p id to have fixed width. This cannot be undone, but you can
* always set new fixed width.
*
* @param id id of item
* @param width fixed width in pixels. Default -1 is to adapt to text width.
*/
void setItemFixed(int id, int width=-1);
  /**  */
  void setToolTip (int id, QString str);

signals:

/**
*  Emitted when mouse is pressed over item @p id.
*
*  Connect to this signal if you want to respond to mouse press events.
*
*/
void pressed( int );

/**
*  Emitted when mouse is released over item @p id.
*
*  Connect to this signal if you want to respond to mouse release events (clicks).
*/
void released( int );


protected slots:

void slotPressed (int id);
void slotReleased (int id);

private:
QIntDict<KStatusBarLabel> items;
};

#endif // __KSTATUSBAR_H__
