/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


void KstSettingsDlg::init()
{
    fillAxesSettings();
    setSettings(KstSettings::globalSettings());
    updateAxesButtons();
    updateAxesSettings();
    _source->insertStringList(KstDataSource::pluginList());
    if (_source->count() > 0) {
	sourceChanged(_source->text(0));
    } else {
	_configureSource->setEnabled(false);
    }
    _apply->setEnabled(false);
}


void KstSettingsDlg::setSettings(const KstSettings *settings)
{
    _timer->setValue(settings->plotUpdateTimer);
    _colors->setBackground(settings->backgroundColor);
    _colors->setForeground(settings->foregroundColor);
    _promptWindowClose->setChecked(settings->promptWindowClose);
    _showQuickStart->setChecked(settings->showQuickStart);

    _xMajorGrid->setChecked(settings->xMajor);
    _yMajorGrid->setChecked(settings->yMajor);
    _xMinorGrid->setChecked(settings->xMinor);
    _yMinorGrid->setChecked(settings->yMinor);
    _majorGridColor->setColor(settings->majorColor);
    _minorGridColor->setColor(settings->minorColor);
    _checkBoxDefaultMajorGridColor->setChecked(settings->majorGridColorDefault);
    _checkBoxDefaultMinorGridColor->setChecked(settings->minorGridColorDefault);

    _checkBoxXInterpret->setChecked(settings->xAxisInterpret);
    _comboBoxXInterpret->setCurrentItem(settings->xAxisInterpretation);
    _comboBoxXDisplay->setCurrentItem(settings->xAxisDisplay);    
}


void KstSettingsDlg::defaults()
{
    KstSettings s;
    setSettings(&s);
    setDirty();
}


void KstSettingsDlg::setDirty()
{
    _apply->setEnabled(true);
}


void KstSettingsDlg::setClean()
{
    _apply->setEnabled(false);
}


void KstSettingsDlg::save()
{
    KstSettings s;
    s.plotUpdateTimer   = _timer->value();
    s.backgroundColor   = _colors->background();
    s.foregroundColor   = _colors->foreground();
    s.promptWindowClose = _promptWindowClose->isChecked();
    s.showQuickStart    = _showQuickStart->isChecked();
    s.xMajor            = _xMajorGrid->isChecked();
    s.yMajor            = _yMajorGrid->isChecked();
    s.xMinor            = _xMinorGrid->isChecked();
    s.yMinor            = _yMinorGrid->isChecked();
    s.majorColor        = _majorGridColor->color();
    s.minorColor        = _minorGridColor->color();
    s.majorGridColorDefault = _checkBoxDefaultMajorGridColor->isChecked();
    s.minorGridColorDefault = _checkBoxDefaultMinorGridColor->isChecked();
    s.xAxisInterpret        = _checkBoxXInterpret->isChecked();
    s.xAxisInterpretation   = (KstXAxisInterpretation)(_comboBoxXInterpret->currentItem());
    s.xAxisDisplay          = (KstXAxisDisplay)(_comboBoxXDisplay->currentItem());

    KstSettings::setGlobalSettings(&s);
    KstSettings::globalSettings()->save();
    emit settingsChanged();
}


void KstSettingsDlg::updateAxesButtons()
{
    bool major = _xMajorGrid->isChecked() || _yMajorGrid->isChecked();
    bool minor = _xMinorGrid->isChecked() || _yMinorGrid->isChecked();

    _checkBoxDefaultMajorGridColor->setEnabled(major);
    _checkBoxDefaultMinorGridColor->setEnabled(minor);
    _majorGridColor->setEnabled(major && !_checkBoxDefaultMajorGridColor->isChecked());
    _minorGridColor->setEnabled(minor && !_checkBoxDefaultMinorGridColor->isChecked());
}


void KstSettingsDlg::updateAxesSettings()
{
    bool interpret = _checkBoxXInterpret->isChecked();

    _comboBoxXInterpret->setEnabled(interpret);
    _comboBoxXDisplay->setEnabled(interpret);
}


void KstSettingsDlg::fillAxesSettings()
{
    unsigned int i;

    for (i = 0; i < numXAxisInterpretations; i++) {
	_comboBoxXInterpret->insertItem(i18n(XAxisInterpretations[i].label));
    }
    for (i = 0; i < numXAxisDisplays; i++) {
	_comboBoxXDisplay->insertItem(i18n(XAxisDisplays[i].label));
    }
}


void KstSettingsDlg::configureSource()
{
    KstDataSourceConfigWidget *cw = KstDataSource::configWidgetForPlugin(_source->currentText());
    if (!cw) {
	return;
    }
    KDialogBase *dlg = new KDialogBase(this, "Data Config Dialog", true, i18n("Configure Data Source"));
    connect(dlg, SIGNAL(okClicked()), cw, SLOT(save()));
    connect(dlg, SIGNAL(applyClicked()), cw, SLOT(save()));
    cw->reparent(dlg, QPoint(0, 0));
    dlg->setMainWidget(cw);
    dlg->exec();
    delete dlg;
}


void KstSettingsDlg::sourceChanged(const QString& name)
{
    // FIXME: inefficient
    KstDataSourceConfigWidget *cw = KstDataSource::configWidgetForPlugin(name);
    _configureSource->setEnabled(cw != 0L);
    delete cw;
}

// vim: ts=8 sw=4 noet
